
* PROGRAM: COST_SHARING_COMPREHENSIVE_DENTAL.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR COMPREHENSIVE DENTAL CLAIMS;


%MACRO DENTAL_COMP_COST_SHARE(SERV_CAT);

  DATA DENTAL_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY IN('16','16b')));
    SRVCNT = SUM(DVPERIOD,DVEXTRAC,DVRTCNAL,DVCROWN,DVBRIDGE,DVOTHER,DVORTHO,DVCLEAN,DVEXAM,DVXRAYS,DVFILLNG);
    IF CATEGORY='16' THEN CATEGORY='16a';
  RUN;

  DATA DENTAL_FILE (DROP=PBP_D_MAND_DEDUCT_16B1_AMT
                   PBP_D_MAND_DEDUCT_16B2_AMT
                   PBP_D_MAND_DEDUCT_16B3_AMT
                   PBP_D_MAND_DEDUCT_16B4_AMT
                   PBP_D_MAND_DEDUCT_16B5_AMT
                   PBP_D_MAND_DEDUCT_16B6_AMT
                   PBP_D_MAND_DEDUCT_16B7_AMT
                   );
    SET PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B16A_MAXENR_AMT PBP_B16A_MAXENR_PER
                   PBP_B16B_MAXENR_AMT PBP_B16B_MAXENR_PER
                   PBP_B16B_COPAY_AMT_MC_MIN PBP_B16B_COINS_PCT_MC_MIN
                   PBP_B16A_BENDESC_AMO_PC PBP_B16A_BENDESC_AMO_DX PBP_B16A_BENDESC_AMO_OE
                   PBP_B16B_MAXBENE_TYPE PBP_B16B_BENDESC_AMO_END PBP_B16B_BENDESC_AMO_EXT 
                   PBP_B16B_BENDESC_AMO_PERI PBP_B16B_BENDESC_AMO_RS
                   PBP_B16B_BENDESC_AMO_POO
                   PBP_B16A_COPAY_AMT_PCMIN
                   PBP_B16A_COPAY_AMT_DXMIN
                   PBP_B16A_COPAY_AMT_OEMIN
                   PBP_B16B_COPAY_AMT_END_MIN
                   PBP_B16B_COPAY_AMT_EXT_MIN
                   PBP_B16B_COPAY_AMT_PERI_MIN
                   PBP_B16B_COPAY_AMT_RS_MIN
                   PBP_B16B_COPAY_AMT_POO_MIN
                   PBP_B16A_COINS_PCT_PC PBP_B16A_DED_AMT PBP_B16B_DED_AMT
                   PBP_B16A_COINS_PCT_DX
                   PBP_B16A_COINS_PCT_OE
                   PBP_B16B_COINS_PCT_END_MIN
                   PBP_B16B_COINS_PCT_EXT_MIN
                   PBP_B16B_COINS_PCT_PERI_MIN
                   PBP_B16B_COINS_PCT_RS_MIN
                   PBP_B16B_COINS_PCT_POO_MIN
                   PBP_B16A_COPAY_AMT_OVMIN
                   PBP_B16A_COPAY_AMT_OVMAX
                   PBP_B16A_COINS_PCT_MINOV
                   PBP_B16A_COINS_PCT_MAXOV
                   PBP_B16A_COINS_CSERV_SC_POV
                   PBP_B16A_COPAY_CSERV_SC_POV
                   PBP_B16A_MAXPLAN_AMT
                   PBP_B16A_MAXPLAN_PER
                   PBP_B16B_MAXPLAN_AMT
                   PBP_B16B_MAXPLAN_PER
                   PBP_B16B_MAXBENE_TYPE
                   PBP_B16B_MAXENR_TYPE
    
                   PBP_B16A_BENDESC_NUMV_OE
                   PBP_B16A_BENDESC_NUMV_PC
                   PBP_B16A_BENDESC_NUMV_DX
                   PBP_B16B_BENDESC_NUMV_RS
                   PBP_B16B_BENDESC_NUM_END
                   PBP_B16B_BENDESC_NUM_EXT
                   PBP_B16B_BENDESC_NUM_PERI
                   PBP_B16B_BENDESC_NUMV_POO
                   PBP_B16A_BENDESC_PER_OE
                   PBP_B16A_BENDESC_PER_PC
                   PBP_B16A_BENDESC_PER_DX
                   PBP_B16B_BENDESC_PER_RS
                   PBP_B16B_BENDESC_PER_END
                   PBP_B16B_BENDESC_PER_EXT
                   PBP_B16B_BENDESC_PER_PERI
                   PBP_B16B_BENDESC_PER_POO
                 
                   PBP_B16A_COPAY_EHC
                   PBP_B16A_COINS_EHC
                   PBP_B16B_COPAY_EHC
                   PBP_B16B_COINS_EHC
                   PBP_A_PLAN_TYPE
                   PBP_D_DIFF_DEDUCT_16B_AMT
                   PBP_D_MAND_DEDUCT_16B1_AMT
                   PBP_D_MAND_DEDUCT_16B2_AMT
                   PBP_D_MAND_DEDUCT_16B3_AMT
                   PBP_D_MAND_DEDUCT_16B4_AMT
                   PBP_D_MAND_DEDUCT_16B5_AMT
                   PBP_D_MAND_DEDUCT_16B6_AMT
                   PBP_D_MAND_DEDUCT_16B7_AMT);
    JOIN_ID = '1';
    
    ARRAY MX PBP_B16A_BENDESC_NUMV_OE PBP_B16A_BENDESC_NUMV_PC PBP_B16A_BENDESC_NUMV_DX
             PBP_B16B_BENDESC_NUMV_RS PBP_B16B_BENDESC_NUM_END PBP_B16B_BENDESC_NUM_EXT 
             PBP_B16B_BENDESC_NUM_PERI PBP_B16B_BENDESC_NUMV_POO
             PBP_B16A_MAXENR_AMT PBP_B16B_MAXENR_AMT PBP_B16A_MAXPLAN_AMT PBP_B16B_MAXPLAN_AMT;
    ARRAY PX PBP_B16A_BENDESC_PER_OE PBP_B16A_BENDESC_PER_PC PBP_B16A_BENDESC_PER_DX
             PBP_B16B_BENDESC_PER_RS PBP_B16B_BENDESC_PER_END PBP_B16B_BENDESC_PER_EXT 
             PBP_B16B_BENDESC_PER_PERI PBP_B16B_BENDESC_PER_POO
             PBP_B16A_MAXENR_PER PBP_B16B_MAXENR_PER PBP_B16A_MAXPLAN_PER PBP_B16B_MAXPLAN_PER;
  
    DO I = 1 TO 12;
      IF MX(I) NE . THEN DO;
        IF PX(I)  = '1' THEN MX(I) = MX(I)  / 3; * EVERY THREE YEARS;
        ELSE IF PX(I)  = '2' THEN MX(I) = MX(I)  / 2; * EVERY TWO YEARS;
        ELSE IF PX(I)  = '3' THEN MX(I) = MX(I) / 1; * EVERY YEAR;
        ELSE IF PX(I)  = '4' THEN MX(I) = MX(I)  * 2; * EVERY SIX MONTHS;
        ELSE IF PX(I)  = '5' THEN MX(I) = MX(I)  * 4; * EVERY THREE MONTHS;
        ELSE IF PX(I)  = '6' THEN MX(I) = MX(I) ; * OTHER;
        ELSE IF PX(I)  = '7' THEN MX(I) = MX(I)  * 12; * EVERY MONTH;        
      END;
    END;
    
    PBP_D_DEDUCT_COMPDENTAL_AMT=SUM(PBP_D_MAND_DEDUCT_16B1_AMT, PBP_D_MAND_DEDUCT_16B2_AMT,
      PBP_D_MAND_DEDUCT_16B3_AMT, PBP_D_MAND_DEDUCT_16B4_AMT, PBP_D_MAND_DEDUCT_16B5_AMT, 
      PBP_D_MAND_DEDUCT_16B6_AMT, PBP_D_MAND_DEDUCT_16B7_AMT);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.YEAR, B.VISITS, B.AMTTOT, B.DVCLEAN, B.DVEXAM, B.DVXRAYS, B.DVFILLNG,
      B.DVPERIOD, B.DVEXTRAC, B.DVRTCNAL, B.DVCROWN, B.DVBRIDGE, B.DVOTHER, B.DVORTHO, B.SRVCNT, B.PREVENT_DENTAL_SHARE, P.*
      FROM DENTAL_BASEID B, DENTAL_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;
  
  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY IN ('16a','16b')));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;
  
  DATA &SERV_CAT;
    ARRAY MX PBP_B16A_BENDESC_NUMV_OE PBP_B16A_BENDESC_NUMV_PC PBP_B16A_BENDESC_NUMV_DX
          PBP_B16B_BENDESC_NUMV_RS PBP_B16B_BENDESC_NUM_END PBP_B16B_BENDESC_NUM_EXT 
          PBP_B16B_BENDESC_NUM_PERI PBP_B16B_BENDESC_NUMV_POO
          PBP_B16A_MAXENR_AMT PBP_B16B_MAXENR_AMT PBP_B16A_MAXPLAN_AMT PBP_B16B_MAXPLAN_AMT;
    ARRAY SX SERVICE_MAX_OE SERVICE_MAX_PC SERVICE_MAX_DX
          SERVICE_MAX_RS SERVICE_MAX_END SERVICE_MAX_EXT SERVICE_MAX_PERI SERVICE_MAX_POO
          BENE_MAXIMUM_P BENE_MAXIMUM_C PLAN_MAXIMUM_P PLAN_MAXIMUM_C;
    SET CAT_JOIN (DROP = JOIN_ID);
    
    COMP_SERVICE_CNT = SUM(DVFILLNG, DVPERIOD, DVEXTRAC, DVRTCNAL, DVCROWN, DVBRIDGE, DVOTHER, DVORTHO);
    IF COMP_SERVICE_CNT>0;
    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DEDUCT_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DEDUCT_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_16B_AMT;
    ELSE CAT_DEDUCTIBLE=PBP_B16B_DED_AMT;
    
    COST=0;
    CAT_DEDUCTIBLE_SUP=0;
    IF PBP_D_DEDUCT_COMPDENTAL_AMT>0 THEN CAT_DEDUCTIBLE_SUP=PBP_D_DEDUCT_COMPDENTAL_AMT;
    
    IF CATEGORY='16b' THEN DO;
      IF CAT_DEDUCTIBLE = . THEN DO;
        IF PBP_B16B_MAXENR_AMT ^ = . THEN BENE_MAX = PBP_B16B_MAXENR_AMT;
        IF SUBSTR(PBP_B16B_COPAY_EHC,2,1)='1' THEN COST = SUM(COST, VISITS * PBP_B16B_COPAY_AMT_MC_MIN);
        IF SUBSTR(PBP_B16B_COINS_EHC,2,1)='1' THEN COST = SUM(COST, AMTTOT * PBP_B16B_COINS_PCT_MC_MIN);
        IF BENE_MAX >= 0 AND COST >= 0 THEN COST = MIN(COST, BENE_MAX);
        COST_SHARE_COST_MC  = COST;
      END;
      ELSE DO;
        IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
          COST = AMTTOT;
          IF BENE_MAX >= 0 AND COST >= 0 THEN COST = MIN(COST, BENE_MAX);
          COST_SHARE_COST_MC  = COST;
        END;
        ELSE DO;
          COST = CAT_DEDUCTIBLE;
          DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
          AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
          VISITS = VISITS * (1 - DEDUCT_SHARE);
          IF SUBSTR(PBP_B16B_COPAY_EHC,2,1)='1' THEN COST = SUM(COST, VISITS * PBP_B16B_COPAY_AMT_MC_MIN);
	  IF SUBSTR(PBP_B16B_COINS_EHC,2,1)='1' THEN COST = SUM(COST, AMTTOT * PBP_B16B_COINS_PCT_MC_MIN);
	  IF BENE_MAX >= 0 AND COST >= 0 THEN COST = MIN(COST, BENE_MAX);
          COST_SHARE_COST_MC  = COST;
        END;
      END;
    END;
    
    ELSE DO;
      DO I = 1 TO 12;
        IF MX(I) NE . THEN DO;
         SX(I) = MX(I);
        END;
      END;

      * PER_SERVICE_AMT = AMTTOT / SRVCNT;

      NONCOV_COST = 0;

      PREV_SERVICE_CNT = SUM(DVCLEAN,DVEXAM,DVXRAYS);
      COMP_SERVICE_CNT = SUM(DVFILLNG,DVPERIOD,DVEXTRAC,DVRTCNAL,DVCROWN,DVBRIDGE,DVOTHER,DVORTHO);
     
      AMTTOT_PREV = PREVENT_DENTAL_SHARE * AMTTOT; 
      AMTTOT_COMP = (1-PREVENT_DENTAL_SHARE) * AMTTOT;

      PER_SERVICE_AMT = AMTTOT_COMP / COMP_SERVICE_CNT;

      IF SUM(AMTTOT_PREV,AMTTOT_COMP)>0 THEN 
        COMPREHENSIVE_SHARE=(1-PREVENT_DENTAL_SHARE);
      ELSE COMPREHENSIVE_SHARE=0;
      
      IF PBP_B16B_MAXBENE_TYPE = '1' THEN PLAN_MAXIMUM_C=PLAN_MAXIMUM_P*COMPREHENSIVE_SHARE;

      ARRAY DC DVPERIOD DVEXTRAC DVRTCNAL DVCROWN DVBRIDGE DVOTHER DVORTHO DVFILLNG;
        
      IF AMTTOT_COMP <= SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP) THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,AMTTOT_COMP);
        DO OVER DC;
          DC = 0;
        END;
      END;
      ELSE IF CAT_DEDUCTIBLE > 0 THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP));
        DED_SHARE = SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP) / AMTTOT_COMP;
        AMTTOT_COMP = SUM(AMTTOT_COMP,-(SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP)));
        DO OVER DC;
          DC = DC * (1 - DED_SHARE);
        END;
      END;
    
      * APPLY SERVICE COUNT MAX FIRST;
      IF SERVICE_MAX_RS > 0 AND SERVICE_MAX_RS < DVFILLNG THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVFILLNG,-SERVICE_MAX_RS) * PER_SERVICE_AMT);
        DVFILLNG = SERVICE_MAX_RS;
      END;
      IF SERVICE_MAX_END > 0 AND SERVICE_MAX_END < DVRTCNAL THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVRTCNAL,-SERVICE_MAX_END) * PER_SERVICE_AMT);
        DVRTCNAL_OLD = DVRTCNAL;
        DVRTCNAL = SERVICE_MAX_END * (DVRTCNAL/DVRTCNAL_OLD);
      END;
      IF SERVICE_MAX_EXT > 0 AND SERVICE_MAX_EXT < DVEXTRAC THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVEXTRAC,-SERVICE_MAX_EXT) * PER_SERVICE_AMT);
        DVEXTRAC_OLD = DVEXTRAC;
        DVEXTRAC = SERVICE_MAX_EXT * (DVEXTRAC/DVEXTRAC_OLD);
      END;
      IF SERVICE_MAX_PERI > 0 AND SERVICE_MAX_PERI < DVPERIOD THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVPERIOD,-SERVICE_MAX_PERI) * PER_SERVICE_AMT);
        DVPERIOD_OLD = DVPERIOD;
        DVPERIOD = SERVICE_MAX_PERI * (DVPERIOD/DVPERIOD_OLD);
      END;      
      IF SERVICE_MAX_POO > 0 AND SERVICE_MAX_POO < SUM(DVCROWN,DVBRIDGE,DVOTHER,DVORTHO) THEN DO;
        NONCOV_COST = SUM(NONCOV_COST,SUM(DVCROWN,DVBRIDGE,DVOTHER,DVORTHO,-SERVICE_MAX_POO) * PER_SERVICE_AMT);
        DVCROWN_OLD = DVCROWN;
        DVBRIDGE_OLD = DVBRIDGE;
        DVOTHER_OLD = DVOTHER;
        DVORTHO_OLD = DVORTHO;
        DVCROWN = SERVICE_MAX_POO * (DVCROWN/SUM(DVCROWN_OLD,DVBRIDGE_OLD,DVOTHER_OLD,DVORTHO_OLD));
        DVBRIDGE = SERVICE_MAX_POO * (DVBRIDGE/SUM(DVCROWN_OLD,DVBRIDGE_OLD,DVOTHER_OLD,DVORTHO_OLD));
        DVOTHER = SERVICE_MAX_POO * (DVOTHER/SUM(DVCROWN_OLD,DVBRIDGE_OLD,DVOTHER_OLD,DVORTHO_OLD));
        DVORTHO = SERVICE_MAX_POO * (DVORTHO/SUM(DVCROWN_OLD,DVBRIDGE_OLD,DVOTHER_OLD,DVORTHO_OLD));
      END;

      COMP_SERVICE_CNT = SUM(DVFILLNG, DVPERIOD, DVEXTRAC, DVRTCNAL, DVCROWN, DVBRIDGE, DVOTHER, DVORTHO);
      AMTTOT_COMP = COMP_SERVICE_CNT * PER_SERVICE_AMT;

      NONCOV_COST_MAXDOL = 0;
      NONCOV_COST_MAXDOL_C = 0;

      * APPLY PLAN MAXIMUM;
      IF PBP_B16B_MAXBENE_TYPE = '1' THEN DO;
        NONCOV_COST_MAXDOL = SUM(NONCOV_COST_MAXDOL,MAX(0,SUM(AMTTOT_COMP,-PLAN_MAXIMUM_C)));
        
        IF AMTTOT_COMP>0 THEN 
          COVERED_SHARE_C = SUM(AMTTOT_COMP,-NONCOV_COST_MAXDOL)/AMTTOT_COMP;

        DO OVER DC;
          DC = DC * COVERED_SHARE_C;
        END;
      END;
      ELSE DO;
        IF PLAN_MAXIMUM_C > 0 THEN NONCOV_COST_MAXDOL_C = MAX(0,SUM(AMTTOT_COMP,-PLAN_MAXIMUM_C));

        NONCOV_COST_MAXDOL = NONCOV_COST_MAXDOL_C;

        IF AMTTOT_COMP > 0 THEN
          COVERED_SHARE_C = SUM(AMTTOT_COMP,-NONCOV_COST_MAXDOL_C) / AMTTOT_COMP;
      
        DO OVER DC;
          DC = DC * COVERED_SHARE_C;
        END;
      END;
     
      *APPLY INDIVIDUAL COSTS FOR COMP BENEFITS;
     
      ENDO_COST_SHARE = 0;
    
      IF DVEXTRAC > 0 THEN DO;
        IF PBP_B16B_BENDESC_AMO_EXT IN('2','4') THEN DO;
          IF SUBSTR(PBP_B16B_COINS_EHC,8,1)='1' THEN ENDO_COST_SHARE=
            SUM(ENDO_COST_SHARE,PER_SERVICE_AMT*DVEXTRAC*PBP_B16B_COINS_PCT_EXT_MIN);
          IF SUBSTR(PBP_B16B_COPAY_EHC,8,1)='1' THEN ENDO_COST_SHARE=
            SUM(ENDO_COST_SHARE,PBP_B16B_COPAY_AMT_EXT_MIN*DVEXTRAC);
        END;
        ELSE DO;
          ENDO_OTHER_COST = PER_SERVICE_AMT * DVEXTRAC;
        END;
      END;

      IF DVRTCNAL > 0 THEN DO;
        IF PBP_B16B_BENDESC_AMO_END IN('2','4') THEN DO;
          IF SUBSTR(PBP_B16B_COINS_EHC,6,1)='1' THEN ENDO_COST_SHARE=
            SUM(ENDO_COST_SHARE,PER_SERVICE_AMT*DVRTCNAL*PBP_B16B_COINS_PCT_END_MIN);
          IF SUBSTR(PBP_B16B_COPAY_EHC,6,1)='1' THEN ENDO_COST_SHARE=
            SUM(ENDO_COST_SHARE,PBP_B16B_COPAY_AMT_END_MIN*DVRTCNAL);
        END;
        ELSE DO;
          ENDO_OTHER_COST = SUM(ENDO_OTHER_COST,PER_SERVICE_AMT * DVRTCNAL);
        END;
      END;
      
      IF DVPERIOD > 0 THEN DO;
        IF PBP_B16B_BENDESC_AMO_PERI IN('2','4') THEN DO;
          IF SUBSTR(PBP_B16B_COINS_EHC,7,1)='1' THEN ENDO_COST_SHARE=
            SUM(ENDO_COST_SHARE,PER_SERVICE_AMT*DVPERIOD*PBP_B16B_COINS_PCT_PERI_MIN);
          IF SUBSTR(PBP_B16B_COPAY_EHC,7,1)='1' THEN ENDO_COST_SHARE=
            SUM(ENDO_COST_SHARE,PBP_B16B_COPAY_AMT_PERI_MIN*DVPERIOD);
        END;
        ELSE DO;
          ENDO_OTHER_COST = SUM(ENDO_OTHER_COST,PER_SERVICE_AMT * DVPERIOD);
        END;
      END;      
  
      FILL_COST_SHARE = 0;
      
      IF DVFILLNG > 0 THEN DO;
        IF PBP_B16B_BENDESC_AMO_RS IN('2','4') THEN DO;
          IF SUBSTR(PBP_B16B_COINS_EHC,5,1)='1' THEN FILL_COST_SHARE=
            SUM(FILL_COST_SHARE,PER_SERVICE_AMT*DVFILLNG*PBP_B16B_COINS_PCT_RS_MIN);
          IF SUBSTR(PBP_B16B_COPAY_EHC,5,1)='1' THEN FILL_COST_SHARE=
            SUM(FILL_COST_SHARE,PBP_B16B_COPAY_AMT_RS_MIN*DVFILLNG);
        END;
        ELSE DO;
          FILL_OTHER_COST = PER_SERVICE_AMT * DVFILLNG;
        END;
      END;

      PROS_COST_SHARE = 0;
      
      IF DVCROWN > 0 THEN DO;
        IF PBP_B16B_BENDESC_AMO_POO IN('2','4') THEN DO;
          IF SUBSTR(PBP_B16B_COINS_EHC,1,1)='1' THEN PROS_COST_SHARE=
            SUM(PROS_COST_SHARE,PER_SERVICE_AMT*DVCROWN*PBP_B16B_COINS_PCT_POO_MIN);
          IF SUBSTR(PBP_B16B_COPAY_EHC,1,1)='1' THEN PROS_COST_SHARE=
            SUM(PROS_COST_SHARE,PBP_B16B_COPAY_AMT_POO_MIN*DVCROWN);
        END;
        ELSE DO;
          PROS_OTHER_COST = PER_SERVICE_AMT * DVCROWN;
        END;
      END;

      IF DVBRIDGE > 0 THEN DO;
        IF PBP_B16B_BENDESC_AMO_POO IN('2','4') THEN DO;
          IF SUBSTR(PBP_B16B_COINS_EHC,1,1)='1' THEN PROS_COST_SHARE=
            SUM(PROS_COST_SHARE,PER_SERVICE_AMT*DVBRIDGE*PBP_B16B_COINS_PCT_POO_MIN);
          IF SUBSTR(PBP_B16B_COPAY_EHC,1,1)='1' THEN PROS_COST_SHARE=
            SUM(PROS_COST_SHARE,PBP_B16B_COPAY_AMT_POO_MIN*DVBRIDGE);
        END;
        ELSE DO;
          PROS_OTHER_COST = SUM(PROS_OTHER_COST,PER_SERVICE_AMT * DVBRIDGE);
        END;
      END;

      IF DVOTHER > 0 THEN DO;
        IF PBP_B16B_BENDESC_AMO_POO IN('2','4') THEN DO;
          IF SUBSTR(PBP_B16B_COINS_EHC,1,1)='1' THEN PROS_COST_SHARE=
            SUM(PROS_COST_SHARE,PER_SERVICE_AMT*DVOTHER*PBP_B16B_COINS_PCT_POO_MIN);
          IF SUBSTR(PBP_B16B_COPAY_EHC,1,1)='1' THEN PROS_COST_SHARE=
            SUM(PROS_COST_SHARE,PBP_B16B_COPAY_AMT_POO_MIN*DVOTHER);
        END; 
        ELSE DO;
          PROS_OTHER_COST = SUM(PROS_OTHER_COST,PER_SERVICE_AMT * DVOTHER);
        END;
      END;
 
      IF DVORTHO > 0 THEN DO;
        IF PBP_B16B_BENDESC_AMO_POO IN('2','4') THEN DO;
          IF SUBSTR(PBP_B16B_COINS_EHC,1,1)='1' THEN PROS_COST_SHARE=
            SUM(PROS_COST_SHARE,PER_SERVICE_AMT*DVORTHO*PBP_B16B_COINS_PCT_POO_MIN);
          IF SUBSTR(PBP_B16B_COPAY_EHC,1,1)='1' THEN PROS_COST_SHARE=
            SUM(PROS_COST_SHARE,PBP_B16B_COPAY_AMT_POO_MIN*DVORTHO);
        END;
        ELSE DO;
          PROS_OTHER_COST = SUM(PROS_OTHER_COST,PER_SERVICE_AMT * DVORTHO);
        END;
      END;

      COST_SHARE_COST_C = SUM(ENDO_COST_SHARE,FILL_COST_SHARE,PROS_COST_SHARE);

      OTHER_COST = SUM(ENDO_OTHER_COST, FILL_OTHER_COST, PROS_OTHER_COST, NONCOV_COST, NONCOV_COST_MAXDOL);
      
      COST_SHARE_COST_AMO = COST_SHARE_COST_C;
    END;
   
    IF BENE_MAXIMUM_C>0 & SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO)>0 THEN DO;
      COST_SHARE_COST_MC=
        MIN(COST_SHARE_COST_MC,BENE_MAXIMUM_C*(COST_SHARE_COST_MC/SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO)));
      COST_SHARE_COST_AMO=
        MIN(COST_SHARE_COST_AMO,BENE_MAXIMUM_C*(COST_SHARE_COST_AMO/SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO)));
    END;
    
    COST_SHARE_COST=SUM(COST_SHARE_COST_MC,COST_SHARE_COST_AMO);
        
    CATEGORY = "16b";

  RUN;
  
  PROC SORT DATA = DENTAL;
    BY HPLAN;
  RUN;

  PROC SUMMARY DATA = DENTAL NWAY MISSING;
    CLASS YEAR BASEID;
    BY HPLAN;
    VAR COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO OTHER_COST AMTTOT;
    ID CATEGORY;
    OUTPUT OUT = TOTDENTAL(RENAME = _FREQ_=RCCNT) SUM = ;
  RUN;

  DATA TOTDENTAL;
    RETAIN COST 0;
    SET TOTDENTAL;
  RUN;

  PROC APPEND DATA=TOTDENTAL(KEEP=HPLAN YEAR BASEID COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
     OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE DENTAL TOTDENTAL DENTAL_BASEID DENTAL_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;



