
* PROGRAM: COST_SHARING_MEDICARE_BDRUGS_INSULIN.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR IDRUGS CLAIMS;


%MACRO IDRUGS_COST_SHARE(SERV_CAT);

  PROC SUMMARY DATA=&INC NWAY MISSING;
    WHERE CATEGORY IN('15m','15c','15i');
    CLASS BASEID YEAR;
    VAR AMTTOT;
    OUTPUT OUT=CAT_SUMMARY (DROP=_TYPE_ _FREQ_) SUM=;
  RUN;
  
  %obsnvars(CAT_SUMMARY);
  
  DATA FMTDATA;
    SET CAT_SUMMARY END=LAST;
    LENGTH HLO $1 START $12;
    FMTNAME='$CATFMT';
    START=BASEID || YEAR;
    LABEL=AMTTOT;
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL=0;
      HLO='O';
      OUTPUT;
    END;
    KEEP FMTNAME START LABEL HLO;
  RUN;
  
  PROC FORMAT CNTLIN=FMTDATA;
  RUN;
  
  DATA IDRUGS_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY in ('15i')));
  RUN;
 
  DATA IDRUGS_FILE;
    SET PBP_FILE(KEEP =
                 CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                 PBP_A_PLAN_TYPE
                 MRX_B_IRA_COINS_MIN_PCT
                 MRX_B_IRA_COPAY_MONTH_AMT
                 MRX_B_IRA_COPAY_AMT_MIN
                 MRX_B_MAX_OOP_PER
                 MRX_B_MAX_OOP_AMT
                 );
    JOIN_ID = '1';
    %ANNUALIZATION(MRX_B_MAX_OOP_PER,MRX_B_MAX_OOP_AMT);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM IDRUGS_BASEID B, IDRUGS_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;

  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;
    CAT_DEDUCTIBLE=0;
    
    BASEIDYR=BASEID || YEAR;
    %IF "&NOBS." > "0" %THEN %DO;
      PBPCAT_AMTTOT=INPUT(PUT(BASEIDYR,$CATFMT.),8.);
    %END;
    %ELSE %DO;
      PBPCAT_AMTTOT=0;
    %END;

    IF MRX_B_MAX_OOP_AMT ^= . THEN BENE_MAX = MRX_B_MAX_OOP_AMT;
    
    IF PBPCAT_AMTTOT>0 THEN
      BENE_MAX=BENE_MAX*(AMTTOT/PBPCAT_AMTTOT);

    COST = SUM(COST,(VISITS*MRX_B_IRA_COPAY_AMT_MIN));
    COST = SUM(COST,MIN((AMTTOT*MRX_B_IRA_COINS_MIN_PCT),(VISITS*MRX_B_IRA_COPAY_MONTH_AMT)));

    IF BENE_MAX >= 0 AND COST >= 0 THEN COST = MIN(COST, BENE_MAX);
    COST = MIN(COST,35*VISITS);

    COST_SHARE_COST = COST;
    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "15i";
  RUN;

  PROC APPEND DATA=IDRUGS(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT) BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE IDRUGS IDRUGS_BASEID IDRUGS_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;



