
* PROGRAM: COST_SHARING_SPECIALIST.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR SPECIALIST CLAIMS;

%MACRO SPECIALIST_COST_SHARE(SERV_CAT);

  PROC SUMMARY DATA=&INC NWAY MISSING;
  WHERE CATEGORY IN('1a','1b','2');
  CLASS BASEID YEAR;
  VAR AMTTOT_PHYSICIAN;
  OUTPUT OUT=PHYSICIAN_SUM (DROP=_TYPE_ RENAME=_FREQ_=STAYCNT) SUM=;
  RUN;
  
  PROC SORT DATA=&INC OUT=SPECIALIST_BASEID; 
  WHERE CATEGORY='7d';
  BY BASEID YEAR;
  RUN;
  
  DATA SPECIALIST_BASEID;
  MERGE SPECIALIST_BASEID (IN=A)
        PHYSICIAN_SUM (IN=B);
  BY BASEID YEAR;
  JOIN_ID='1';
  *AMTTOT_PHYSICIAN=AMTTOT_PHYSICIAN/STAYCNT;
  RUN;
  
  DATA SPECIALIST_FILE;
    SET  PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B7D_DED_AMT 
                   PBP_B7D_MAXENR_AMT
                   PBP_B7D_MAXENR_PER 
                   PBP_B7D_COINS_PCT_MC_MIN 
                   PBP_B7D_COPAY_AMT_MC_MIN
                   PBP_A_PLAN_TYPE
                   PBP_D_DIFF_DEDUCT_7D_AMT);
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B7D_MAXENR_PER,PBP_B7D_MAXENR_AMT);
  RUN;
  
  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.AMTTOT_PHYSICIAN, B.YEAR, P.*
      FROM SPECIALIST_BASEID B, SPECIALIST_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
   RUN;
     
  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='7d'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;
   
  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);
    IF PUT(HPLAN,$TYPEF.) IN('FFS','MGAP') THEN 
      AMTTOT=SUM(AMTTOT,AMTTOT_PHYSICIAN);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;

    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DED_AMTTOT_MC_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_7D_AMT;
    ELSE CAT_DEDUCTIBLE=PBP_B7D_DED_AMT;

    IF PBP_B7D_MAXENR_AMT NE . THEN 
      BENE_MAXIMUM = PBP_B7D_MAXENR_AMT;

    IF CAT_DEDUCTIBLE = . THEN DO;
      COST = SUM(COST,(VISITS*PBP_B7D_COPAY_AMT_MC_MIN));
      COST = SUM(COST,AMTTOT*PBP_B7D_COINS_PCT_MC_MIN);
    END;
    ELSE DO;
      IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
        COST = AMTTOT;
      END;
      ELSE DO;
        COST = CAT_DEDUCTIBLE;
        DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
        AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
        VISITS = VISITS * (1 - DEDUCT_SHARE);
        COST = SUM(COST,(VISITS*PBP_B7D_COPAY_AMT_MC_MIN));
        COST = SUM(COST,AMTTOT*PBP_B7D_COINS_PCT_MC_MIN);
      END;
    END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN 
      COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "7d";
    
  RUN;

  PROC APPEND DATA=SPECIALIST(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE SPECIALIST SPECIALIST_BASEID SPECIALIST_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;

