* PROGRAM: OOPCV1M.SAS;
* DESCRIPTION: MAIN MACRO THAT CALLS OTHER PROGRAMS;

%INCLUDE IN0(CLEANUP);
RUN;

%INCLUDE IN0(ANNUALIZATION);
RUN;

%MACRO OOPCV1M(RUNYEAR=, INP=, INC=, CATEG=, PBP=, FORMULARY=, PLANFILE=, OOPC=);

  %IF &INPUT = INPUTPLAN %THEN %DO;
    %INCLUDE IN0(JSON_IMPORT)/SOURCE2;
  %END;

  %IF &INPUT = INPUTPLAN %THEN %DO;
    %INCLUDE IN0(PBP_IMPORT)/SOURCE2;

  %END;

  %ELSE %IF &INPUT = INPUTCMS %THEN %DO;
    %INCLUDE IN0(PBP_IMPORT_CMS)/SOURCE2;
    RUN;
  %END;
 
  %IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 OR &FFS > 0 OR &MGAP > 0 %THEN %DO;

    DATA COSTDATA;
      LENGTH HPLAN $11 YEAR $4 BASEID $8 CATEGORY $6 COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
        OTHER_COST COST AMTTOT 8;
      RETAIN HPLAN YEAR BASEID CATEGORY ' ' COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
        OTHER_COST COST AMTTOT .;
      OUTPUT;
    RUN;
  
    DATA PBP_FILE_COMPLETE;
      SET PBP_FILE;
    RUN;

    DATA PBP_FILE;
      SET PBP_FILE;
      IF PUT(HPLAN,$TYPEF.)='PDP' THEN DELETE;
    RUN;
  
    %INCLUDE IN0(PLAN_DEDUCTIBLE);
    RUN;
  
    %INCLUDE IN0(COST_SHARING_AMBULANCE);
    %AMBULANCE_COST_SHARE(AMBULANCE);
    RUN;

    %INCLUDE IN0(COST_SHARING_ASC);
    %ASC_COST_SHARE(ASC);
    RUN;

    %INCLUDE IN0(COST_SHARING_CARDIAC_REHAB);
    %CARD_COST_SHARE(CARD);
    RUN;

    %INCLUDE IN0(COST_SHARING_CHIROPRACTIC);
    %CHIRO_COST_SHARE(CHIRO);
    RUN;

    %INCLUDE IN0(COST_SHARING_COMP_XRAY);
    %COMPXRAY_COST_SHARE(COMPXRAY);
    RUN;
  
    %INCLUDE IN0(COST_SHARING_PREVENTIVE_DENTAL);
    %DENTAL_PREV_COST_SHARE(DENTAL);
    RUN;
 
    %INCLUDE IN0(COST_SHARING_EDUCATION_DIABETES);
    %DIAB_COST_SHARE(DIAB);
    RUN;

    %INCLUDE IN0(COST_SHARING_DIAG);
    %DIAG_COST_SHARE(DIAG);
    RUN;

    %INCLUDE IN0(COST_SHARING_DIALYSIS);
    %DIALYSIS_COST_SHARE(DIALYSIS);
    RUN;

    %INCLUDE IN0(COST_SHARING_DME);
    %DME_COST_SHARE(DME);
    RUN;

    %INCLUDE IN0(COST_SHARING_ER);
    %ER_COST_SHARE(ER);
    RUN;

    %INCLUDE IN0(COST_SHARING_EYEEXAMS);
    %EYEEXAMS_COST_SHARE(EYEEXAMS);
    RUN;

    %INCLUDE IN0(COST_SHARING_HEARINGEXAMS);
    %HEARINGEXAMS_COST_SHARE(HEARINGEXAMS);
    RUN;

    %INCLUDE IN0(COST_SHARING_HHA);
    %HHA_COST_SHARE(HHA);
    RUN;

    %INCLUDE IN0(COST_SHARING_INPATIENT_ACUTE);
    %INPAT_ACUTE(INPATIENT_ACUTE);
    RUN;

    %INCLUDE IN0(COST_SHARING_INPATIENT_PSYCH);
    %INPAT_PSYCH(INPATIENT_PSYCH);
    RUN;

    %INCLUDE IN0(COST_SHARING_LAB);
    %LAB_COST_SHARE(LAB);
    RUN;

    %INCLUDE IN0(COST_SHARING_COMPREHENSIVE_DENTAL);
    %DENTAL_COMP_COST_SHARE(DENTAL);
    RUN;

    %INCLUDE IN0(COST_SHARING_MEDICARE_DRUGS);
    %MDRUGS_COST_SHARE(MDRUGS);
    RUN;
  
    %INCLUDE IN0(COST_SHARING_MEDICARE_DRUGS_CHEMO);
    %CHEMO_COST_SHARE(CHEMO);
    RUN;
    
    %INCLUDE IN0(COST_SHARING_MEDICARE_BDRUGS_INSULIN);
    %IDRUGS_COST_SHARE(IDRUGS);
    RUN;    
  
    %INCLUDE IN0(COST_SHARING_MNTLHLTH);
    %MNTLHLTH_COST_SHARE(MNTLHLTH);
    RUN;
   
    %INCLUDE IN0(COST_SHARING_ORTHOTICS);
    %ORTHOTICS_COST_SHARE(ORTHOTICS);
    RUN;

    %INCLUDE IN0(COST_SHARING_OT);
    %OT_COST_SHARE(OT);
    RUN;

    %INCLUDE IN0(COST_SHARING_OTHER);
    %OTHER_COST_SHARE(OTHER);
    RUN;

    %INCLUDE IN0(COST_SHARING_OUTPAT);
    %OUTPAT_COST_SHARE(OUTPAT);
    RUN;

    %INCLUDE IN0(COST_SHARING_PCP);
    %PCP_COST_SHARE(PCP);
    RUN;

    %INCLUDE IN0(COST_SHARING_PODIATRY);
    %PODIATRY_COST_SHARE(PODIATRY);
    RUN;

    %INCLUDE IN0(COST_SHARING_PSYCH);
    %PSYCH_COST_SHARE(PSYCH);
    RUN;

    %INCLUDE IN0(COST_SHARING_PT);
    %PT_COST_SHARE(PT);
    RUN;

    %INCLUDE IN0(COST_SHARING_PULMONARY_REHAB);
    %PULM_COST_SHARE(PULM);
    RUN;

    %INCLUDE IN0(COST_SHARING_RADIATION);
    %RADIATION_COST_SHARE(RADIATION);
    RUN;
    
    %INCLUDE IN0(COST_SHARING_SET_PAD);
    %SETPAD_COST_SHARE(SETPAD);
    RUN;    

    %INCLUDE IN0(COST_SHARING_SNF);
    %SNF_COST_SHARE(SNF);
    RUN;
 
    %INCLUDE IN0(COST_SHARING_SPECIALIST);
    %SPECIALIST_COST_SHARE(SPECIALIST);
    RUN;

    %INCLUDE IN0(COST_SHARING_SUPPLIES);
    %SUPPLIES_COST_SHARE(SUPPLIES);
    RUN;

    %INCLUDE IN0(COST_SHARING_URGENT_CARE);
    %URGENT_COST_SHARE(URGENT);
    RUN;

    %INCLUDE IN0(COST_SHARING_XRAY);
    %XRAY_COST_SHARE(XRAY);
    RUN;

    %INCLUDE IN0(COST_SHARING_OPIOID);
    %OPIOID_COST_SHARE(OPIOID);
    RUN;   
  
    DATA PBP_FILE;
      SET PBP_FILE_COMPLETE;
    RUN;
  
    %INCLUDE IN0(PBPCATS)/SOURCE2;
    RUN;

    %INCLUDE IN0(MISSING_CELLS_YEAR)/SOURCE2;
    RUN;
  
    %INCLUDE IN0(BASEID_PLAN_YEAR)/SOURCE2;
    RUN;

    %INCLUDE IN0(PLAN_CATNAME_NEW)/SOURCE2;
    RUN; 
  
  %END;

%MEND;

