* PROGRAM: PLAN_DEDUCTIBLE.SAS;

*******;
*** READ THE PBP_D DATA FROM DST_DATA AND BUILD A DATASET WITH EACH ROW REPRESENTING;
*** A CONTRACT AND A CATEGORY FOR WHICH THERE IS A DEDUCTION;
*** THIS DATASET HAS TWO VARIABLES: HPLAN AND CATEGORY;
*******;

DATA DEDUCTION_CATS_M;
  SET PBP_FILE(KEEP=HPLAN
                    PBP_A_PLAN_TYPE
                    PBP_A_NETWORK_FLAG
                    PBP_D_INN_DEDUCT_YN
                    PBP_D_INN_DEDUCT_PARTB_YN
                    PBP_D_INN_DEDUCT_M_YN
                    PBP_D_INN_DEDUCT_NM_YN
                    PBP_D_INN_DEDUCT_AMT
                    PBP_D_INN_DEDUCT_M_CATS
                    PBP_D_INN_DEDUCT_NM_CATS
                    PBP_D_NON_DEDUCT_YN
                    PBP_D_NON_DEDUCT_PARTB_YN
                    PBP_D_NON_DEDUCT_M_YN
                    PBP_D_NON_DEDUCT_NM_YN
                    PBP_D_NON_DEDUCT_AMT
                    PBP_D_NON_DEDUCT_M_CATS
                    PBP_D_NON_DEDUCT_NM_CATS
                    PBP_D_COMB_DEDUCT_YN
                    PBP_D_COMB_DEDUCT_PARTB_YN
                    PBP_D_COMB_DEDUCT_INN_M_YN
                    PBP_D_COMB_DEDUCT_INN_NM_YN
                    PBP_D_COMB_DEDUCT_AMT
                    PBP_D_COMB_DEDUCT_INN_M_CATS
                    PBP_D_COMB_DEDUCT_INN_NM_CATS
                    PBP_D_COMB_DEDUCT_BENS
                    PBP_D_ANN_DEDUCT_AMT
                    PBP_D_ANN_DEDUCT_AMT_TYPE
                    PBP_D_ANN_DEDUCT_BENS
                    PBP_D_ANN_DEDUCT_COMB_TYPE
                    PBP_D_ANN_DEDUCT_INN_MC_CATS
                    PBP_D_ANN_DEDUCT_INN_MC_YN
                    PBP_D_ANN_DEDUCT_INN_NMC_CATS
                    PBP_D_ANN_DEDUCT_INN_NMC_YN
                    PBP_D_ANN_DEDUCT_YN
                    PBP_B4A_MAX_VISIT
                    PBP_B4B_MAX_VISIT);

  LENGTH TYPE $4 CATEGORY $6 PBP_D_NON_DEDUCT_M_CATS_ST PBP_D_ANN_DEDUCT_INN_MC_CATS_ST $4000;
  LENGTH PBP_D_INN_DEDUCT_M_CATS_ST PBP_D_COMB_DEDUCT_INN_M_CATS_ST $4000;
  TYPE=PUT(HPLAN,$TYPEF.);
  PBP_D_NON_DEDUCT_M_CATS_ST=PBP_D_NON_DEDUCT_M_CATS;
  PBP_D_ANN_DEDUCT_INN_MC_CATS_ST=PBP_D_ANN_DEDUCT_INN_MC_CATS;
  PBP_D_INN_DEDUCT_M_CATS_ST=PBP_D_INN_DEDUCT_M_CATS;
  PBP_D_COMB_DEDUCT_INN_M_CATS_ST=PBP_D_COMB_DEDUCT_INN_M_CATS;

  * PFFS NON NETWORK;
  IF PBP_A_PLAN_TYPE = '09' & PBP_A_NETWORK_FLAG = '2' & 
    (PBP_D_NON_DEDUCT_AMT > 0 | PBP_D_NON_DEDUCT_PARTB_YN = '1') THEN DO;
    IF PBP_D_NON_DEDUCT_M_YN = '1' THEN DO;
      DO I = 1 TO 58;
        CATEGORY = PUT(I,NONMDED.);
        OUTPUT;
      END;
    END;
    ELSE DO;
      DO I=1 TO LENGTH(PBP_D_NON_DEDUCT_M_CATS_ST);
        SEMISPOT=INDEX(PBP_D_NON_DEDUCT_M_CATS_ST,';');
        IF SEMISPOT>0 THEN DO;
          CATEGORY=SUBSTR(PBP_D_NON_DEDUCT_M_CATS_ST,1,SEMISPOT-1);
          OUTPUT;
          IF CATEGORY='3-1' THEN DO;
            CATEGORY='3c';
            OUTPUT;
          END;
          ELSE IF CATEGORY='3-3' THEN DO;
            CATEGORY='3p';
            OUTPUT;
          END;
          ELSE IF CATEGORY='3-4' THEN DO;
            CATEGORY='3s';
            OUTPUT;
          END;
          ELSE IF CATEGORY='11b1' THEN DO;
            CATEGORY='11b';
            OUTPUT;
          END;
          ELSE IF CATEGORY='11b2' THEN DO;
            CATEGORY='11bs';
            OUTPUT;
          END;
          ELSE IF UPCASE(CATEGORY) IN('15-1-I','15-1') THEN DO;
            CATEGORY='15i';
            OUTPUT;
          END;  
          ELSE IF CATEGORY='15-2' THEN DO;
            CATEGORY='15c';
            OUTPUT;
          END;
          ELSE IF CATEGORY='15-3' THEN DO;
            CATEGORY='15m';
            OUTPUT;
          END;
          ELSE IF CATEGORY='7e1' THEN DO;
            CATEGORY='7e';
            OUTPUT;
          END;
          ELSE IF CATEGORY='7h1' THEN DO;
            CATEGORY='7h';
            OUTPUT;
          END;
          PBP_D_NON_DEDUCT_M_CATS_ST=SUBSTR(PBP_D_NON_DEDUCT_M_CATS_ST,SEMISPOT+1);
        END;
      END;
    END;
  END;
  
  * PPO DEDUCTIBLE;
  ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_ANN_DEDUCT_YN = '1' THEN DO;
    *WRITE OUT ALL MEDICARE CATEGORIES FOR SPECIAL DIFFERENTIAL CASES;
    IF PBP_D_ANN_DEDUCT_AMT_TYPE='3' & PBP_D_ANN_DEDUCT_COMB_TYPE='2' THEN DO;
      DO I = 1 TO 58;
        CATEGORY = PUT(I,AINMDED.);
        OUTPUT;
      END;
    END;

    ELSE DO;
      IF SUBSTR(PBP_D_ANN_DEDUCT_BENS,2,1)='1' THEN DO;
        *WRITE OUT ALL MEDICARE CATEGORIES;
        IF PBP_D_ANN_DEDUCT_INN_MC_YN='1' THEN DO;
          DO I = 1 TO 58;
            CATEGORY = PUT(I,AINMDED.);
            OUTPUT;
          END;
        END;

        *MEDICARE CATEGORIES USING PICK LIST;
        ELSE IF PBP_D_ANN_DEDUCT_INN_MC_YN='2' THEN DO;
          DO I=1 TO LENGTH(PBP_D_ANN_DEDUCT_INN_MC_CATS_ST);
            SEMISPOT=INDEX(PBP_D_ANN_DEDUCT_INN_MC_CATS_ST,';');
            IF SEMISPOT>0 THEN DO;
              CATEGORY=SUBSTR(PBP_D_ANN_DEDUCT_INN_MC_CATS_ST,1,SEMISPOT-1);
              OUTPUT;
              IF CATEGORY='3-1' THEN DO;
                CATEGORY='3c';
                OUTPUT;
              END;
              ELSE IF CATEGORY='3-3' THEN DO;
                CATEGORY='3p';
                OUTPUT;
              END;
              ELSE IF CATEGORY='3-4' THEN DO;
                CATEGORY='3s';
                OUTPUT;
              END;
              ELSE IF CATEGORY='11b1' THEN DO;
                CATEGORY='11b';
                OUTPUT;
              END;
              ELSE IF CATEGORY='11b2' THEN DO;
                CATEGORY='11bs';
                OUTPUT;
              END;
              ELSE IF UPCASE(CATEGORY) IN('15-1-I','15-1') THEN DO;
                CATEGORY='15i';
                OUTPUT;
              END;
              ELSE IF CATEGORY='15-2' THEN DO;
                CATEGORY='15c';
                OUTPUT;
              END;
              ELSE IF CATEGORY='15-3' THEN DO;
                CATEGORY='15m';
                OUTPUT;
              END;
              ELSE IF CATEGORY='7e1' THEN DO;
                CATEGORY='7e';
                OUTPUT;
              END;
              ELSE IF CATEGORY='7h1' THEN DO;
                CATEGORY='7h';
                OUTPUT;
              END;
              PBP_D_ANN_DEDUCT_INN_MC_CATS_ST=SUBSTR(PBP_D_ANN_DEDUCT_INN_MC_CATS_ST,SEMISPOT+1);
            END;
          END;
        END;
      END;
    END;
  END;

  * IN NETWORK DEDUCTIBLE;
  ELSE IF PBP_D_INN_DEDUCT_YN = '1' &
    (PBP_D_INN_DEDUCT_AMT > 0 | PBP_D_INN_DEDUCT_PARTB_YN = '1') THEN DO;
    IF PBP_D_INN_DEDUCT_M_YN = '1' THEN DO;
      DO I = 1 TO 58;
        CATEGORY = PUT(I,INMDED.);
        OUTPUT;
      END; 
    END;
    ELSE DO;
      DO I=1 TO LENGTH(PBP_D_INN_DEDUCT_M_CATS_ST);
        SEMISPOT=INDEX(PBP_D_INN_DEDUCT_M_CATS_ST,';');
        IF SEMISPOT>0 THEN DO;
          CATEGORY=SUBSTR(PBP_D_INN_DEDUCT_M_CATS_ST,1,SEMISPOT-1);
          OUTPUT;
          IF CATEGORY='3-1' THEN DO;
            CATEGORY='3c';
            OUTPUT;
          END;
          ELSE IF CATEGORY='3-3' THEN DO;
            CATEGORY='3p';
            OUTPUT;
          END;
          ELSE IF CATEGORY='3-4' THEN DO;
            CATEGORY='3s';
            OUTPUT;
          END;
          ELSE IF CATEGORY='11b1' THEN DO;
            CATEGORY='11b';
            OUTPUT;
          END;
          ELSE IF CATEGORY='11b2' THEN DO;
            CATEGORY='11bs';
            OUTPUT;
          END;
          ELSE IF UPCASE(CATEGORY) IN('15-1-I','15-1') THEN DO;
            CATEGORY='15i';
            OUTPUT;
          END;
          ELSE IF CATEGORY='15-2' THEN DO;
            CATEGORY='15c';
            OUTPUT;
          END;
          ELSE IF CATEGORY='15-3' THEN DO;
            CATEGORY='15m';
            OUTPUT;
          END;
          ELSE IF CATEGORY='7e1' THEN DO;
            CATEGORY='7e';
            OUTPUT;
          END;
          ELSE IF CATEGORY='7h1' THEN DO;
            CATEGORY='7h';
            OUTPUT;
          END;
          PBP_D_INN_DEDUCT_M_CATS_ST=SUBSTR(PBP_D_INN_DEDUCT_M_CATS_ST,SEMISPOT+1);
        END;
      END;
    END;
  END;
  
  * COMBINE DEDUCTIBLE;
  ELSE IF PBP_D_COMB_DEDUCT_YN = '1' & 
    (PBP_D_COMB_DEDUCT_AMT > 0 | PBP_D_COMB_DEDUCT_PARTB_YN='1') THEN DO;
    IF PBP_D_COMB_DEDUCT_INN_M_YN = '1' THEN DO;
      DO I = 1 TO 58;
        CATEGORY = PUT(I,CINMDED.);
        OUTPUT;
      END;
    END;
    ELSE DO;
      DO I=1 TO LENGTH(PBP_D_COMB_DEDUCT_INN_M_CATS_ST);
        SEMISPOT=INDEX(PBP_D_COMB_DEDUCT_INN_M_CATS_ST,';');
        IF SEMISPOT>0 THEN DO;
          CATEGORY=SUBSTR(PBP_D_COMB_DEDUCT_INN_M_CATS_ST,1,SEMISPOT-1);
          OUTPUT;
          IF CATEGORY='3-1' THEN DO;
            CATEGORY='3c';
            OUTPUT;
          END;
          ELSE IF CATEGORY='3-3' THEN DO;
            CATEGORY='3p';
            OUTPUT;
          END;
          ELSE IF CATEGORY='3-4' THEN DO;
            CATEGORY='3s';
            OUTPUT;
          END;
          ELSE IF CATEGORY='11b1' THEN DO;
            CATEGORY='11b';
            OUTPUT;
          END;
          ELSE IF CATEGORY='11b2' THEN DO;
            CATEGORY='11bs';
            OUTPUT;
          END;
          ELSE IF UPCASE(CATEGORY) IN('15-1-I','15-1') THEN DO;
            CATEGORY='15i';
            OUTPUT;
          END;
          ELSE IF CATEGORY='15-2' THEN DO;
            CATEGORY='15c';
            OUTPUT;
          END;
          ELSE IF CATEGORY='15-3' THEN DO;
            CATEGORY='15m';
            OUTPUT;
          END;
          ELSE IF CATEGORY='7e1' THEN DO;
            CATEGORY='7e';
            OUTPUT;
          END;
          ELSE IF CATEGORY='7h1' THEN DO;
            CATEGORY='7h';
            OUTPUT;
          END;
          PBP_D_COMB_DEDUCT_INN_M_CATS_ST=SUBSTR(PBP_D_COMB_DEDUCT_INN_M_CATS_ST,SEMISPOT+1);
        END;
      END;
    END;
  END;

  ELSE IF TYPE='MSA' THEN DO;
    DO I = 1 TO 58;
      CATEGORY = PUT(I,INMDED.);
      OUTPUT;
    END;
  END;
  KEEP HPLAN CATEGORY TYPE PBP_A_PLAN_TYPE;
RUN;

DATA DEDUCTION_CATS_NM;
  SET PBP_FILE(KEEP = HPLAN
                      PBP_A_PLAN_TYPE
                      PBP_A_NETWORK_FLAG
                      PBP_D_INN_DEDUCT_YN
                      PBP_D_INN_DEDUCT_PARTB_YN
                      PBP_D_INN_DEDUCT_M_YN
                      PBP_D_INN_DEDUCT_NM_YN
                      PBP_D_INN_DEDUCT_AMT
                      PBP_D_INN_DEDUCT_M_CATS
                      PBP_D_INN_DEDUCT_NM_CATS
                      PBP_D_NON_DEDUCT_YN
                      PBP_D_NON_DEDUCT_PARTB_YN
                      PBP_D_NON_DEDUCT_M_YN
                      PBP_D_NON_DEDUCT_NM_YN
                      PBP_D_NON_DEDUCT_AMT
                      PBP_D_NON_DEDUCT_M_CATS
                      PBP_D_NON_DEDUCT_NM_CATS
                      PBP_D_COMB_DEDUCT_YN
                      PBP_D_COMB_DEDUCT_PARTB_YN
                      PBP_D_COMB_DEDUCT_INN_M_YN
                      PBP_D_COMB_DEDUCT_INN_NM_YN
                      PBP_D_COMB_DEDUCT_AMT
                      PBP_D_COMB_DEDUCT_INN_M_CATS
                      PBP_D_COMB_DEDUCT_INN_NM_CATS
                      PBP_D_COMB_DEDUCT_BENS
                      PBP_D_ANN_DEDUCT_AMT
                      PBP_D_ANN_DEDUCT_AMT_TYPE
                      PBP_D_ANN_DEDUCT_BENS
                      PBP_D_ANN_DEDUCT_COMB_TYPE
                      PBP_D_ANN_DEDUCT_INN_MC_CATS
                      PBP_D_ANN_DEDUCT_INN_MC_YN
                      PBP_D_ANN_DEDUCT_INN_NMC_CATS
                      PBP_D_ANN_DEDUCT_INN_NMC_YN
                      PBP_D_ANN_DEDUCT_YN);

  LENGTH TYPE $4 CATEGORY $6 PBP_D_NON_DEDUCT_NM_CATS_ST PBP_D_ANN_DEDUCT_INN_NMC_CATS_ST $4000;
  LENGTH PBP_D_INN_DEDUCT_NM_CATS_ST PBP_D_COMB_DEDUCT_INN_NM_CATS_ST $4000;
  TYPE = PUT(HPLAN,$TYPEF.);
  PBP_D_NON_DEDUCT_NM_CATS_ST=PBP_D_NON_DEDUCT_NM_CATS;
  PBP_D_ANN_DEDUCT_INN_NMC_CATS_ST=PBP_D_ANN_DEDUCT_INN_NMC_CATS;
  PBP_D_INN_DEDUCT_NM_CATS_ST=PBP_D_INN_DEDUCT_NM_CATS;
  PBP_D_COMB_DEDUCT_INN_NM_CATS_ST=PBP_D_COMB_DEDUCT_INN_NM_CATS;

  * PFFS NON NETWORK;
  IF PBP_A_PLAN_TYPE = '09' & PBP_A_NETWORK_FLAG = '2' &
    (PBP_D_NON_DEDUCT_AMT > 0 | PBP_D_NON_DEDUCT_PARTB_YN = '1') THEN DO;
    IF PBP_D_NON_DEDUCT_NM_YN = '1' THEN DO I = 1 TO 79;
      CATEGORY = PUT(I,NONNMDED.);
      OUTPUT;
    END;
    ELSE DO I=1 TO LENGTH(PBP_D_NON_DEDUCT_NM_CATS_ST);
      SEMISPOT=INDEX(PBP_D_NON_DEDUCT_NM_CATS_ST,';');
      IF SEMISPOT>0 THEN DO;
        CATEGORY=SUBSTR(PBP_D_NON_DEDUCT_NM_CATS_ST,1,SEMISPOT-1);
        OUTPUT;
        PBP_D_NON_DEDUCT_NM_CATS_ST=SUBSTR(PBP_D_NON_DEDUCT_NM_CATS_ST,SEMISPOT+1);
      END;
    END;
  END;

  * PPO DEDUCTIBLE;
  ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_ANN_DEDUCT_YN = '1' THEN DO; 
    IF PBP_D_ANN_DEDUCT_AMT_TYPE IN('1','2','4') | (PBP_D_ANN_DEDUCT_AMT_TYPE='3' & 
      PBP_D_ANN_DEDUCT_COMB_TYPE='1') THEN DO;
      IF SUBSTR(PBP_D_ANN_DEDUCT_BENS,3,1)='1' THEN DO;
        IF PBP_D_ANN_DEDUCT_INN_NMC_YN='1' THEN DO I = 1 TO 81;
          CATEGORY = PUT(I,AINNMDED.);
          OUTPUT;
        END;
        ELSE IF PBP_D_ANN_DEDUCT_INN_NMC_YN='2' THEN DO;
          DO I=1 TO LENGTH(PBP_D_ANN_DEDUCT_INN_NMC_CATS_ST);
            SEMISPOT=INDEX(PBP_D_ANN_DEDUCT_INN_NMC_CATS_ST,';');
            IF SEMISPOT>0 THEN DO;
              CATEGORY=SUBSTR(PBP_D_ANN_DEDUCT_INN_NMC_CATS_ST,1,SEMISPOT-1);
              OUTPUT;
              PBP_D_ANN_DEDUCT_INN_NMC_CATS_ST=SUBSTR(PBP_D_ANN_DEDUCT_INN_NMC_CATS_ST,SEMISPOT+1);
            END;
          END;
        END;
      END;
    END;
  END;

  * IN NETWORK DEDUCTIBLE;
  ELSE IF PBP_D_INN_DEDUCT_YN = '1' & 
    (PBP_D_INN_DEDUCT_AMT > 0 | PBP_D_INN_DEDUCT_PARTB_YN = '1') THEN DO;
    IF PBP_D_INN_DEDUCT_NM_YN = '1' THEN DO I = 1 TO 79;
      CATEGORY = PUT(I,INNMDED.);
      OUTPUT;
    END;
    ELSE DO I=1 TO LENGTH(PBP_D_INN_DEDUCT_NM_CATS_ST);
      SEMISPOT=INDEX(PBP_D_INN_DEDUCT_NM_CATS_ST,';');
      IF SEMISPOT>0 THEN DO;
        CATEGORY=SUBSTR(PBP_D_INN_DEDUCT_NM_CATS_ST,1,SEMISPOT-1);
        OUTPUT;
        PBP_D_INN_DEDUCT_NM_CATS_ST=SUBSTR(PBP_D_INN_DEDUCT_NM_CATS_ST,SEMISPOT+1);
      END;
    END;
  END;

  * COMBINE DEDUCTIBLE;
  ELSE IF PBP_D_COMB_DEDUCT_YN = '1' & 
    (PBP_D_COMB_DEDUCT_AMT > 0 | PBP_D_COMB_DEDUCT_PARTB_YN = '1') THEN DO;
    IF PBP_D_COMB_DEDUCT_INN_NM_YN = '1' THEN DO I = 1 TO 79;
      CATEGORY = PUT(I,CINNMDED.);
      OUTPUT;
    END;
    ELSE DO I=1 TO LENGTH(PBP_D_COMB_DEDUCT_INN_NM_CATS_ST);
      SEMISPOT=INDEX(PBP_D_COMB_DEDUCT_INN_NM_CATS_ST,';');
      IF SEMISPOT>0 THEN DO;
        CATEGORY=SUBSTR(PBP_D_COMB_DEDUCT_INN_NM_CATS_ST,1,SEMISPOT-1);
        OUTPUT;
        PBP_D_COMB_DEDUCT_INN_NM_CATS_ST=SUBSTR(PBP_D_COMB_DEDUCT_INN_NM_CATS_ST,SEMISPOT+1);
      END;
    END;
  END;

  ELSE IF TYPE='MSA' THEN DO I = 1 TO 79;
    CATEGORY = PUT(I,INNMDED.);
    OUTPUT;
  END;
  KEEP HPLAN CATEGORY TYPE PBP_A_PLAN_TYPE;
RUN;

PROC SORT DATA = DEDUCTION_CATS_M NODUPKEY;
  BY HPLAN TYPE CATEGORY PBP_A_PLAN_TYPE;
RUN;

** FOR NON MEDICARE CATEGORIES 1a, 1b, AND 2 THESE ARE FOR PART B ONLY.  THESE ARE TAKEN OUT;
** AND 1a2, 1b2, AND 2-2 FOR NON-MEDICARE-COVERED STAY ARE RECODED TO MATCH UTILIZATION FILE;
** COLLAPSED 16a1-16a4 TO 16 AND 16b1-16b7 TO 16b TO MATCH CURRENT UTILIZATON;
DATA DEDUCTION_CATS_NM;
  SET DEDUCTION_CATS_NM;
  IF CATEGORY IN('1a','1b','2') THEN DELETE;
  IF CATEGORY = '1a2' THEN CATEGORY = '1a';
  ELSE IF CATEGORY = '1b2' THEN CATEGORY = '1b';
  ELSE IF CATEGORY = '2-2' THEN CATEGORY = '2';
  ELSE IF CATEGORY IN ('16a1','16a2','16a3','16a4') THEN CATEGORY = '16a';
  ELSE IF CATEGORY IN ('16b1','16b2','16b3','16b4','16b5','16b6','16b7') THEN CATEGORY = '16b';
RUN;

PROC SORT DATA = DEDUCTION_CATS_NM NODUPKEY;
  BY HPLAN TYPE CATEGORY PBP_A_PLAN_TYPE;
RUN;

DATA DEDUCTION_CATS;
  MERGE DEDUCTION_CATS_M (IN = A)
        DEDUCTION_CATS_NM (IN = B);
  BY HPLAN TYPE CATEGORY PBP_A_PLAN_TYPE;
  IF A | B;
  MEDICARE_FLG = A;
  NONMEDICARE_FLG = B;
RUN;

DATA PBP_DEDUCTIBLE;
  SET PBP_FILE(KEEP = HPLAN
                      PBP_A_PLAN_TYPE
                      PBP_A_NETWORK_FLAG
                      PBP_D_INN_DEDUCT_YN
                      PBP_D_INN_DEDUCT_PARTB_YN
                      PBP_D_INN_DEDUCT_M_YN
                      PBP_D_INN_DEDUCT_NM_YN
                      PBP_D_INN_DEDUCT_AMT
                      PBP_D_INN_DEDUCT_M_CATS
                      PBP_D_INN_DEDUCT_NM_CATS
                      PBP_D_NON_DEDUCT_YN
                      PBP_D_NON_DEDUCT_PARTB_YN
                      PBP_D_NON_DEDUCT_M_YN
                      PBP_D_NON_DEDUCT_NM_YN
                      PBP_D_NON_DEDUCT_AMT
                      PBP_D_NON_DEDUCT_M_CATS
                      PBP_D_NON_DEDUCT_NM_CATS
                      PBP_D_INN_DEDUCT_BENS
                      PBP_D_NON_DEDUCT_BENS
                      PBP_D_COMB_DEDUCT_YN
                      PBP_D_COMB_DEDUCT_PARTB_YN
                      PBP_D_COMB_DEDUCT_AMT
                      PBP_D_COMB_DEDUCT_BENS
                      PBP_D_MSA_DED_AMT 
                      PBP_D_MSA_ANNUAL_AMT
                      PBP_D_ANN_DEDUCT_AMT
                      PBP_D_ANN_DEDUCT_AMT_TYPE
                      PBP_D_ANN_DEDUCT_BENS
                      PBP_D_ANN_DEDUCT_COMB_TYPE
                      PBP_D_ANN_DEDUCT_INN_MC_CATS
                      PBP_D_ANN_DEDUCT_INN_MC_YN
                      PBP_D_ANN_DEDUCT_INN_NMC_CATS
                      PBP_D_ANN_DEDUCT_INN_NMC_YN
                      PBP_D_ANN_DEDUCT_YN
                      PBP_B1A_MC_COPAY_CSTSHR_YN_T1 
                      PBP_B1B_MC_COPAY_CSTSHR_YN_T1);

  LENGTH TYPE $4 PLAN_DEDUCTIBLE_TYPE $1 PLAN_DEDUCTIBLE_BENS $2;
  TYPE = PUT(HPLAN,$TYPEF.);

  * PFFS NON NETWORK;
  IF PBP_A_PLAN_TYPE = '09' & PBP_A_NETWORK_FLAG = '2' & PBP_D_NON_DEDUCT_YN = '1' THEN DO;
    IF PBP_D_NON_DEDUCT_PARTB_YN = '1' THEN PLAN_DEDUCTIBLE = &PARTB_DEDUCT.;
    ELSE PLAN_DEDUCTIBLE = PBP_D_NON_DEDUCT_AMT;
    PLAN_DEDUCTIBLE_BENS = PBP_D_NON_DEDUCT_BENS;

    IF PLAN_DEDUCTIBLE_BENS = '01' THEN PLAN_DEDUCTIBLE_TYPE = '1';
    ELSE IF PLAN_DEDUCTIBLE_BENS = '10' THEN PLAN_DEDUCTIBLE_TYPE = '2';
    ELSE IF PLAN_DEDUCTIBLE_BENS = '11' THEN PLAN_DEDUCTIBLE_TYPE = '3';
    ELSE PLAN_DEDUCTIBLE_TYPE = ' ';
  END;

  * PPO DEDUCTIBLE;
  ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_ANN_DEDUCT_YN = '1' &
    (SUBSTR(PBP_D_ANN_DEDUCT_BENS,2,1)='1' | SUBSTR(PBP_D_ANN_DEDUCT_BENS,3,1)='1') THEN DO;
    IF PBP_D_ANN_DEDUCT_AMT_TYPE = '1' THEN PLAN_DEDUCTIBLE = &PARTA_DEDUCT.;
    ELSE IF PBP_D_ANN_DEDUCT_AMT_TYPE = '2' THEN PLAN_DEDUCTIBLE = &PARTB_DEDUCT.;
    ELSE IF PBP_D_ANN_DEDUCT_AMT_TYPE = '3' THEN PLAN_DEDUCTIBLE = SUM(&PARTA_DEDUCT.,&PARTB_DEDUCT.);
    ELSE PLAN_DEDUCTIBLE = PBP_D_ANN_DEDUCT_AMT;
    PLAN_DEDUCTIBLE_BENS = SUBSTR(PBP_D_ANN_DEDUCT_BENS,2,2);

    IF SUBSTR(PBP_D_ANN_DEDUCT_BENS,2,2)='10' THEN PLAN_DEDUCTIBLE_TYPE = '1';
    ELSE IF SUBSTR(PBP_D_ANN_DEDUCT_BENS,2,2)='01' THEN PLAN_DEDUCTIBLE_TYPE = '2';
    ELSE IF SUBSTR(PBP_D_ANN_DEDUCT_BENS,2,2)='11' THEN PLAN_DEDUCTIBLE_TYPE = '3';
    ELSE PLAN_DEDUCTIBLE_TYPE = ' ';
  END;

  ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_ANN_DEDUCT_COMB_TYPE='2' THEN DO;
    *IF PBP_B1A_MC_COPAY_CSTSHR_YN_T1='1' | PBP_B1B_MC_COPAY_CSTSHR_YN_T1='1' THEN PLAN_DEDUCT_PTA=0;
    *ELSE PLAN_DEDUCT_PTA=&PARTA_DEDUCT.;
    PLAN_DEDUCT_PTA=&PARTA_DEDUCT.;
    PLAN_DEDUCT_PTB=&PARTB_DEDUCT.;
  END;

  * IN NETWORK DEDUCTIBLE;
  ELSE IF PBP_D_INN_DEDUCT_YN = '1' THEN DO;
    IF PBP_D_INN_DEDUCT_PARTB_YN = '1' THEN PLAN_DEDUCTIBLE = &PARTB_DEDUCT.;
    ELSE PLAN_DEDUCTIBLE = PBP_D_INN_DEDUCT_AMT;
    PLAN_DEDUCTIBLE_BENS = PBP_D_INN_DEDUCT_BENS;

    IF PLAN_DEDUCTIBLE_BENS = '01' THEN PLAN_DEDUCTIBLE_TYPE = '1';
    ELSE IF PLAN_DEDUCTIBLE_BENS = '10' THEN PLAN_DEDUCTIBLE_TYPE = '2';
    ELSE IF PLAN_DEDUCTIBLE_BENS = '11' THEN PLAN_DEDUCTIBLE_TYPE = '3';
    ELSE PLAN_DEDUCTIBLE_TYPE = ' ';
  END;

  * COMBINE DEDUCTIBLE;
  ELSE IF PBP_D_COMB_DEDUCT_YN = '1' &
    (SUBSTR(PBP_D_COMB_DEDUCT_BENS,2,1)='1' | SUBSTR(PBP_D_COMB_DEDUCT_BENS,3,1)='1') THEN DO;
    IF PBP_D_COMB_DEDUCT_PARTB_YN = '1' THEN PLAN_DEDUCTIBLE = &PARTB_DEDUCT.;
    ELSE PLAN_DEDUCTIBLE = PBP_D_COMB_DEDUCT_AMT;
    PLAN_DEDUCTIBLE_BENS = SUBSTR(PBP_D_COMB_DEDUCT_BENS,2,2);

    IF SUBSTR(PBP_D_COMB_DEDUCT_BENS,2,2)='10' THEN PLAN_DEDUCTIBLE_TYPE = '1';
    ELSE IF SUBSTR(PBP_D_COMB_DEDUCT_BENS,2,2)='01' THEN PLAN_DEDUCTIBLE_TYPE = '2';
    ELSE IF SUBSTR(PBP_D_COMB_DEDUCT_BENS,2,2)='11' THEN PLAN_DEDUCTIBLE_TYPE = '3';
    ELSE PLAN_DEDUCTIBLE_TYPE = ' ';
  END;

  IF PLAN_DEDUCTIBLE > 0 | PUT(HPLAN,$TYPEF.) = 'MSA' | (PBP_A_PLAN_TYPE IN('04','31','44','47') & PBP_D_ANN_DEDUCT_COMB_TYPE='2');

  *KEEP HPLAN PLAN_DEDUCTIBLE PLAN_DEDUCTIBLE_TYPE PBP_D_MSA_DED_AMT PBP_D_MSA_ANNUAL_AMT
    PBP_A_PLAN_TYPE PBP_D_ANN_DEDUCT_COMB_TYPE PBP_B1A_MC_COPAY_CSTSHR_YN_T1
    PBP_B1B_MC_COPAY_CSTSHR_YN_T1 PLAN_DEDUCT_PTA PLAN_DEDUCT_PTB;
RUN;

PROC SORT DATA = PBP_DEDUCTIBLE;
  BY HPLAN;
RUN;

PROC SORT DATA=&INC OUT=UTILIZATION;
  BY YEAR BASEID CATEGORY;
RUN;

DATA UTILIZATION;
  SET UTILIZATION;
  BY YEAR BASEID CATEGORY;
  RETAIN AMTTOT_MC AMTTOT_AMO AMTTOT_MC_PTA AMTTOT_AMO_PTA;
  IF FIRST.CATEGORY THEN DO;
    AMTTOT_MC=0;
    AMTTOT_AMO=0;
    AMTTOT_TOTAL = 0;
    AMTTOT_MC_PTA = 0;
    AMTTOT_MC_PTB = 0;
    AMTTOT_AMO_PTA = 0;
  END;

  IF CATEGORY IN ('1a','1b','2') THEN DO;
    IF UTLZNDAY > 0 THEN DO;
      AMTTOT_MC=SUM(AMTTOT_MC,AMTTOT_FACILITY,AMTTOT_PHYSICIAN);
      AMTTOT_MC_PTA=SUM(AMTTOT_MC_PTA,AMTTOT_FACILITY,AMTTOT_PHYSICIAN);
    END;
    ELSE DO;
      AMTTOT_AMO=SUM(AMTTOT_AMO,AMTTOT_FACILITY,AMTTOT_PHYSICIAN);
      AMTTOT_AMO_PTA=SUM(AMTTOT_AMO_PTA,AMTTOT_FACILITY,AMTTOT_PHYSICIAN);
    END;
  END;
  ELSE IF CATEGORY IN ('8a1','8a2','8b1','8b2','8b3') THEN DO;
    AMTTOT_MC + AMTTOT;
    AMTTOT_MC_PTB + AMTTOT;
    AMTTOT_TOTAL + AMTTOT;
  END;
  ELSE DO;
    AMTTOT_MC=AMTTOT;
    AMTTOT_MC_PTB=AMTTOT;
  END;
  IF LAST.CATEGORY;
RUN;

DATA UTILIZATION;
  SET UTILIZATION;
  BY YEAR BASEID CATEGORY;
  IF CATEGORY='16' THEN DO;
    AMTTOT_AMO = PREVENT_DENTAL_SHARE * AMTTOT;
    CATEGORY='16a';
    OUTPUT;
    AMTTOT_AMO = (1-PREVENT_DENTAL_SHARE) * AMTTOT;
    CATEGORY='16b';
    OUTPUT;
  END;
  ELSE IF CATEGORY='16b' THEN DO;
    AMTTOT_MC = AMTTOT;
    AMTTOT_MC_PTB = AMTTOT;
    OUTPUT;
  END;
  ELSE DO;
    OUTPUT;
  END;
RUN;

PROC SUMMARY DATA = UTILIZATION NWAY MISSING;
  CLASS BASEID CATEGORY YEAR;
  VAR AMTTOT AMTTOT_MC AMTTOT_AMO AMTTOT_MC_PTA AMTTOT_AMO_PTA AMTTOT_MC_PTB
      VISITS AMTTOT_TOTAL;
  OUTPUT OUT = UTIL_SUMMARY (DROP = _TYPE_ _FREQ_) SUM = ;
RUN;

DATA PBP_PLANS;
 SET PBP_FILE(KEEP = HPLAN);
 JOIN_ID = '1';
RUN; 

%macro utilsum(year);

  DATA UTIL_SUMMARY_&YEAR.;
    SET UTIL_SUMMARY (WHERE = (YEAR = "&YEAR."));
    IF CATEGORY IN ('8a1','8a2','8b1','8b2','8b3') THEN AMTTOT = AMTTOT_TOTAL;
    JOIN_ID = '1';
  RUN;

  PROC SQL;
    CREATE TABLE PBPCATS_MCCOST_&YEAR AS
      (SELECT B.CATEGORY, B.BASEID, B.YEAR, B.AMTTOT, B.AMTTOT_MC, B.AMTTOT_AMO,
       B.AMTTOT_MC_PTA, B.AMTTOT_AMO_PTA, B.AMTTOT_MC_PTB, B.VISITS,
       P.HPLAN
      FROM UTIL_SUMMARY_&year. B, PBP_PLANS P
      WHERE B.JOIN_ID = P.JOIN_ID)
    ;
  QUIT;

  PROC SORT DATA = PBPCATS_MCCOST_&YEAR;
    BY HPLAN CATEGORY;
  RUN;

  %MACRO DEDMAC(VARNAME=,FNAME=);

    DATA FMTDATA;
      SET PBP_FILE END=LAST;
      LENGTH HLO $1 START $11;
      FMTNAME=&FNAME.;
      START=HPLAN;
      LABEL=&VARNAME.;
      HLO=' ';
      OUTPUT;
      IF LAST THEN DO;
        START="OTHER";
        LABEL=0;
        HLO='O';
        OUTPUT;
      END;
      KEEP FMTNAME START LABEL HLO;
    RUN;

    PROC FORMAT CNTLIN=FMTDATA;
    RUN;

  %MEND;

  %DEDMAC(VARNAME=PBP_B4A_COPAY_AMT_MC_MIN,FNAME="$COP4AFMT");
  %DEDMAC(VARNAME=PBP_B4A_COINS_PCT_MC_MIN,FNAME="$COI4AFMT");
  %DEDMAC(VARNAME=PBP_B4B_COPAY_AMT_MC_MIN,FNAME="$COP4BFMT");
  %DEDMAC(VARNAME=PBP_B4B_COINS_PCT_MC_MIN,FNAME="$COI4BFMT");
  %DEDMAC(VARNAME=PBP_B4A_MAX_VISIT,FNAME="$MAX4AFMT");
  %DEDMAC(VARNAME=PBP_B4B_MAX_VISIT,FNAME="$MAX4BFMT");

  DATA PBPCATS_MERGE;
    MERGE PBPCATS_MCCOST_&YEAR (IN = A)
          DEDUCTION_CATS (IN = B);
    BY HPLAN CATEGORY;
    LENGTH DEDGRP $1;

    PBP_B4A_COPAY_AMT_MC_MIN=INPUT(PUT(HPLAN,$COP4AFMT.),8.);
    PBP_B4A_COINS_PCT_MC_MIN=INPUT(PUT(HPLAN,$COI4AFMT.),8.);
    PBP_B4B_COPAY_AMT_MC_MIN=INPUT(PUT(HPLAN,$COP4BFMT.),8.);
    PBP_B4B_COINS_PCT_MC_MIN=INPUT(PUT(HPLAN,$COI4BFMT.),8.);
    PBP_B4A_MAX_VISIT=INPUT(PUT(HPLAN,$MAX4AFMT.),8.);
    PBP_B4B_MAX_VISIT=INPUT(PUT(HPLAN,$MAX4BFMT.),8.);

    IF A & B THEN DO;
      DEDGRP = '1';
      IF CATEGORY='4a' THEN DO;
        DEDUCT_ER=0;
        IF VISITS>0 & PBP_B4A_COPAY_AMT_MC_MIN> 0 THEN
          DEDUCT_ER = SUM(DEDUCT_ER, VISITS*PBP_B4A_COPAY_AMT_MC_MIN);
        IF PUT(HPLAN,$TYPEF.) NOT IN("FFS","MGAP") THEN DO;
          IF VISITS>0 & PBP_B4A_COINS_PCT_MC_MIN>0 & AMTTOT>0 THEN
            DEDUCT_ER = SUM(DEDUCT_ER, MIN(AMTTOT*PBP_B4A_COINS_PCT_MC_MIN,VISITS*PBP_B4A_MAX_VISIT));
        END;
        ELSE IF PUT(HPLAN,$TYPEF.) IN("FFS","MGAP") THEN DO;
          IF PBP_B4A_COINS_PCT_MC_MIN>0 & AMTTOT>0 THEN
            DEDUCT_ER = SUM(DEDUCT_ER,AMTTOT*PBP_B4A_COINS_PCT_MC_MIN);
        END;
      END;
      IF CATEGORY='4b' THEN DO;
        DEDUCT_URG=0;
        IF VISITS>0 & PBP_B4B_COPAY_AMT_MC_MIN>0 THEN
          DEDUCT_URG = SUM(DEDUCT_URG, VISITS*PBP_B4B_COPAY_AMT_MC_MIN);
        IF PUT(HPLAN,$TYPEF.) NOT IN("FFS","MGAP") THEN DO;
          IF VISITS>0 & PBP_B4B_COINS_PCT_MC_MIN>0 & AMTTOT>0 THEN
            DEDUCT_URG = SUM(DEDUCT_URG, MIN(AMTTOT*PBP_B4B_COINS_PCT_MC_MIN,VISITS*PBP_B4B_MAX_VISIT));
        END;
        ELSE IF PUT(HPLAN,$TYPEF.) IN("FFS","MGAP") THEN DO;
          IF PBP_B4B_COINS_PCT_MC_MIN>0 & AMTTOT>0 THEN
            DEDUCT_URG = SUM(DEDUCT_URG,AMTTOT*PBP_B4B_COINS_PCT_MC_MIN);
        END;
      END;
    END;
    ELSE DEDGRP = '0';
    IF A;
  RUN;

  PROC SUMMARY DATA = PBPCATS_MERGE NWAY MISSING;
    WHERE DEDGRP = '1';
    CLASS HPLAN BASEID;
    VAR AMTTOT AMTTOT_MC AMTTOT_AMO AMTTOT_MC_PTA AMTTOT_AMO_PTA
      AMTTOT_MC_PTB DEDUCT_ER DEDUCT_URG MEDICARE_FLG NONMEDICARE_FLG;
    OUTPUT OUT = PBPCATS_SUMMARY (DROP = _TYPE_ _FREQ_)
      SUM = TOTAL_AMTTOT TOTAL_AMTTOT_MC TOTAL_AMTTOT_AMO
      TOTAL_AMTTOT_MC_PTA TOTAL_AMTTOT_AMO_PTA
      TOTAL_AMTTOT_MC_PTB
      TOTAL_DEDUCT_ER TOTAL_DEDUCT_URG TOTAL_MEDICARE_FLG TOTAL_NONMEDICARE_FLG;
  RUN;

  DATA PBP_TOTCOST_DED_MERG;
    MERGE PBPCATS_SUMMARY (IN = A)
          PBP_DEDUCTIBLE (IN = B);
    BY HPLAN;
    IF A & B;
  RUN;

  DATA PBP_TOTCOST_DED;
    SET PBP_TOTCOST_DED_MERG;

    PLAN_DEDUCTIBLE=MAX(0,SUM(PLAN_DEDUCTIBLE,-TOTAL_DEDUCT_ER,-TOTAL_DEDUCT_URG));
    PLAN_DEDUCT_PTB=MAX(0,SUM(PLAN_DEDUCT_PTB,-TOTAL_DEDUCT_ER,-TOTAL_DEDUCT_URG));

    IF TYPE ^= 'MSA' THEN DO;
      IF TOTAL_AMTTOT <= PLAN_DEDUCTIBLE THEN DO;
        AMTTOT_REDUCTION = 0;
        AMTTOT_DEDUCTIBLE = TOTAL_AMTTOT;
      END;
      ELSE IF TOTAL_AMTTOT > 0 & TOTAL_AMTTOT > PLAN_DEDUCTIBLE THEN DO;
        AMTTOT_REDUCTION = 1 - (PLAN_DEDUCTIBLE / TOTAL_AMTTOT);
        AMTTOT_DEDUCTIBLE = PLAN_DEDUCTIBLE;
      END;

      IF TOTAL_AMTTOT_MC <= PLAN_DEDUCTIBLE THEN DO;
        AMTTOT_REDUCTION_MC = 0;
        AMTTOT_DEDUCTIBLE_MC = TOTAL_AMTTOT_MC;
      END;
      ELSE IF TOTAL_AMTTOT_MC > 0 & TOTAL_AMTTOT_MC > PLAN_DEDUCTIBLE THEN DO;
        AMTTOT_REDUCTION_MC = 1 - (PLAN_DEDUCTIBLE / TOTAL_AMTTOT_MC);
        AMTTOT_DEDUCTIBLE_MC = PLAN_DEDUCTIBLE;
      END;

      IF PLAN_DEDUCT_PTA > 0 & TOTAL_AMTTOT_MC_PTA <= PLAN_DEDUCT_PTA THEN DO;
        AMTTOT_REDUCTION_MC_PTA = 0;
        AMTTOT_DEDUCTIBLE_MC_PTA = TOTAL_AMTTOT_MC_PTA;
      END;
      ELSE IF PLAN_DEDUCT_PTA > 0 & TOTAL_AMTTOT_MC_PTA > 0 & TOTAL_AMTTOT_MC_PTA > PLAN_DEDUCT_PTA THEN DO;
        AMTTOT_REDUCTION_MC_PTA = 1 - (PLAN_DEDUCT_PTA / TOTAL_AMTTOT_MC_PTA);
        AMTTOT_DEDUCTIBLE_MC_PTA = PLAN_DEDUCT_PTA;
      END;

      IF PLAN_DEDUCT_PTB > 0 & TOTAL_AMTTOT_MC_PTB <= PLAN_DEDUCT_PTB THEN DO;
        AMTTOT_REDUCTION_MC_PTB = 0;
        AMTTOT_DEDUCTIBLE_MC_PTB = TOTAL_AMTTOT_MC_PTB;
      END;
      ELSE IF PLAN_DEDUCT_PTB > 0 & TOTAL_AMTTOT_MC_PTB > 0 & TOTAL_AMTTOT_MC_PTB > PLAN_DEDUCT_PTB THEN DO;
        AMTTOT_REDUCTION_MC_PTB = 1 - (PLAN_DEDUCT_PTB / TOTAL_AMTTOT_MC_PTB);
        AMTTOT_DEDUCTIBLE_MC_PTB = PLAN_DEDUCT_PTB;
      END;
    END;

    ELSE IF TYPE='MSA' THEN DO;
      IF TOTAL_AMTTOT_MC>PBP_D_MSA_DED_AMT THEN
        AMTTOT_REDUCTION_MC = 1 - (PBP_D_MSA_DED_AMT/TOTAL_AMTTOT_MC);
      ELSE AMTTOT_REDUCTION_MC=1;
    END;
  RUN;

  PROC SORT DATA = PBP_TOTCOST_DED OUT = PBPCATS_PBP_DED;
    BY BASEID HPLAN;
  RUN;

  PROC SORT DATA = PBPCATS_MERGE;
    BY BASEID HPLAN;
  RUN;

  DATA PBPCATS_MCCOST_DED;
    MERGE PBPCATS_MERGE(IN = A)
          PBPCATS_PBP_DED(IN = B DROP=PBP_A_PLAN_TYPE);
    BY BASEID HPLAN;

    IF A & B & DEDGRP = '1';
    PLAN_DED_AMTTOT = AMTTOT * ((1 - AMTTOT_REDUCTION));
    PLAN_DED_AMTTOT_MC = AMTTOT_MC * ((1 - AMTTOT_REDUCTION_MC));

    PLAN_DED_AMTTOT_MC_PTA = AMTTOT_MC_PTA * ((1 - AMTTOT_REDUCTION_MC_PTA));
    PLAN_DED_AMTTOT_MC_PTB = AMTTOT_MC_PTB * ((1 - AMTTOT_REDUCTION_MC_PTB));

    * ASSUME PLAN DEDUCTIBLE USED ON MEDICARE BENEFITS UNLESS INSUFFICENT MEDICARE EXPENDITURES;
    * OR DEDUCTIBLE ONLY APPLIES TO NON MEDICARE COVERED BENEFITS;

    IF TOTAL_MEDICARE_FLG > 0 THEN DO;
      PLAN_DED_AMTTOT = PLAN_DED_AMTTOT_MC;
      PLAN_DEDUCT_PTA = PLAN_DED_AMTTOT_MC_PTA;
      PLAN_DEDUCT_PTB = PLAN_DED_AMTTOT_MC_PTB;
    END;
    ELSE IF TOTAL_NONMEDICARE_FLG > 0 THEN DO;
      PLAN_DED_AMTTOT_MC = 0;
      PLAN_DED_AMTTOT_MC_PTA = 0;
      PLAN_DED_AMTTOT_MC_PTB = 0;
      IF TOTAL_AMTTOT_AMO > 0 THEN DO;
        AMTTOT_REDUCTION_AMO = 1 - (PLAN_DEDUCTIBLE / TOTAL_AMTTOT_AMO);
        PLAN_DED_AMTTOT = AMTTOT_AMO * ((1 - AMTTOT_REDUCTION_AMO));
      END;
    END;

    KEEP HPLAN BASEID YEAR CATEGORY PLAN_DED_AMTTOT PLAN_DED_AMTTOT_MC
         PLAN_DED_AMTTOT_MC_PTA PLAN_DED_AMTTOT_MC_PTB PLAN_DEDUCT_PTA PLAN_DEDUCT_PTB;
  RUN;

  PROC SORT DATA = PBPCATS_MCCOST_DED OUT = PBPCATS_MCCOST_DED_&YEAR;
    BY HPLAN BASEID YEAR CATEGORY;
  RUN;

  PROC DATASETS;
  DELETE PBPCATS_MERGE PBP_TOTCOST_DED PBP_TOTCOST_DED_MERG
    PBPCATS_PBP_DED PBPCATS_SUMMARY PBPCATS_MCCOST_&YEAR;
  RUN;

%MEND;

%UTILSUM(&year1);
%UTILSUM(&year2);

DATA PBPCATS_MCCOST_DED;
SET PBPCATS_MCCOST_DED_2019
    PBPCATS_MCCOST_DED_2020;
  BY HPLAN BASEID YEAR CATEGORY;
RUN;