* PROGRAM NAME:  PBP_DRUG_VARIABLES.SAS;
* DESCRIPTION: PREPARE THE DRUG VARIABLES;

LIBNAME FORM "&FORMULARY";

LIBNAME LIBRARY "&INPUTDIR";

%MACRO PBPX();

  %IF &INPUT^=INPUTCMS %THEN %DO;
    DATA PBP_MRX_MRG;
      MERGE PBP_MRX (IN=A) PBP_FILE_PARTD(IN=B KEEP=HPLAN CONTRACT_ID PLAN_ID);
      BY HPLAN;
      IF A & B;
    RUN;
  %END;
  %ELSE %IF &INPUT=INPUTCMS %THEN %DO;
    DATA PBP_MRX_MRG;
      SET PBP_MRX;
      LENGTH CONTRACT_ID $5 PLAN_ID $3;
      CONTRACT_ID=SUBSTR(QID,1,5);
      PLAN_ID=SUBSTR(QID,6,3);
    RUN;
  %END;
%MEND;

%PBPX();

* BENEFIT INPUT;

DATA PBP_MRX;
  SET PBP_MRX_MRG;
  * ASSIGN VARIABLE TYPES;
  IF MRX_DRUG_BEN_YN = '1' THEN DO;
    SELECT(MRX_BENEFIT_TYPE);
      WHEN('1') DO;
        PLAN_DEDUCTIBLE = &&DEDUCTIBLE_&RUNYEAR.;
        PLAN_ICL = &&ICL_&RUNYEAR.;
        PLAN_THRESHOLD = &&THRESHOLD_&RUNYEAR.;
      END;
      WHEN('2') DO;
        PLAN_DEDUCTIBLE = &&DEDUCTIBLE_&RUNYEAR.;
        PLAN_ICL = &&ICL_&RUNYEAR.;
        PLAN_THRESHOLD = &&THRESHOLD_&RUNYEAR.;
      END;
      WHEN('3') DO;
        IF MRX_ALT_COV_LMT_YN = '1' THEN PLAN_ICL = &&ICL_&RUNYEAR.;
        ELSE IF MRX_ALT_COV_LMT_YN = '2' THEN PLAN_ICL = MRX_ALT_COV_LMT_AMT;
        ELSE IF MRX_ALT_COV_LMT_YN = '3' THEN PLAN_ICL = &&THRESHOLD_&RUNYEAR.;

        IF MRX_ALT_DED_CHARGE = '1' THEN PLAN_DEDUCTIBLE = &&DEDUCTIBLE_&RUNYEAR.;
        ELSE IF MRX_ALT_DED_CHARGE = '2' THEN PLAN_DEDUCTIBLE = MRX_ALT_DED_AMOUNT;
        ELSE IF MRX_ALT_DED_CHARGE = '3' THEN PLAN_DEDUCTIBLE = 0;

        PLAN_THRESHOLD = &&THRESHOLD_&RUNYEAR.;
      END;
      WHEN('4') DO;
        IF MRX_ALT_COV_LMT_YN = '1' THEN PLAN_ICL = &&ICL_&RUNYEAR.;
        ELSE IF MRX_ALT_COV_LMT_YN = '2' THEN PLAN_ICL = MRX_ALT_COV_LMT_AMT;
        ELSE IF MRX_ALT_COV_LMT_YN = '3' THEN PLAN_ICL = &&THRESHOLD_&RUNYEAR.;

        IF MRX_ALT_DED_CHARGE = '1' THEN PLAN_DEDUCTIBLE = &&DEDUCTIBLE_&RUNYEAR.;
        ELSE IF MRX_ALT_DED_CHARGE = '2' THEN PLAN_DEDUCTIBLE = MRX_ALT_DED_AMOUNT;
        ELSE IF MRX_ALT_DED_CHARGE = '3' THEN PLAN_DEDUCTIBLE = 0;

        PLAN_THRESHOLD = &&THRESHOLD_&RUNYEAR.;
      END;
      OTHERWISE;
    END;
    IF (MRX_BENEFIT_TYPE = '1') OR
      (MRX_BENEFIT_TYPE = '2' AND MRX_AE_CSTSHR_APPLY='1') OR
      (MRX_BENEFIT_TYPE = '3' AND MRX_ALT_PRE_ICL_COST_SHARE = '2') OR
      (MRX_BENEFIT_TYPE = '4' AND MRX_ALT_PRE_ICL_COST_SHARE = '2') THEN DO;
      PLAN_COPAY = .;
      PLAN_COINS = 25;
      PLAN_IRA_COPAY = MRX_GEN_IRA_RSTD_COPAY_1M;
    END;
    ELSE IF (MRX_BENEFIT_TYPE = '3' AND MRX_ALT_PRE_ICL_COST_SHARE = '1') OR
      (MRX_BENEFIT_TYPE = '4' AND MRX_ALT_PRE_ICL_COST_SHARE = '1') THEN DO;
      PLAN_COPAY = 0;
      PLAN_COINS = 0;
      PLAN_IRA_COPAY = 0;
    END;
    IF (MRX_BENEFIT_TYPE IN ('1','2','3')) OR
      (MRX_BENEFIT_TYPE = '4' AND MRX_ALT_GAP_COVG_YN = '2') THEN DO;
      PLAN_COPAY_GAP = .;
      PLAN_COINS_GAP = .;
    END;

    IF MRX_BENEFIT_TYPE IN ('3','4') AND MRX_ALT_DED_TYPE_YN = '2' THEN DO;
      PLAN_COINS_PRE = MRX_ALT_GEN_COINS_PCT;
      PLAN_COPAY_PRE = MRX_ALT_GEN_COPAY_AMT;
    END;

  END;
  IF PLAN_COINS NE .           THEN PLAN_COINS           =  PLAN_COINS / 100;
  IF PLAN_COINS_GAP NE .       THEN PLAN_COINS_GAP       =  PLAN_COINS_GAP / 100;
  IF PLAN_COINS_PRE NE .       THEN PLAN_COINS_PRE       =  PLAN_COINS_PRE / 100;

  KEEP MRX_DRUG_BEN_YN MRX_BENEFIT_TYPE PLAN_DEDUCTIBLE PLAN_ICL PLAN_THRESHOLD MRX_AE_CSTSHR_APPLY
       MRX_ALT_PRE_ICL_COST_SHARE
       PLAN_COPAY PLAN_COINS
       PLAN_COPAY_GAP PLAN_COINS_GAP MRX_ALT_GAP_COVG_YN
       MRX_ALT_DED_TYPE_YN MRX_ALT_NO_DED_TIER MRX_ALT_DED_TIER_CSTSHR_YN
       HPLAN PLAN_COPAY_PRE PLAN_COINS_PRE MRX_ALT_GEN_CSTSHR_STRUCT CONTRACT_ID PLAN_ID MRX_FIRST_FILL 
       MRX_TIER_FORM_EX MRX_TIER_FORM_EX_2_YN MRX_TIER_FORM_EX_2 PLAN_IRA_COPAY;
RUN;

PROC SORT DATA = PBP_MRX NODUPKEY;
  BY HPLAN;
RUN;

PROC SORT DATA = PBP_MRX OUT = MRX_TYPES (KEEP = MRX_BENEFIT_TYPE) NODUPKEY;
  BY MRX_BENEFIT_TYPE;
RUN;

DATA DS AE BA EA;
  SET MRX_TYPES;
  IF MRX_BENEFIT_TYPE = '1' THEN OUTPUT DS;
  ELSE IF MRX_BENEFIT_TYPE = '2' THEN OUTPUT AE;
  ELSE IF MRX_BENEFIT_TYPE = '3' THEN OUTPUT BA;
  ELSE IF MRX_BENEFIT_TYPE = '4' THEN OUTPUT EA;      
RUN;  
  
%GLOBAL DSPLAN AEPLAN BAPLAN EAPLAN;
RUN;

DATA _NULL_;
  CALL SYMPUT('DSPLAN',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET DS NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('AEPLAN',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET AE NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('BAPLAN',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET BA NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('EAPLAN',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET EA NOBS=NUMOBS;
  STOP;
RUN;

PROC SORT DATA=PBP_MRX_TIER OUT = PBP_MRX_TIERS;
  BY HPLAN MRX_TIER_ID MRX_TIER_TYPE_ID;
RUN;

%MACRO PBPC();

  %IF &INPUT^=INPUTCMS %THEN %DO;
    DATA COMBINE_MRG;
      MERGE PBP_MRX_TIERS (IN=A) PBP_FILE_PARTD (IN=B KEEP=HPLAN);
      BY HPLAN;
      IF A & B;
    RUN;
  %END;
  %ELSE %IF &INPUT=INPUTCMS %THEN %DO;
    DATA COMBINE_MRG;
      SET COMBINE;
      BY HPLAN;
    RUN;   
  %END;
%MEND;

%PBPC();

DATA PBP_T (RENAME = STRUCT_TYPE = MRX_TIER_CSTSHR_STRUCT_TYPE);
  SET COMBINE_MRG;
  BY HPLAN MRX_TIER_ID MRX_TIER_TYPE_ID;
  RETAIN PLAN_COPAY PLAN_COINS PLAN_COPAY_GAP PLAN_COINS_GAP STRUCT_TYPE PLAN_IRA_COPAY;
  ARRAY D PLAN_COPAY PLAN_COINS PLAN_COPAY_GAP PLAN_COINS_GAP PLAN_IRA_COPAY;
  LENGTH STRUCT_TYPE $3;
  IF FIRST.MRX_TIER_ID THEN DO;
    DO I = 1 TO 5;
      D(I) = .;
    END;
    STRUCT_TYPE  = '000';
  END;
  IF MRX_TIER_TYPE_ID = '1' THEN  SUBSTR(STRUCT_TYPE,1,1) = MRX_TIER_CSTSHR_STRUCT_TYPE;
  ELSE IF MRX_TIER_TYPE_ID = '2' THEN  SUBSTR(STRUCT_TYPE,2,1) = MRX_TIER_CSTSHR_STRUCT_TYPE;
  ELSE IF MRX_TIER_TYPE_ID = '3' THEN  SUBSTR(STRUCT_TYPE,3,1) = MRX_TIER_CSTSHR_STRUCT_TYPE;
  ARRAY CP MRX_TIER_RSPFD_COPAY_1M MRX_TIER_RSTD_COPAY_1M MRX_TIER_RSSTD_COPAY_1M MRX_TIER_OONP_COPAY_1M;
  ARRAY CN MRX_TIER_RSPFD_COINS_1M MRX_TIER_RSTD_COINS_1M MRX_TIER_RSSTD_COINS_1M MRX_TIER_OONP_COINS_1M;
  ARRAY IRACP MRX_TIER_IRA_RSPFD_COPAY_1M MRX_TIER_IRA_RSTD_COPAY_1M;
  SELECT;
    WHEN(MRX_TIER_CSTSHR_STRUCT_TYPE = '1') DO;
      FOUND_FLAG = '0';
      DO I = 1 TO 4;
        IF FOUND_FLAG = '0' AND CN(I) NE . THEN DO;
          FOUND_FLAG = '1';
          SELECT(MRX_TIER_TYPE_ID);
            WHEN('1') PLAN_COINS = CN(I);
            WHEN('3') DO;
              IF MRX_TIER_GAP_COST_SHARE IN ('1','2') & MRX_TIER_INCLUDES NE '2' THEN DO;
                GAP_COVERAGE_FLAG = MRX_TIER_GAP_COST_SHARE;
                PLAN_COINS_GAP = CN(I);
              END;
            END;
            OTHERWISE;
          END;
        END;
      END;
    END;
    WHEN(MRX_TIER_CSTSHR_STRUCT_TYPE = '2') DO;
      FOUND_FLAG = '0';
      DO I = 1 TO 4;
        IF FOUND_FLAG = '0' AND CP(I) NE . THEN DO;
          FOUND_FLAG = '1';
          SELECT(MRX_TIER_TYPE_ID);
            WHEN('1') PLAN_COPAY = CP(I);
            WHEN('3') DO;
              IF MRX_TIER_GAP_COST_SHARE IN ('1','2')  & MRX_TIER_INCLUDES NE '2' THEN DO;
                GAP_COVERAGE_FLAG = MRX_TIER_GAP_COST_SHARE;
                PLAN_COPAY_GAP = CP(I);
              END;
            END;
            OTHERWISE;
          END;
        END;
      END;
    END;
    WHEN(MRX_TIER_CSTSHR_STRUCT_TYPE  IN ('3','4')) DO;
      FOUND_FLAG_CP = '0';
      FOUND_FLAG_CN = '0';
      DO I = 1 TO 4;
        IF FOUND_FLAG_CN = '0' AND CN(I) NE . THEN DO;
          FOUND_FLAG_CN = '1';
          SELECT(MRX_TIER_TYPE_ID);
            WHEN('1') PLAN_COINS = CN(I);
            WHEN('3') DO;
              IF MRX_TIER_GAP_COST_SHARE IN ('1','2')  & MRX_TIER_INCLUDES NE '2' THEN DO;
                GAP_COVERAGE_FLAG = MRX_TIER_GAP_COST_SHARE;
                PLAN_COINS_GAP = CN(I);
              END;
            END;
            OTHERWISE;
          END;
        END;
        IF FOUND_FLAG_CP = '0' AND CP(I) NE . THEN DO;
          FOUND_FLAG_CP = '1';
          SELECT(MRX_TIER_TYPE_ID);
            WHEN('1') PLAN_COPAY = CP(I);
            WHEN('3') DO;
              IF MRX_TIER_GAP_COST_SHARE IN ('1','2')  & MRX_TIER_INCLUDES NE '2' THEN DO;
                GAP_COVERAGE_FLAG = MRX_TIER_GAP_COST_SHARE;
                PLAN_COPAY_GAP = CP(I);
              END;
            END;
            OTHERWISE;
          END;
        END;
      END;
    END;
    OTHERWISE;
  END;
  IRA_FOUND_FLAG = '0';
  DO I = 1 TO 2;
    IF IRA_FOUND_FLAG = '0' AND IRACP(I) NE . THEN DO;
      IRA_FOUND_FLAG = '1';
      PLAN_IRA_COPAY = IRACP(I);
    END;
  END;  
  IF LAST.MRX_TIER_ID;
  IF PLAN_COINS NE .     THEN PLAN_COINS = PLAN_COINS / 100;
  IF PLAN_COINS_GAP NE . THEN PLAN_COINS_GAP = PLAN_COINS_GAP / 100;
  KEEP MRX_TIER_ID PLAN_COPAY PLAN_COINS HPLAN
       PLAN_COPAY_GAP PLAN_COINS_GAP GAP_COVERAGE_FLAG STRUCT_TYPE PLAN_IRA_COPAY;
RUN;

PROC SORT DATA = PBP_T;
  BY HPLAN;
RUN;

DATA PLAN_FORM;
  LENGTH CONTPLN $8;
  SET FORM.PLAN_FORMULARY;
  CONTPLN = CONTRACT_ID!!PLAN_ID;
  IF PUT(CONTPLN,$CONTPLNF.) NE 'NO';
RUN;

PROC SORT DATA=PLAN_FORM OUT=PLANFORM (KEEP=CONTRACT_ID PLAN_ID FORMULARY_ID) NODUPKEY;
  BY CONTRACT_ID PLAN_ID;
RUN;

DATA MRX_TEMP1;
  MERGE PBP_MRX (IN = A)
        PBP_T (IN = B RENAME=(PLAN_COINS=PLAN_COINS_T PLAN_COPAY=PLAN_COPAY_T
              PLAN_COINS_GAP=PLAN_COINS_GAP_T PLAN_COPAY_GAP=PLAN_COPAY_GAP_T PLAN_IRA_COPAY = PLAN_IRA_COPAY_T));
  BY HPLAN;
  IF A;
  TIERFLAG=B;
RUN;

DATA MRX_TEMP2;
  MERGE MRX_TEMP1 (IN=A)
        PLANFORM (IN=B);
  BY CONTRACT_ID PLAN_ID;
  IF A;
  PLANFORMFLAG=B;
RUN;

PROC SORT DATA=MRX_TEMP2 OUT=MRX_TEMP_SORT;
  BY FORMULARY_ID;
RUN;

%MACRO TIERCNT();
  %IF &INPUT^=INPUTCMS %THEN %DO;
    PROC SORT DATA=FORM.FORMULARY OUT=FORMSORT (KEEP=FORMULARY_ID TIER_LEVEL_VALUE) NODUPKEY;
      BY FORMULARY_ID TIER_LEVEL_VALUE;
    RUN;
  %END;
  %ELSE %IF &INPUT=INPUTCMS %THEN %DO;
    PROC SORT DATA=FORM.FORMULARYTIERS(KEEP=FORMULARY_ID TIER_LEVEL RENAME=TIER_LEVEL=TIER_LEVEL_VALUE) OUT=FORMSORT NODUPKEY;
      BY FORMULARY_ID TIER_LEVEL_VALUE;
    RUN;
  %END;
%MEND;

%TIERCNT();

DATA FORMROLL (KEEP=FORMULARY_ID T1-T10 TCNT);
  SET FORMSORT;
  BY FORMULARY_ID TIER_LEVEL_VALUE;
  RETAIN T1-T10 TCNT;
  ARRAY T(10) $1 T1-T10;
  IF FIRST.FORMULARY_ID THEN DO;
    TCNT=0;
    DO I=1 TO 10;
      T(I)=' ';
    END;
  END;
  TCNT+1;
  T(TCNT)=TIER_LEVEL_VALUE;
  IF LAST.FORMULARY_ID THEN OUTPUT;
RUN;

DATA MRX_TEMP_FORM;
  MERGE MRX_TEMP_SORT (IN=A) FORMROLL (IN=B);
  BY FORMULARY_ID;
  IF A;
  FORMFLAG=B;
RUN;

DATA MRX_TEMP3 (DROP=I);
  SET MRX_TEMP_FORM;
  IF PLAN_COINS=. & PLAN_COINS_T NE . THEN PLAN_COINS=PLAN_COINS_T;
  IF PLAN_COPAY=. & PLAN_COPAY_T NE . THEN PLAN_COPAY=PLAN_COPAY_T;
  IF PLAN_COINS_GAP=. & PLAN_COINS_GAP_T NE . THEN PLAN_COINS_GAP=PLAN_COINS_GAP_T;
  IF PLAN_COPAY_GAP=. & PLAN_COPAY_GAP_T NE . THEN PLAN_COPAY_GAP=PLAN_COPAY_GAP_T;
  IF PLAN_IRA_COPAY=. & PLAN_IRA_COPAY_T NE . THEN PLAN_IRA_COPAY=PLAN_IRA_COPAY_T;
  ARRAY T(10) T1-T10;
  IF FORMFLAG=1 & MRX_TIER_ID=' ' & MRX_BENEFIT_TYPE IN ('2','3','4') THEN DO;
    DO I=1 TO TCNT;
      MRX_TIER_ID=T(I);
      OUTPUT;
    END;
  END;
  ELSE OUTPUT;
RUN;

DATA MRX_EXTRACT;
  SET MRX_TEMP3 (DROP= PLAN_COINS_T PLAN_COPAY_T PLAN_COINS_GAP_T PLAN_COPAY_GAP_T
    TIERFLAG PLANFORMFLAG FORMFLAG TCNT T1-T10 CONTRACT_ID PLAN_ID
    PLAN_IRA_COPAY_T);
  IF MRX_ALT_DED_TYPE_YN ='2' THEN DO;
    IF MRX_ALT_DED_TIER_CSTSHR_YN = '1' THEN DO;
      MRX_ALT_GEN_CSTSHR_STRUCT = SUBSTR(MRX_TIER_CSTSHR_STRUCT_TYPE,1,1);
      PLAN_COINS_PRE = PLAN_COINS;
      PLAN_COPAY_PRE = PLAN_COPAY;
    END;
  END;
LENGTH PLAN_COINS PLAN_COINS_GAP PLAN_COINS_PRE
       PLAN_COPAY PLAN_COPAY_GAP PLAN_COPAY_PRE
       PLAN_DEDUCTIBLE PLAN_ICL PLAN_THRESHOLD 
       PLAN_IRA_COPAY 5;
RUN;
