
* PROGRAM: COST_SHARING_HEARINGEXAMS.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR HEARINGEXAMS CLAIMS;

%MACRO HEARINGEXAMS_COST_SHARE(SERV_CAT);

  DATA HEARINGEXAMS_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='18a'));
  RUN;
 
  DATA HEARINGEXAMS_FILE;
    SET  PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B18A_DED_AMT 
                   PBP_B18A_MAXENR_AMT
                   PBP_B18A_MAXENR_PER 
                   PBP_B18A_MED_COINS_PCT
                   PBP_B18A_COPAY_AMT
                   PBP_B18A_COINS_EHC 
                   PBP_B18A_COPAY_EHC
                   PBP_A_PLAN_TYPE
                   PBP_D_DIFF_DEDUCT_18A_AMT);
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B18A_MAXENR_PER,PBP_B18A_MAXENR_AMT);
  RUN;
 
  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM HEARINGEXAMS_BASEID B, HEARINGEXAMS_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;
      
  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='18a'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;

    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DED_AMTTOT_MC_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_18A_AMT;
    ELSE CAT_DEDUCTIBLE=PBP_B18A_DED_AMT;
    
    IF PBP_B18A_MAXENR_AMT NE . THEN 
      BENE_MAXIMUM = PBP_B18A_MAXENR_AMT;

    IF CAT_DEDUCTIBLE = . THEN DO;
      IF SUBSTR(PBP_B18A_COPAY_EHC,2,1)='1' THEN 
        COST = SUM(COST,VISITS*PBP_B18A_COPAY_AMT);
      IF SUBSTR(PBP_B18A_COINS_EHC,2,1)='1' THEN 
        COST = SUM(COST,AMTTOT*PBP_B18A_MED_COINS_PCT);
    END;
    ELSE DO;
      IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
        COST = AMTTOT;
      END;
      ELSE DO;
        COST = CAT_DEDUCTIBLE;
        DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
        AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
        VISITS = VISITS * (1 - DEDUCT_SHARE);
        IF SUBSTR(PBP_B18A_COPAY_EHC,2,1)='1' THEN 
          COST = SUM(COST,VISITS*PBP_B18A_COPAY_AMT);
        IF SUBSTR(PBP_B18A_COINS_EHC,2,1)='1' THEN 
          COST = SUM(COST,AMTTOT*PBP_B18A_MED_COINS_PCT);
      END;
    END;

    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN 
      COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "18a";
  RUN;

  PROC APPEND DATA=HEARINGEXAMS(KEEP=HPLAN YEAR BASEID 
    COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;
 
  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE HEARINGEXAMS HEARINGEXAMS_BASEID HEARINGEXAMS_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;


