
* PROGRAM: COST_SHARING_URGENT_CARE.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR URGENT CARE CLAIMS;

%MACRO URGENT_COST_SHARE(SERV_CAT);

  PROC SUMMARY DATA=&INC NWAY MISSING;
    WHERE CATEGORY IN('4a');
    CLASS BASEID YEAR;
    VAR AMTTOT;
    OUTPUT OUT=CAT_SUMMARY (DROP=_TYPE_ _FREQ_) SUM=;
  RUN;

  %obsnvars(CAT_SUMMARY);
    
  DATA FMTDATA;
    SET CAT_SUMMARY END=LAST;
    LENGTH HLO $1 START $12;
    FMTNAME='$CATFMT';
    START=BASEID || YEAR;
    LABEL=AMTTOT;
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL=0;
      HLO='O';
      OUTPUT;
    END;
    KEEP FMTNAME START LABEL HLO;
  RUN;
    
  PROC FORMAT CNTLIN=FMTDATA;
  RUN;
  
  DATA URGENT_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='4b'));
  RUN;

  DATA URGENT_FILE;
    SET  PBP_FILE(KEEP=
                 CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                 PBP_B4B_MAXENR_AMT 
                 PBP_B4B_MAXENR_PER
                 PBP_B4B_COPAY_AMT_MC_MIN 
                 PBP_B4B_COINS_PCT_MC_MIN
                 PBP_B4B_MAXENR_TYPE 
                 PBP_B4A_MAXENR_AMT 
                 PBP_B4A_MAXENR_PER
                 PBP_A_PLAN_TYPE
                 PBP_B4B_MAX_VISIT
                 );
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B4B_MAXENR_PER,PBP_B4B_MAXENR_AMT);
    %ANNUALIZATION(PBP_B4A_MAXENR_PER,PBP_B4A_MAXENR_AMT);
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM URGENT_BASEID B, URGENT_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;

  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
         PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='4b'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT;
    SET CAT_JOIN (DROP = JOIN_ID);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;
    
    BASEIDYR=BASEID || YEAR;
    IF PBP_B4B_MAXENR_AMT = . AND PBP_B4B_MAXENR_TYPE = '1' THEN DO;
      %IF "&NOBS." > "0" %THEN %DO;
        AMTTOTE=INPUT(PUT(BASEIDYR,$CATFMT.),8.);
      %END;
      %ELSE %DO;
        AMTTOTE=0;
      %END;
      PBPCAT_TOT=SUM(AMTTOTE,AMTTOT);
      IF PBPCAT_TOT>0 THEN 
        MAXENR_AMT = PBP_B4A_MAXENR_AMT*(AMTTOT/PBPCAT_TOT);
    END;
    ELSE DO;
      MAXENR_AMT = PBP_B4B_MAXENR_AMT;
    END;

    IF MAXENR_AMT NE . THEN BENE_MAXIMUM = MAXENR_AMT;

    IF VISITS > 0 & PBP_B4B_COPAY_AMT_MC_MIN > 0 THEN
      COST = SUM(COST,VISITS*PBP_B4B_COPAY_AMT_MC_MIN);
      
    IF PUT(HPLAN,$TYPEF.) NOT IN("FFS","MGAP") THEN DO;
      IF VISITS > 0 & AMTTOT > 0 & PBP_B4B_COINS_PCT_MC_MIN > 0 THEN 
        COST = SUM(COST, MIN(AMTTOT*PBP_B4B_COINS_PCT_MC_MIN,VISITS*PBP_B4B_MAX_VISIT));
    END;
    ELSE IF PUT(HPLAN,$TYPEF.) IN("FFS","MGAP") THEN DO;
      IF AMTTOT > 0 & PBP_B4B_COINS_PCT_MC_MIN > 0 THEN 
        COST = SUM(COST,AMTTOT*PBP_B4B_COINS_PCT_MC_MIN);
    END;
   
    IF BENE_MAXIMUM >= 0 AND COST >= 0 THEN 
      COST = MIN(COST, BENE_MAXIMUM);

    IF PUT(HPLAN,$TYPEF.) = "MSA" THEN COST = SUM(COST, PLAN_DED_AMTTOT_MC);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;

    CATEGORY = "4b";
  RUN;

  PROC APPEND DATA=URGENT(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE URGENT URGENT_BASEID URGENT_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;

