
* PROGRAM: COST_SHARING_OUTPAT.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR OUTPAT CLAIMS;

%MACRO OUTPAT_COST_SHARE_CAT(CATNUM,CATNAME,CATPOS);

  DATA OUTPAT_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY="9a&CATNUM."));
  RUN;

  DATA OUTPAT_FILE;
    SET  PBP_FILE (KEEP =
                   CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                   PBP_B9A_MAXENR_&CATNAME._AMT 
                   PBP_B9A_MAXENR_&CATNAME._PER
                   PBP_B9A_COPAY_&CATNAME._AMT_MIN 
                   PBP_B9A_COINS_&CATNAME._PCT_MIN 
                   PBP_B9A_DED_&CATNAME._AMT
                   PBP_B9B_MAXENR_AMT
                   PBP_B9B_MAXENR_PER
                   PBP_B9B_MAXENR_TYPE
                   PBP_A_PLAN_TYPE
                   PBP_D_DIFF_DEDUCT_9A&CATNUM._AMT
                   PBP_B9A_COINS_EHC
                   PBP_B9A_COPAY_EHC
                   PBP_B9A_DED_EHC
                   PBP_B9A_MAXENR_EHC);
    JOIN_ID = '1';
    %ANNUALIZATION(PBP_B9A_MAXENR_&CATNAME._PER,PBP_B9A_MAXENR_&CATNAME._AMT);
    %ANNUALIZATION(PBP_B9B_MAXENR_PER,PBP_B9B_MAXENR_AMT);
  RUN;
 
  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.VISITS, B.AMTTOT, B.YEAR, P.*
      FROM OUTPAT_BASEID B, OUTPAT_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;
     
  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A) 
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY="9a&CATNUM."));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA OUTPAT_&CATNAME.;
    SET CAT_JOIN (DROP = JOIN_ID);
    COST_SHARE_COST = 0;
    OTHER_COST = 0;
    COST = 0;

    IF PLAN_DED_CAT='1' THEN DO;
      IF PLAN_DED_AMTTOT_MC_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC_PTB;
      ELSE CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_MC;
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN 
      CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_9A&CATNUM._AMT;
    ELSE IF SUBSTR(PBP_B9A_DED_EHC,&CATPOS.,1)='1' THEN CAT_DEDUCTIBLE=PBP_B9A_DED_&CATNAME._AMT;
    
    IF PBP_B9A_MAXENR_&CATNAME._AMT NE . & SUBSTR(PBP_B9A_MAXENR_EHC,&CATPOS.,1)='1' THEN 
      BENE_MAXIMUM = PBP_B9A_MAXENR_&CATNAME._AMT;
    
    BASEIDYR=BASEID || YEAR;
    IF PBP_B9B_MAXENR_AMT = . & PBP_B9B_MAXENR_TYPE = '1' THEN DO;
      %IF "&NOBS." > "0" %THEN %DO;
        AMTTOTU=INPUT(PUT(BASEIDYR,$CATFMT.),8.);
      %END;
      %ELSE %DO;
        AMTTOTU=0;
      %END;
      PBPCAT_TOT=SUM(AMTTOTU,AMTTOT);
      IF PBPCAT_TOT>0 THEN 
        BENE_MAXIMUM = PBP_B9A_MAXENR_&CATNAME._AMT*(AMTTOT/PBPCAT_TOT);
    END;

    IF CAT_DEDUCTIBLE = . THEN DO;
      IF SUBSTR(PBP_B9A_COPAY_EHC,&CATPOS.,1)='1' THEN
        COST = SUM(COST,(VISITS*PBP_B9A_COPAY_&CATNAME._AMT_MIN));
      IF SUBSTR(PBP_B9A_COINS_EHC,&CATPOS.,1)='1' THEN
        COST = SUM(COST,(AMTTOT*PBP_B9A_COINS_&CATNAME._PCT_MIN));
    END;
    ELSE DO;
      IF AMTTOT <= CAT_DEDUCTIBLE THEN DO;
        COST = AMTTOT;
      END;
      ELSE DO;
        COST = CAT_DEDUCTIBLE;
        DEDUCT_SHARE = CAT_DEDUCTIBLE / AMTTOT;
        AMTTOT = SUM(AMTTOT,-CAT_DEDUCTIBLE);
        VISITS = VISITS * (1 - DEDUCT_SHARE);
        IF SUBSTR(PBP_B9A_COPAY_EHC,&CATPOS.,1)='1' THEN
          COST = SUM(COST,(VISITS*PBP_B9A_COPAY_&CATNAME._AMT_MIN));
        IF SUBSTR(PBP_B9A_COINS_EHC,&CATPOS.,1)='1' THEN
          COST = SUM(COST,(AMTTOT*PBP_B9A_COINS_&CATNAME._PCT_MIN));
      END;
    END;

    IF BENE_MAXIMUM >= 0 & COST >= 0 THEN COST = MIN(COST,BENE_MAXIMUM);

    COST_SHARE_COST = COST;

    COST_SHARE_COST_MC  = COST;
    COST_SHARE_COST_AMO = 0;
    
    CATEGORY = "9a&CATNUM.";    

  RUN;
  
  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE OUTPAT_BASEID OUTPAT_FILE CAT_JOIN;
    QUIT;
  RUN;  
  
%MEND;  

%MACRO OUTPAT_COST_SHARE(SERV_CAT);

  PROC SUMMARY DATA=&INC NWAY MISSING;
    WHERE CATEGORY IN('9b');
    CLASS BASEID YEAR;
    VAR AMTTOT;
    OUTPUT OUT=CAT_SUMMARY (DROP=_TYPE_ _FREQ_) SUM=;
  RUN;
   
  %obsnvars(CAT_SUMMARY); 
   
  DATA FMTDATA;
    SET CAT_SUMMARY END=LAST;
    LENGTH HLO $1 START $12;
    FMTNAME='$CATFMT';
    START=BASEID || YEAR;
    LABEL=AMTTOT;
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL=0;
      HLO='O';
      OUTPUT;
    END;
    KEEP FMTNAME START LABEL HLO;
  RUN;
      
  PROC FORMAT CNTLIN=FMTDATA;
  RUN;
  
  %OUTPAT_COST_SHARE_CAT(1,OHS,2);
  %OUTPAT_COST_SHARE_CAT(2,OBS,1);  
  
  DATA OUTP;
    SET OUTPAT_OHS OUTPAT_OBS;
  RUN;  
  
  PROC SUMMARY DATA = OUTP NWAY MISSING;
    CLASS HPLAN YEAR BASEID CATEGORY;
    VAR COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
       OTHER_COST COST AMTTOT;
    OUTPUT OUT = OUTPAT (DROP = _TYPE_ _FREQ_) SUM = ;
  RUN;

  PROC APPEND DATA=OUTPAT(KEEP=HPLAN YEAR BASEID COST_SHARE_COST 
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT) BASE=COSTDATA FORCE;
  RUN;
  
  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE OUTPAT OUTP OUTPAT_OHS OUTPAT_OBS;
    QUIT;
  RUN;

%MEND;

