* PROGRAM NAME: PBP_IMPORT.SAS;
* DESCRIPTION: IMPORT THE INDIVIDUAL PBP TABLES AND MERGE TOGETHER;

LIBNAME LIBRARY "&INPUTDIR";

%MACRO FMTALL;
  %IF &NUM > 0 %THEN %DO;
    DATA HPLAN_ALL_FMT (KEEP=START LABEL HLO FMTNAME);
    SET MASTER_PLANFILE (RENAME=HPLAN=START) END=LAST;
    LENGTH FMTNAME $9 LABEL $3 HLO $1;
    FMTNAME='$HPLANALL';
    LABEL='YES';
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL='NO';
      HLO='O';
      OUTPUT;
    END;
    RUN;
  %END;
  %ELSE %DO;
    DATA HPLAN_ALL_FMT (KEEP=START LABEL HLO FMTNAME);
    LENGTH FMTNAME $9 LABEL $3 HLO $1;
    FMTNAME='$HPLANALL';
    START='OTHER';
    LABEL='YES';
    HLO='O';
    OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;

%FMTALL;
RUN;

PROC FORMAT CNTLIN=HPLAN_ALL_FMT LIB=LIBRARY;
RUN;

%MACRO FMTPLAN;
  %IF &NUM > 0 %THEN %DO;
    DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      SET PLANFILE (RENAME=HPLAN=START) END=LAST;
      LENGTH FMTNAME $8 LABEL $3 HLO $1;
      FMTNAME='$HPLANF';
      LABEL='YES';
      HLO=' ';
      OUTPUT;
      IF LAST THEN DO;
        START='OTHER';
        LABEL='NO';
        HLO='O';
        OUTPUT;
      END;
    RUN;
  %END;
  %ELSE %DO;
    DATA HPLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      LENGTH FMTNAME $8 LABEL $3 HLO $1;
      FMTNAME='$HPLANF';
      START='OTHER';
      LABEL='YES';
      HLO='O';
      OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;

%FMTPLAN;
RUN;

PROC FORMAT CNTLIN=HPLAN_FMT LIB=LIBRARY;
RUN;

DATA PBPPLANS (KEEP=QID PBP_A_PLAN_TYPE PBP_A_ORG_TYPE PBP_A_PLAN_NAME PBP_A_CONTRACT_NUMBER
  PBP_A_PLAN_IDENTIFIER PBP_A_SEGMENT_ID)
    PBPPLANS_ALL (KEEP=QID PBP_A_PLAN_TYPE PBP_A_ORG_TYPE PBP_A_PLAN_NAME PBP_A_CONTRACT_NUMBER
  PBP_A_PLAN_IDENTIFIER PBP_A_SEGMENT_ID)
    PBP_FILE_PARTD(KEEP=QID PBP_A_CONTRACT_NUMBER PBP_A_PLAN_IDENTIFIER RENAME=(
      QID=HPLAN PBP_A_CONTRACT_NUMBER=CONTRACT_ID PBP_A_PLAN_IDENTIFIER=PLAN_ID));
  SET PBP_JSON;
  IF PUT(QID,$HPLANF.) = 'YES' THEN OUTPUT PBPPLANS;
  IF PUT(QID,$HPLANALL.) = 'YES' THEN OUTPUT PBPPLANS_ALL;
  OUTPUT PBP_FILE_PARTD;
RUN;

PROC SORT DATA=PBPPLANS;
  BY QID;
RUN;

PROC SORT DATA=PBPPLANS_ALL;
  BY QID;
RUN;

DATA PBP_DRUG
     PBP_DRUG_ALL;
  SET PBPMRX_JSON; 
  IF PUT(QID,$HPLANF.) = 'YES' THEN OUTPUT PBP_DRUG;
  IF PUT(QID,$HPLANALL.) = 'YES' THEN OUTPUT PBP_DRUG_ALL;
RUN;

PROC SORT DATA=PBP_DRUG;
  BY QID;
RUN;

PROC SORT DATA=PBP_DRUG_ALL;
  BY QID;
RUN;

DATA PBPPLANS_ALL;
  LENGTH TYPE $4;
  MERGE PBPPLANS_ALL (IN=IN1) 
        PBP_DRUG_ALL (IN=IN2);
  BY QID;
  IF IN1;
  IF NOT IN2 THEN PBP_MRX_DRUG_YN = '2';
  IF PBP_A_PLAN_TYPE IN('29','30','32') THEN TYPE = 'PDP';
  ELSE TYPE = 'MAPD';
  IF TYPE = 'MAPD' & MRX_DRUG_BEN_YN = '2' THEN TYPE = 'MAON';
  IF PBP_A_ORG_TYPE='02' AND PBP_A_PLAN_TYPE='07' THEN TYPE = 'MSA';
RUN;

DATA PBPPLANS MAPD MAON PDP MSA FFS MGAP;
  LENGTH TYPE $4;
  MERGE PBPPLANS (IN=IN1) 
        PBP_DRUG (IN=IN2);
  BY QID;
  IF IN1;
  IF NOT IN2 THEN PBP_MRX_DRUG_YN = '2';
  IF PBP_A_PLAN_TYPE IN('29','30','32') THEN TYPE = 'PDP';
  ELSE TYPE = 'MAPD';
  IF TYPE = 'MAPD' & MRX_DRUG_BEN_YN = '2' THEN TYPE = 'MAON';
  IF PBP_A_ORG_TYPE='02' AND PBP_A_PLAN_TYPE='07' THEN TYPE = 'MSA';
  IF TYPE = 'PDP' THEN OUTPUT PDP;
  ELSE IF TYPE = 'MAPD' THEN OUTPUT MAPD;
  ELSE IF TYPE = 'MAON' THEN OUTPUT MAON;
  ELSE IF TYPE = 'MSA' THEN OUTPUT MSA;
  ELSE IF TYPE = 'FFS' THEN OUTPUT FFS;
  ELSE IF TYPE = 'MGAP' THEN OUTPUT MGAP;
  OUTPUT PBPPLANS;
RUN;

%GLOBAL MAON PDP MAPD MSA;
RUN;

DATA _NULL_;
  CALL SYMPUT('MAON',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MAON NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('PDP',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET PDP NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('MAPD',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MAPD NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('MSA',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MSA NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('FFS',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET FFS NOBS=NUMOBS;
  STOP;
RUN;

DATA _NULL_;
  CALL SYMPUT('MGAP',TRIM(LEFT(PUT(NUMOBS,4.))));
  PUT NUMOBS=;
  STOP;
  SET MGAP NOBS=NUMOBS;
  STOP;
RUN;

%PUT _USER_;

DATA _NULL_;
  CALL SYMPUT('NUM',TRIM(LEFT(PUT(NUMOBS,4.))));
  STOP;
  SET PBPPLANS NOBS=NUMOBS;
  STOP;
RUN;

%MACRO FMTTYPE;
  %IF &NUM > 0 %THEN %DO;
    DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      SET PBPPLANS (RENAME=QID=START) END=LAST;
      LENGTH FMTNAME $8 LABEL $4 HLO $1;
      FMTNAME='$TYPEF';
      LABEL=TYPE;
      HLO=' ';
      OUTPUT;
      IF LAST THEN DO;
        START='OTHER';
        LABEL='NO';
        HLO='O';
        OUTPUT;
      END;
    RUN;
  %END;
  %ELSE %DO;
    DATA PLAN_FMT (KEEP=START LABEL HLO FMTNAME);
      LENGTH FMTNAME $8 LABEL $4 HLO $1;
      FMTNAME='$TYPEF';
      START='OTHER';
      LABEL='NO';
      HLO='O';
      OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;

%FMTTYPE;
RUN;

PROC FORMAT CNTLIN=PLAN_FMT LIB=LIBRARY;
RUN;

%MACRO FMTTYPEALL;
  %IF &NUM > 0 %THEN %DO;
    DATA PLAN_FMT_ALL (KEEP=START LABEL HLO FMTNAME);
    SET PBPPLANS_ALL (RENAME=QID=START) END=LAST;
    LENGTH FMTNAME $8 LABEL $4 HLO $1;
    FMTNAME='$TYPEALL';
    LABEL=TYPE;
    HLO=' ';
    OUTPUT;
    IF LAST THEN DO;
      START='OTHER';
      LABEL='NO';
      HLO='O';
      OUTPUT;
    END;
    RUN;
  %END;
  %ELSE %DO;
    DATA PLAN_FMT_ALL (KEEP=START LABEL HLO FMTNAME);
    LENGTH FMTNAME $8 LABEL $4 HLO $1;
    FMTNAME='$TYPEALL';
    START='OTHER';
    LABEL='NO';
    HLO='O';
    OUTPUT;
    RUN;
  %END;
  RUN;
%MEND;

%FMTTYPEALL;
RUN;

PROC FORMAT CNTLIN=PLAN_FMT_ALL LIB=LIBRARY;
RUN;

DATA CONTPLAN;
  LENGTH START $8;
  RETAIN FMTNAME '$CONTPLNF';
  SET PLAN_FMT(RENAME=START=HPLAN DROP=FMTNAME);
  START = SUBSTR(HPLAN,1,8);
RUN;

PROC SORT DATA = CONTPLAN NODUPKEY;
  BY START;
RUN;

PROC FORMAT CNTLIN=CONTPLAN LIB=LIBRARY;
RUN;

DATA PBP_FILE_PARTD;
  SET PBP_FILE_PARTD;
  IF PUT(HPLAN,$TYPEF.) NE 'NO';
RUN;

PROC SORT DATA=PBP_FILE_PARTD;
  BY HPLAN;
RUN;

%INCLUDE IN0(CONVERT.SAS);
RUN;

%PBPIMPCONV(PBPMRX_JSON)
RUN;

DATA PBPMRX;
  SET PBPMRX_JSON(KEEP=
  QID
  MRX_DRUG_BEN_YN
  MRX_BENEFIT_TYPE
  MRX_ALT_DED_CHARGE
  MRX_ALT_DED_AMOUNT
  MRX_AE_CSTSHR_APPLY
  MRX_ALT_PRE_ICL_COST_SHARE
  MRX_ALT_DED_TYPE_YN
  MRX_ALT_NO_DED_TIER
  MRX_ALT_DED_TIER_CSTSHR_YN
  MRX_ALT_GEN_COINS_PCT
  MRX_ALT_GEN_COPAY_AMT
  MRX_ALT_GEN_CSTSHR_STRUCT
  MRX_FIRST_FILL
  MRX_TIER_FORM_EX
  MRX_TIER_FORM_EX_2_YN
  MRX_TIER_FORM_EX_2
  MRX_GEN_IRA_RSTD_COPAY_1M
  );
RUN;

DATA PBP_MRX;
  MERGE PBP_FILE_PARTD (IN=IN1 KEEP=HPLAN)
        PBPMRX (IN=IN2 RENAME=QID=HPLAN);
  BY HPLAN;
  IF IN1 AND IN2;
RUN;

%PBPIMPCONV(PBPMRXT_JSON)
RUN;

DATA PBPMRX_T;
  SET PBPMRXT_JSON(KEEP=QID
  MRX_TIER_ID
  MRX_TIER_TYPE_ID
  MRX_TIER_CSTSHR_STRUCT_TYPE
  MRX_TIER_RSPFD_COPAY_1M
  MRX_TIER_RSTD_COPAY_1M
  MRX_TIER_RSSTD_COPAY_1M
  MRX_TIER_OONP_COPAY_1M
  MRX_TIER_RSPFD_COINS_1M
  MRX_TIER_RSTD_COINS_1M
  MRX_TIER_RSSTD_COINS_1M
  MRX_TIER_OONP_COINS_1M
  MRX_TIER_INCLUDES
  MRX_TIER_IRA_RSTD_COPAY_1M
  MRX_TIER_IRA_RSPFD_COPAY_1M);
RUN;

DATA PBP_MRX_TIER;
  MERGE PBP_FILE_PARTD (IN=IN1 KEEP=HPLAN)
        PBPMRX_T (IN=IN2 RENAME=QID=HPLAN);
  BY HPLAN;
  IF IN1 AND IN2;
RUN;

PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
  DELETE PBPPLANS;
  QUIT;
RUN;
