
* PROGRAM: COST_SHARING_PREVENTIVE_DENTAL.SAS;
* DESCRIPTION: PERFORM COST SHARING ALGORITHM FOR PREVENTIVE DENTAL CLAIMS;


%MACRO DENTAL_PREV_COST_SHARE(SERV_CAT);

  DATA DENTAL_BASEID;
    RETAIN JOIN_ID '1';
    SET &INC(WHERE=(CATEGORY='16'));
    CATEGORY='16b';
  RUN;

  DATA DENTAL_FILE;
    SET PBP_FILE (KEEP =
                  CONTRACT_ID PLAN_ID SEGMENT_ID HPLAN
                  PBP_B16B_MAXENR_PV_AMT 
                  PBP_B16B_MAXENR_PV_PER
                  PBP_B16B_BENDESC_PC_AMO 
                  PBP_B16B_BENDESC_DX_AMO 
                  PBP_B16B_BENDESC_OE_AMO
                  PBP_B16B_DED_PV_AMT
                  PBP_B16C_MAXPLAN_CMP_TYPE
                  
                  PBP_B16B_COPAY_PC_AMT
                  PBP_B16B_COPAY_PC_AMT_MIN
                  
                  PBP_B16B_COINS_PC_PCT
                  PBP_B16B_COINS_PC_PCT_MIN
                  
                  PBP_B16B_COPAY_DX_AMT
                  PBP_B16B_COPAY_DX_AMT_MIN
                  
                  PBP_B16B_COINS_DX_PCT
                  PBP_B16B_COINS_DX_PCT_MIN
                  
                  PBP_B16B_COPAY_OE_AMT
                  PBP_B16B_COPAY_OE_AMT_MIN
                  
                  PBP_B16B_COINS_OE_PCT
                  PBP_B16B_COINS_OE_PCT_MIN
                  
                  PBP_B16B_COPAY_OV_AMT
                  PBP_B16B_COPAY_OV_AMT_MIN
                  
                  PBP_B16B_COINS_OV_PCT
                  PBP_B16B_COINS_OV_PCT_MIN
                  
                  PBP_B16B_COPAY_OV_SVCS
                  PBP_B16B_COINS_OV_SVCS
                  PBP_B16B_MAXPLAN_PV_AMT
                  PBP_B16B_MAXPLAN_PV_PER

                  PBP_B16B_BENDESC_OE_NUM
                  PBP_B16B_BENDESC_PC_NUM
                  PBP_B16B_BENDESC_DX_NUM

                  PBP_B16B_BENDESC_OE_PER
                  PBP_B16B_BENDESC_PC_PER
                  PBP_B16B_BENDESC_DX_PER
 
                  PBP_A_PLAN_TYPE
                  PBP_D_NMC_DEDUCT_YN

                  PBP_D_DIFF_DEDUCT_16B1_N_AMT
                  PBP_D_DIFF_DEDUCT_16B2_N_AMT
                  PBP_D_DIFF_DEDUCT_16B4_N_AMT
                  
                  PBP_D_MAND_DEDUCT_16B1_N_AMT
                  PBP_D_MAND_DEDUCT_16B2_N_AMT
                  PBP_D_MAND_DEDUCT_16B4_N_AMT
                  );
    JOIN_ID = '1';

    ARRAY MX PBP_B16B_BENDESC_OE_NUM PBP_B16B_BENDESC_PC_NUM PBP_B16B_BENDESC_DX_NUM
             PBP_B16B_MAXENR_PV_AMT PBP_B16B_MAXPLAN_PV_AMT;
    ARRAY PX PBP_B16B_BENDESC_OE_PER PBP_B16B_BENDESC_PC_PER PBP_B16B_BENDESC_DX_PER
             PBP_B16B_MAXENR_PV_PER PBP_B16B_MAXPLAN_PV_PER;

    DO I = 1 TO 5;
      IF MX(I) NE . THEN DO;
        IF PX(I)  = '1' THEN MX(I) = MX(I)  / 3; * EVERY THREE YEARS;
        ELSE IF PX(I)  = '2' THEN MX(I) = MX(I)  / 2; * EVERY TWO YEARS;
        ELSE IF PX(I)  = '3' THEN MX(I) = MX(I) / 1; * EVERY YEAR;
        ELSE IF PX(I)  = '4' THEN MX(I) = MX(I)  * 2; * EVERY SIX MONTHS;
        ELSE IF PX(I)  = '5' THEN MX(I) = MX(I)  * 4; * EVERY THREE MONTHS;
        ELSE IF PX(I)  = '6' THEN MX(I) = MX(I) ; * OTHER;
        ELSE IF PX(I)  = '7' THEN MX(I) = MX(I)  * 12; * EVERY MONTH;
        
      END;
    END;
  RUN;

  PROC SQL;
    CREATE TABLE CAT_JOIN AS
      (SELECT B.CATEGORY, B.BASEID, B.YEAR, B.AMTTOT, B.DVCLEAN, B.DVEXAM, B.DVXRAYS,
      B.PREVENT_DENTAL_SHARE, P.*
      FROM DENTAL_BASEID B, DENTAL_FILE P
      WHERE B.JOIN_ID = P.JOIN_ID)
      ORDER BY HPLAN, BASEID, YEAR, CATEGORY;
    QUIT;
  RUN;

  DATA CAT_JOIN;
    MERGE CAT_JOIN (IN = A)
          PBPCATS_MCCOST_DED (IN = B WHERE=(CATEGORY='16b'));
    BY HPLAN BASEID YEAR CATEGORY;
    IF A;
    LENGTH PLAN_DED_CAT $1;
    IF B THEN PLAN_DED_CAT='1';
    ELSE PLAN_DED_CAT='0';
  RUN;

  DATA &SERV_CAT;
    ARRAY MX PBP_B16B_BENDESC_OE_NUM PBP_B16B_BENDESC_PC_NUM PBP_B16B_BENDESC_DX_NUM
          PBP_B16B_MAXENR_PV_AMT PBP_B16B_MAXPLAN_PV_AMT;
    ARRAY SX SERVICE_MAX_OE SERVICE_MAX_PC SERVICE_MAX_DX
          BENE_MAXIMUM_P PLAN_MAXIMUM_P;
    SET CAT_JOIN (DROP = JOIN_ID);

    PREV_SERVICE_CNT = SUM(DVCLEAN,DVEXAM,DVXRAYS);

    IF PREV_SERVICE_CNT>0;

    DO I = 1 TO 5;
      IF MX(I) NE . THEN DO;
        SX(I) = MX(I);
      END;
    END;
    
    IF DVEXAM > 0 THEN DO;
      DIFF_DEDUCT_DVEXAM = PBP_D_DIFF_DEDUCT_16B1_N_AMT;
      MAND_DEDUCT_DVEXAM = PBP_D_MAND_DEDUCT_16B1_N_AMT;
    END;
    ELSE DO;
      DIFF_DEDUCT_DVEXAM = 0;
      MAND_DEDUCT_DVEXAM = 0;
    END;      
    IF DVXRAYS > 0 THEN DO;
      DIFF_DEDUCT_DVXRAYS = PBP_D_DIFF_DEDUCT_16B2_N_AMT;
      MAND_DEDUCT_DVXRAYS = PBP_D_MAND_DEDUCT_16B2_N_AMT;      
    END;
    ELSE DO;
      DIFF_DEDUCT_DVXRAYS = 0;
      MAND_DEDUCT_DVXRAYS = 0;
    END;
    IF DVCLEAN > 0 THEN DO;
      DIFF_DEDUCT_DVCLEAN = PBP_D_DIFF_DEDUCT_16B4_N_AMT;
      MAND_DEDUCT_DVCLEAN = PBP_D_MAND_DEDUCT_16B4_N_AMT;
    END;
    ELSE DO;
      DIFF_DEDUCT_DVCLEAN = 0;
      MAND_DEDUCT_DVCLEAN = 0;
    END;    
    
    PBP_D_DIFF_DEDUCT_16B_AMT = SUM(DIFF_DEDUCT_DVEXAM,DIFF_DEDUCT_DVXRAYS,DIFF_DEDUCT_DVCLEAN);
    PBP_D_DEDUCT_PREVDENTAL_AMT = SUM(MAND_DEDUCT_DVEXAM,MAND_DEDUCT_DVXRAYS,MAND_DEDUCT_DVCLEAN);

    IF PLAN_DED_CAT='1' THEN DO;
      PLAN_DED_AMTTOT_AMO_PTB=SUM(PLAN_DEDUCT_PTB,-PLAN_DED_AMTTOT_MC_PTB);
      IF PLAN_DED_AMTTOT_AMO_PTB>0 THEN CAT_DEDUCTIBLE=PLAN_DED_AMTTOT_AMO_PTB;
      ELSE CAT_DEDUCTIBLE=SUM(PLAN_DED_AMTTOT,-PLAN_DED_AMTTOT_MC);
    END;
    ELSE IF PBP_A_PLAN_TYPE IN('04','31','44','47') THEN
      CAT_DEDUCTIBLE=PBP_D_DIFF_DEDUCT_16B_AMT;
    ELSE CAT_DEDUCTIBLE=PBP_B16B_DED_PV_AMT;

    CAT_DEDUCTIBLE_SUP=0; 
    IF PBP_D_DEDUCT_PREVDENTAL_AMT>0 THEN CAT_DEDUCTIBLE_SUP=PBP_D_DEDUCT_PREVDENTAL_AMT;
    
    PREV_AM = '000';
    IF PBP_B16B_BENDESC_PC_AMO IN ('2','4') THEN SUBSTR(PREV_AM,1,1) = '1';
    IF PBP_B16B_BENDESC_DX_AMO IN ('2','4') THEN SUBSTR(PREV_AM,2,1) = '1';
    IF PBP_B16B_BENDESC_OE_AMO IN ('2','4') THEN SUBSTR(PREV_AM,3,1) = '1';

    OV_SVCS_COINS = '000';
    IF SUBSTR(PBP_B16B_COINS_OV_SVCS,4,1) = '1' THEN SUBSTR(OV_SVCS_COINS,1,1) = '1';
    IF SUBSTR(PBP_B16B_COINS_OV_SVCS,2,1) = '1' THEN SUBSTR(OV_SVCS_COINS,2,1) = '1';
    IF SUBSTR(PBP_B16B_COINS_OV_SVCS,1,1) = '1' THEN SUBSTR(OV_SVCS_COINS,3,1) = '1';

    OV_SVCS_COPAY = '000';
    IF SUBSTR(PBP_B16B_COPAY_OV_SVCS,4,1) = '1' THEN SUBSTR(OV_SVCS_COPAY,1,1) = '1';
    IF SUBSTR(PBP_B16B_COPAY_OV_SVCS,2,1) = '1' THEN SUBSTR(OV_SVCS_COPAY,2,1) = '1';
    IF SUBSTR(PBP_B16B_COPAY_OV_SVCS,1,1) = '1' THEN SUBSTR(OV_SVCS_COPAY,3,1) = '1';

    PREV_SERVICE_CNT = SUM(DVCLEAN,DVEXAM,DVXRAYS);
  
    AMTTOT_PREV = PREVENT_DENTAL_SHARE * AMTTOT;
    AMTTOT_COMP = (1-PREVENT_DENTAL_SHARE) * AMTTOT; 
 
    PER_SERVICE_AMT = AMTTOT_PREV / PREV_SERVICE_CNT;

    IF SUM(AMTTOT_PREV,AMTTOT_COMP) > 0 THEN
      PREVENTIVE_SHARE=PREVENT_DENTAL_SHARE;
    ELSE PREVENTIVE_SHARE=0;

    IF PBP_B16C_MAXPLAN_CMP_TYPE = '1' THEN PLAN_MAXIMUM_P=PLAN_MAXIMUM_P*PREVENTIVE_SHARE;

    NONCOV_COST = 0;

    ARRAY DP DVCLEAN DVEXAM DVXRAYS;

    IF AMTTOT_PREV <= SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP) THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,AMTTOT_PREV);
      DO OVER DP;
        DP = 0;
      END;
    END;
    ELSE IF SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP) > 0 THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP));
      DED_SHARE = SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP) / AMTTOT_PREV;
      AMTTOT_PREV = SUM(AMTTOT_PREV,-(SUM(CAT_DEDUCTIBLE,CAT_DEDUCTIBLE_SUP)));
      DO OVER DP;
        DP = DP * (1 - DED_SHARE);
      END;
    END;

    * APPLY SERVICE COUNT MAX FIRST;
    IF SERVICE_MAX_OE > 0 AND SERVICE_MAX_OE < DVEXAM THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(DVEXAM,-SERVICE_MAX_OE) * PER_SERVICE_AMT);
      DVEXAM = SERVICE_MAX_OE;
    END;
    IF SERVICE_MAX_PC > 0 AND SERVICE_MAX_PC < DVCLEAN THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(DVCLEAN,-SERVICE_MAX_PC) * PER_SERVICE_AMT);
      DVCLEAN = SERVICE_MAX_PC;
    END;
    IF SERVICE_MAX_DX > 0 AND SERVICE_MAX_DX < DVXRAYS THEN DO;
      NONCOV_COST = SUM(NONCOV_COST,SUM(DVXRAYS,-SERVICE_MAX_DX) * PER_SERVICE_AMT);
      DVXRAYS = SERVICE_MAX_DX;
    END;

    PREV_SERVICE_CNT = SUM(DVCLEAN,DVEXAM,DVXRAYS);

    AMTTOT_PREV = PREV_SERVICE_CNT * PER_SERVICE_AMT;

    NONCOV_COST_MAXDOL = 0;
    NONCOV_COST_MAXDOL_P = 0;

    * APPLY PLAN MAXIMUM;
    IF PLAN_MAXIMUM_P > 0 THEN NONCOV_COST_MAXDOL_P = MAX(0,SUM(AMTTOT_PREV,-PLAN_MAXIMUM_P));

    NONCOV_COST_MAXDOL = NONCOV_COST_MAXDOL_P;

    IF AMTTOT_PREV > 0 THEN
      COVERED_SHARE_P = SUM(AMTTOT_PREV,-NONCOV_COST_MAXDOL_P) / AMTTOT_PREV;

    DO OVER DP;
      DP = DP * COVERED_SHARE_P;
    END;

    *APPLY INDIVIDUAL COSTS FOR PREV BENEFITS;

    IF DVCLEAN > 0 THEN DO;
    
      IF PBP_B16B_COPAY_PC_AMT > 0 THEN COPAY_PC_AMT = PBP_B16B_COPAY_PC_AMT;
      ELSE IF PBP_B16B_COPAY_PC_AMT_MIN > 0 THEN COPAY_PC_AMT = PBP_B16B_COPAY_PC_AMT_MIN;
      ELSE COPAY_PC_AMT = 0;
      
      IF PBP_B16B_COINS_PC_PCT > 0 THEN COINS_PC_PCT = PBP_B16B_COINS_PC_PCT;
      ELSE IF PBP_B16B_COINS_PC_PCT_MIN > 0 THEN COINS_PC_PCT = PBP_B16B_COINS_PC_PCT_MIN;
      ELSE COINS_PC_PCT = 0;
      
      IF SUBSTR(PREV_AM,1,1) = '1' THEN DO;
        IF SUBSTR(OV_SVCS_COPAY,1,1) = '0' & SUBSTR(PBP_B16B_COPAY_OV_SVCS,4,1)='1' THEN
          PC_COST_SHARE = COPAY_PC_AMT * DVCLEAN;
        IF SUBSTR(OV_SVCS_COINS,1,1) = '0' & SUBSTR(PBP_B16B_COINS_OV_SVCS,4,1)='1' THEN
          PC_COST_SHARE = SUM(PC_COST_SHARE,(PER_SERVICE_AMT * DVCLEAN * COINS_PC_PCT));
      END;
      ELSE DO;
        PC_OTHER_COST = PER_SERVICE_AMT * DVCLEAN;
      END;
    END;

    IF DVXRAYS > 0 THEN DO;
    
      IF PBP_B16B_COPAY_DX_AMT > 0 THEN COPAY_DX_AMT = PBP_B16B_COPAY_DX_AMT;
      ELSE IF PBP_B16B_COPAY_DX_AMT_MIN > 0 THEN COPAY_DX_AMT = PBP_B16B_COPAY_DX_AMT_MIN;
      ELSE COPAY_DX_AMT = 0;
      
      IF PBP_B16B_COINS_DX_PCT > 0 THEN COINS_DX_PCT = PBP_B16B_COINS_DX_PCT;
      ELSE IF PBP_B16B_COINS_DX_PCT_MIN > 0 THEN COINS_DX_PCT = PBP_B16B_COINS_DX_PCT_MIN;
      ELSE COINS_DX_PCT = 0;
      
      IF SUBSTR(PREV_AM,2,1) = '1' THEN DO;
        IF SUBSTR(OV_SVCS_COPAY,2,1) = '0' & SUBSTR(PBP_B16B_COPAY_OV_SVCS,2,1)='1' THEN
          DX_COST_SHARE = COPAY_DX_AMT * DVXRAYS;
        IF SUBSTR(OV_SVCS_COINS,2,1) = '0' & SUBSTR(PBP_B16B_COINS_OV_SVCS,2,1)='1' THEN
          DX_COST_SHARE = SUM(DX_COST_SHARE,(PER_SERVICE_AMT * DVXRAYS * COINS_DX_PCT));
      END;
      ELSE DO;
        DX_OTHER_COST = PER_SERVICE_AMT * DVXRAYS;
      END;
    END;

    IF DVEXAM > 0 THEN DO;
        
      IF PBP_B16B_COPAY_OE_AMT > 0 THEN COPAY_OE_AMT = PBP_B16B_COPAY_OE_AMT;
      ELSE IF PBP_B16B_COPAY_OE_AMT_MIN > 0 THEN COPAY_OE_AMT = PBP_B16B_COPAY_OE_AMT_MIN;
      ELSE COPAY_OE_AMT = 0;
      
      IF PBP_B16B_COINS_OE_PCT > 0 THEN COINS_OE_PCT = PBP_B16B_COINS_OE_PCT;
      ELSE IF PBP_B16B_COINS_OE_PCT_MIN > 0 THEN COINS_OE_PCT = PBP_B16B_COINS_OE_PCT_MIN;
      ELSE COINS_OE_PCT = 0;
      
      IF SUBSTR(PREV_AM,3,1) = '1' THEN DO;
        IF SUBSTR(OV_SVCS_COPAY,3,1) = '0' & SUBSTR(PBP_B16B_COPAY_OV_SVCS,1,1)='1' THEN
          OE_COST_SHARE = COPAY_OE_AMT * DVEXAM;
        IF SUBSTR(OV_SVCS_COINS,3,1) = '0' & SUBSTR(PBP_B16B_COINS_OV_SVCS,1,1)='1' THEN
          OE_COST_SHARE = SUM(OE_COST_SHARE,(PER_SERVICE_AMT * DVEXAM * COINS_OE_PCT));
      END;
      ELSE DO;
        OE_OTHER_COST = PER_SERVICE_AMT * DVEXAM;
      END;
    END;

    *APPLY OFFICE VISIT COSTS FOR PREV BENEFITS;

    IF PBP_B16B_COPAY_OV_AMT > 0 THEN COPAY_OV_AMT = PBP_B16B_COPAY_OV_AMT;
    ELSE IF PBP_B16B_COPAY_OV_AMT_MIN > 0 THEN COPAY_OV_AMT = PBP_B16B_COPAY_OV_AMT_MIN;
    ELSE COPAY_OV_AMT = 0;
      
    IF PBP_B16B_COINS_OV_PCT > 0 THEN COINS_OV_PCT = PBP_B16B_COINS_OV_PCT;
    ELSE IF PBP_B16B_COINS_OV_PCT_MIN > 0 THEN COINS_OV_PCT = PBP_B16B_COINS_OV_PCT_MIN;
    ELSE COINS_OV_PCT = 0;
    
    IF SUBSTR(PREV_AM,1,1) = '1' AND SUBSTR(OV_SVCS_COPAY,1,1) = '1' THEN CLEAN_COPAY_CNT = DVCLEAN;
    ELSE CLEAN_COPAY_CNT = 0;
    IF SUBSTR(PREV_AM,3,1) = '1' AND SUBSTR(OV_SVCS_COPAY,3,1) = '1' THEN EXAM_COPAY_CNT = DVEXAM;
    ELSE EXAM_COPAY_CNT = 0;
    IF SUBSTR(PREV_AM,2,1) = '1' AND SUBSTR(OV_SVCS_COPAY,2,1) = '1' THEN XRAY_COPAY_CNT = DVXRAYS;
    ELSE XRAY_COPAY_CNT = 0;
    
    OVCNT_COPAY = MAX(CLEAN_COPAY_CNT,EXAM_COPAY_CNT,XRAY_COPAY_CNT);
    
    OV_COST_SHARE_COPAY = OVCNT_COPAY * COPAY_OV_AMT;
    
    IF SUBSTR(PREV_AM,1,1) = '1' AND SUBSTR(OV_SVCS_COINS,1,1) = '1' THEN CLEAN_COINS_CNT = DVCLEAN;
    ELSE CLEAN_COINS_CNT = 0;
    IF SUBSTR(PREV_AM,3,1) = '1' AND SUBSTR(OV_SVCS_COINS,3,1) = '1' THEN EXAM_COINS_CNT = DVEXAM;
    ELSE EXAM_COINS_CNT = 0;
    IF SUBSTR(PREV_AM,2,1) = '1' AND SUBSTR(OV_SVCS_COINS,2,1) = '1' THEN XRAY_COINS_CNT = DVXRAYS;
    ELSE XRAY_COINS_CNT = 0;
    
    OVCNT_COINS = MAX(CLEAN_COINS_CNT,EXAM_COINS_CNT,XRAY_COINS_CNT);
    
    OV_COST_SHARE_COINS = (PER_SERVICE_AMT * OVCNT_COINS * COINS_OV_PCT);

    OV_COST_SHARE = SUM(OV_COST_SHARE_COPAY,OV_COST_SHARE_COINS);
    

    COST_SHARE_COST_P = SUM(PC_COST_SHARE,DX_COST_SHARE,OE_COST_SHARE,OV_COST_SHARE);

    COST_SHARE_COST = MIN(BENE_MAXIMUM_P,MAX(COST_SHARE_COST_P,0));

    OTHER_COST = SUM(PC_OTHER_COST, DX_OTHER_COST, OE_OTHER_COST,
      NONCOV_COST, NONCOV_COST_MAXDOL);

    COST_SHARE_COST_MC  = 0;
    COST_SHARE_COST_AMO = COST_SHARE_COST;

    CATEGORY = "16b";
  RUN;

  PROC SORT DATA = DENTAL;
    BY HPLAN;
  RUN;

  PROC SUMMARY DATA = DENTAL NWAY MISSING;
    CLASS YEAR BASEID;
    BY HPLAN;
    VAR COST_SHARE_COST COST_SHARE_COST_MC COST_SHARE_COST_AMO
      OTHER_COST AMTTOT;
    ID CATEGORY;
    OUTPUT OUT = TOTDENTAL(RENAME = _FREQ_=RCCNT) SUM = ;
  RUN;

  DATA TOTDENTAL;
    RETAIN COST 0;
    SET TOTDENTAL;
  RUN;

  PROC APPEND DATA=TOTDENTAL(KEEP=HPLAN YEAR BASEID COST_SHARE_COST
    COST_SHARE_COST_MC COST_SHARE_COST_AMO
    OTHER_COST COST CATEGORY AMTTOT)  BASE= COSTDATA FORCE;
  RUN;

  PROC DATASETS LIBRARY=WORK NODETAILS NOLIST;
    DELETE DENTAL TOTDENTAL DENTAL_BASEID DENTAL_FILE CAT_JOIN;
    QUIT;
  RUN;

%MEND;
