* PROGRAM: MISSING_CELLS_YEAR.SAS;

%MACRO MISSES();

  %DO I=&YEAR1. %TO &YEAR2.;

    DATA PBPCATS_MCCOST_&I.;
      SET PBPCATS_MCCOST;
      CATEGORY = LOWCASE(CATEGORY);
      IF YEAR = "&I.";
    RUN;

    PROC SQL;
      CREATE TABLE BASEID_MANAGEDCARE AS
      SELECT DISTINCT BASEID
      FROM PBPCATS_MCCOST_&I.
      ORDER BY BASEID;
    RUN;

    DATA MISSING_COHORT;
      MERGE &INP(IN = A WHERE=(YEAR="&I.") KEEP = BASEID CSYRWGT INDMON YEAR)
            BASEID_MANAGEDCARE(IN = B);
      BY BASEID;
      IF A AND NOT B;
      INDMON = INDMON * CSYRWGT;
      KEEP BASEID INDMON CSYRWGT;
    RUN;

    PROC SUMMARY DATA = MISSING_COHORT NWAY MISSING;
      VAR INDMON CSYRWGT;
      OUTPUT OUT = MISSING_CELLS_&I. (DROP = _TYPE_ _FREQ_) SUM=;
    RUN;
  %END;

%MEND;

%MISSES();


