
* PLAN_CATNAME_NEW.SAS;
* DESCRIPTION: PERFORM FINAL CALCULATIONS AND CREATE FINAL SPREADSHEET;

DATA FMTSUB;
  SET &CATEG;
  IF CATEGORY IN(' ','DED') THEN DELETE;
RUN;

DATA FMTDATA;
  SET FMTSUB END=LAST;
  LENGTH FMTNAME $8 HLO $1 START $6;
  RETAIN FMTNAME '$CATNAME' HLO ' ';
  START=CATEGORY;
  OUTPUT FMTDATA;
RUN;

PROC SORT DATA=FMTDATA OUT=FMTSORT NODUPKEY;
  BY START;
RUN;

PROC FORMAT CNTLIN=FMTSORT;
RUN;

PROC SORT DATA=&CATEG OUT=SORTCATEG (KEEP=LABEL CATEGORY);
  WHERE CATEGORY ^= 'DED';
  BY ORDER;
RUN;

DATA _NULL_;
  SET SORTCATEG end = last;
  FILE "&INPUTDIR.\CATORDER.TXT";
  if _n_ = 1 then put '%let catlist = %str(';
  PUT LABEL;
  if last then put ');';
RUN;

%MACRO PLAN;

  %include "&INPUTDIR.\CATORDER.TXT";
 
  DATA BASEID_CATEGORY_ALLYEARS;
    SET BASEID_PLAN_CATEGORY_COMP_&YEAR1(RENAME=CWGT=COMBO_WGT)
        BASEID_PLAN_CATEGORY_COMP_&YEAR2(RENAME=CWGT=COMBO_WGT)
    ;
    BY HPLAN CATEGORY;
    OUTPUT;
  RUN;

  DATA CCOHORT;
    SET &INP(KEEP=BASEID CSYRWGT YEAR);
    IF YEAR = "&YEAR1" THEN SOURCE = "&MCBSYR1";
    ELSE IF YEAR = "&YEAR2" THEN SOURCE = "&MCBSYR2";
    COMBO_WGT = CSYRWGT;
    OUTPUT;
  RUN;

  PROC SUMMARY DATA = CCOHORT NWAY MISSING;
    VAR COMBO_WGT;
    OUTPUT OUT = COHORT_CELL_GROUP(DROP=_FREQ_ _TYPE_) SUM = COMBOWGT_SUM;
  RUN;

  PROC MEANS DATA = BASEID_CATEGORY_ALLYEARS NOPRINT;
    CLASS HPLAN CATEGORY;
    WEIGHT COMBO_WGT;
    VAR MONTHLY_COST;
    OUTPUT OUT = PLAN SUM = MONTHLY_COST_SUM;
  RUN;

  DATA PLAN_COSTS;
    IF _N_ = 1 THEN SET COHORT_CELL_GROUP(KEEP = COMBOWGT_SUM);
    SET PLAN(IN = A);
    MONTHLY_COST_MEAN = MONTHLY_COST_SUM / COMBOWGT_SUM;
  RUN;

  PROC SORT DATA=PLAN_COSTS OUT= PLAN_COSTS;
    BY HPLAN;
  RUN;

  DATA SECTION_A(RENAME=(PBP_A_ORG_TYPE=ORG_TYPE
                         PBP_A_PLAN_TYPE=PLAN_TYPE));
    LENGTH TYPE $4;
    SET PBP_FILE;
    TYPE = PUT(HPLAN,$TYPEF.);
    IF TYPE NE 'NO';
  RUN;

  DATA PLAN_COSTS_CAT(DROP=_TYPE_ _FREQ_ COMBOWGT_SUM);
    LENGTH CATNAME $ 50;
    SET PLAN_COSTS(WHERE=(_TYPE_ ^=0 AND HPLAN ^=:' ' AND CATEGORY ^= '   '));
    CATNAME = PUT(CATEGORY,$CATNAME.);
  RUN;

  PROC TRANSPOSE DATA=PLAN_COSTS_CAT(KEEP=HPLAN CATNAME MONTHLY_COST_MEAN) OUT=PARTC_PLANS(DROP=_NAME_);
    VAR MONTHLY_COST_MEAN;
    ID CATNAME;
    BY HPLAN;
  RUN;

  DATA PARTC_PLANS_CD(RENAME=ALL=TOTAL);
    LENGTH HPLAN $11
           CONTRACT_ID $5
           Plan_ID $3
           Segment_ID $3
           YEAR $4;
    MERGE PARTC_PLANS(IN=A)
          SECTION_A(IN=C KEEP=PLAN_TYPE TYPE HPLAN);
    BY HPLAN;
    YEAR = "&RUNYEAR";
    CONTRACT_ID=SUBSTR(HPLAN,1,5);
    PLAN_ID=SUBSTR(HPLAN,6,3);
    SEGMENT_ID=SUBSTR(HPLAN,9,3);
  RUN;

  DATA OOPCS_ALL_FINAL_CD(DROP=TYPE RENAME=(CONTRACT_ID=Contract_Number
    YEAR=Benefit_Year));
    LENGTH CONTRACT_ID $5 Plan_ID $3 Segment_ID $3 YEAR $4 
    %IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 %THEN %DO;
      &catlist.
    %END;
    8;
    SET PARTC_PLANS_CD(KEEP=CONTRACT_ID Plan_ID Segment_ID YEAR 
    %IF &MAPD > 0 OR &MAON > 0 OR &MSA > 0 %THEN %DO;
      &catlist.
    %END;
     HPLAN TYPE);
  RUN;
  
  DATA OOPCS_ALL_FINAL_CD_WO_MGAPFFS (DROP=HPLAN);
    SET OOPCS_ALL_FINAL_CD;
    label 
      Emergency_Care='Emergency_Services'
      Urgently_Needed_Care='Urgently_Needed_Services'
      Chemotherapy_Drugs='Chemotherapy/Radiation_Drugs'
      Opioid='Opioid_Treatment_Programs'
      Medicare_Covered_Ptb_Insul_Drugs='Medicare_Covered_Partb_Insulin_Drugs'
    ;
  RUN;

  PROC EXPORT DATA=OOPCS_ALL_FINAL_CD_WO_MGAPFFS 
              OUTFILE= "&OOPC" 
	      DBMS=XLSX REPLACE LABEL;
    SHEET="OOPCS &RUNYEAR";
  RUN;

  %IF &INPUT=INPUTCMS %THEN %DO;
 
    DATA RUN_DOCUMENTATION;
      LENGTH NOTES $250;
      NOTES="OOPC Model Version/Date:  &MODVERSION.";
      OUTPUT;
      NOTES="Plan Model Year:  &RUNYEAR.";
      OUTPUT;
      NOTES="MCBS Survey Data Years:  &YEAR1./&YEAR2.";
      OUTPUT;
      NOTES="PBP Data Extract Date:  &EXT_DATE.";
      OUTPUT;
      NOTES="OACT Inflation Rates Year:  &OACT_INFLATION_YEAR.";
      OUTPUT;
    RUN;
  
    PROC EXPORT DATA=RUN_DOCUMENTATION 
                OUTFILE= "&OOPC" 
		DBMS=XLSX;
      SHEET="RUN_DOCUMENTATION";
    RUN;
  %END;
%MEND;

%PLAN;
RUN;
