* PROGRAM NAME: BUILD_LOOKUP_SUB.SAS;

LIBNAME FORM    "&FORMULARY";
LIBNAME INPUT   "&INPUTDIR";

OPTIONS MSGLEVEL=I;

DATA PLAN_FORM;
  SET FORM.PLAN_FORMULARY;
  LENGTH CONTPLN $8;
  CONTPLN = CONTRACT_ID||PLAN_ID;
  IF PUT(CONTPLN,$CONTPLNF.) NE 'NO';
RUN;

PROC SORT DATA=PLAN_FORM OUT=PFORMS(KEEP=FORMULARY_ID) NODUPKEY;
  BY FORMULARY_ID;
RUN;

DATA DS_PLAN_LIST;
  SET PFORMS;
  LENGTH HPLAN $11;
  HPLAN="DS001" || PUT(_N_,Z3.) || "000";
RUN;

DATA FMT;
  SET DS_PLAN_LIST END=LAST;
  LENGTH START $11 LABEL $8 FMTNAME $8 HLO $1;
  START=HPLAN;
  LABEL=FORMULARY_ID;
  FMTNAME='$DSFMT';
  HLO=' ';
  OUTPUT FMT;
  IF LAST THEN DO;
    START='OTHER';
    LABEL='N/A';
    HLO='O';
    OUTPUT FMT;
  END;
  KEEP START LABEL FMTNAME HLO;
RUN;

PROC SORT DATA=FMT NODUPKEY;
  BY START;
RUN;

PROC FORMAT CNTLIN=FMT LIBRARY=LIBRARY;
RUN;

PROC SORT DATA=FORM.FORMULARY OUT=FORMULARY;
  BY FORMULARY_ID RXCUI;
RUN;

DATA FORMULARY_SUBSET (DROP=TIER_LEVEL_OLD);
  MERGE PFORMS (IN=A)
        FORMULARY (IN=B RENAME=TIER_LEVEL_VALUE=TIER_LEVEL_OLD);
  BY FORMULARY_ID;
  IF A & B;
  LENGTH TIER_LEVEL $1;
  TIER_LEVEL=LEFT(PUT(TIER_LEVEL_OLD,3.));
RUN;

DATA PFORMS_MERGE;
  SET PFORMS;
  LENGTH JOIN_ID $1;
  JOIN_ID='1';
RUN;

DATA RXCUI_REFERENCE;
  SET INPUT.RXCUI_REFERENCE;
  LENGTH JOIN_ID $1;
  JOIN_ID='1';
RUN;

PROC SQL;
  CREATE TABLE RXCUI_MASTER_FILE AS
    (SELECT R.RXCUI, R.DRUG_TYPE, R.AVG_PRICE, F.FORMULARY_ID FROM RXCUI_REFERENCE R,
    PFORMS_MERGE F WHERE R.JOIN_ID=F.JOIN_ID)
    ORDER BY F.FORMULARY_ID, R.RXCUI;
RUN;

DATA FORMULARY_TIERS;
  MERGE RXCUI_MASTER_FILE (IN=A)
        FORMULARY_SUBSET (IN=B);
  BY FORMULARY_ID RXCUI;
  IF A;
  IF A AND NOT B THEN TIER_LEVEL = '9';
RUN;

PROC SQL;
  CREATE TABLE RICPME_SAMPLE_COHORT AS
    SELECT F.FORMULARY_ID, MIN(F.TIER_LEVEL) AS TIER_LEVEL, F.DRUG_TYPE, MIN(F.AVG_PRICE) AS AVG_PRICE,
           B.BASEID, B.SCRIPT_CNT30, B.RX_SCRIPT_ORDER, F.RXCUI, B.RXCUI AS ORXCUI
     FROM INPUT.BENE_SCRIPT B, FORMULARY_TIERS F, INPUT.FRF_XWALK X
     WHERE B.RXCUI = X.RXCUI AND X.ALTERNATIVE_RXCUI = F.RXCUI
     GROUP BY F.FORMULARY_ID, B.BASEID, B.RX_SCRIPT_ORDER, B.RXCUI, B.SCRIPT_CNT30
     HAVING MIN(F.AVG_PRICE) = F.AVG_PRICE
     ORDER BY F.FORMULARY_ID, B.BASEID, B.RX_SCRIPT_ORDER, F.RXCUI, B.RXCUI;
RUN;

  



