/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

public final class Base64 {
    private static final char[] lookup;
    private static final byte[] reverseLookup;

    private Base64() {
    }

    public static String encode(byte[] bytes) {
        int chunk;
        StringBuilder buf = new StringBuilder((bytes.length + 2) / 3 * 4);
        int i2 = 0;
        int end = bytes.length - 2;
        while (i2 < end) {
            chunk = (bytes[i2++] & 0xFF) << 16 | (bytes[i2++] & 0xFF) << 8 | bytes[i2++] & 0xFF;
            buf.append(lookup[chunk >> 18]);
            buf.append(lookup[chunk >> 12 & 0x3F]);
            buf.append(lookup[chunk >> 6 & 0x3F]);
            buf.append(lookup[chunk & 0x3F]);
        }
        int len = bytes.length;
        if (i2 < len) {
            chunk = (bytes[i2++] & 0xFF) << 16;
            buf.append(lookup[chunk >> 18]);
            if (i2 < len) {
                buf.append(lookup[(chunk |= (bytes[i2] & 0xFF) << 8) >> 12 & 0x3F]);
                buf.append(lookup[chunk >> 6 & 0x3F]);
            } else {
                buf.append(lookup[chunk >> 12 & 0x3F]);
                buf.append('=');
            }
            buf.append('=');
        }
        return buf.toString();
    }

    public static byte[] decode(String encoded) {
        int padding = 0;
        int i2 = encoded.length() - 1;
        while (encoded.charAt(i2) == '=') {
            ++padding;
            --i2;
        }
        int length = encoded.length() * 6 / 8 - padding;
        byte[] bytes = new byte[length];
        int index = 0;
        int n = encoded.length();
        for (int i3 = 0; i3 < n; i3 += 4) {
            int word = reverseLookup[encoded.charAt(i3)] << 18;
            word += reverseLookup[encoded.charAt(i3 + 1)] << 12;
            word += reverseLookup[encoded.charAt(i3 + 2)] << 6;
            word += reverseLookup[encoded.charAt(i3 + 3)];
            for (int j = 0; j < 3 && index + j < length; ++j) {
                bytes[index + j] = (byte)(word >> 8 * (2 - j));
            }
            index += 3;
        }
        return bytes;
    }

    static {
        int i2;
        lookup = new char[64];
        reverseLookup = new byte[256];
        for (i2 = 0; i2 < 26; ++i2) {
            Base64.lookup[i2] = (char)(65 + i2);
        }
        i2 = 26;
        int j = 0;
        while (i2 < 52) {
            Base64.lookup[i2] = (char)(97 + j);
            ++i2;
            ++j;
        }
        i2 = 52;
        j = 0;
        while (i2 < 62) {
            Base64.lookup[i2] = (char)(48 + j);
            ++i2;
            ++j;
        }
        Base64.lookup[62] = 43;
        Base64.lookup[63] = 47;
        for (i2 = 0; i2 < 256; ++i2) {
            Base64.reverseLookup[i2] = -1;
        }
        for (i2 = 90; i2 >= 65; --i2) {
            Base64.reverseLookup[i2] = (byte)(i2 - 65);
        }
        for (i2 = 122; i2 >= 97; --i2) {
            Base64.reverseLookup[i2] = (byte)(i2 - 97 + 26);
        }
        for (i2 = 57; i2 >= 48; --i2) {
            Base64.reverseLookup[i2] = (byte)(i2 - 48 + 52);
        }
        Base64.reverseLookup[43] = 62;
        Base64.reverseLookup[47] = 63;
        Base64.reverseLookup[61] = 0;
    }
}

