/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.errors;

import gov.cms.fiss.pricers.common.application.request.RequestContentExtractor;
import io.dropwizard.jersey.errors.ErrorMessage;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zalando.problem.Problem;
import org.zalando.problem.Status;

@Provider
public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebApplicationExceptionMapper.class);
    public static final String ERROR_MESSAGE = "Unable to process request";

    @Override
    public Response toResponse(WebApplicationException exception) {
        if (null == RequestContentExtractor.rfc7807Support()) {
            ErrorMessage errorMessage = new ErrorMessage(Status.BAD_REQUEST.getStatusCode(), ERROR_MESSAGE, exception.getMessage());
            return Response.status(errorMessage.getCode()).type(MediaType.APPLICATION_JSON_TYPE).entity(errorMessage).build();
        }
        return Response.status(Status.BAD_REQUEST.getStatusCode()).type("application/problem+json").entity(Problem.builder().withTitle(ERROR_MESSAGE).withDetail(exception.getMessage()).withStatus(Status.BAD_REQUEST).build()).build();
    }
}

