/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.resources;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import gov.cms.fiss.pricers.common.api.TableEntryRetrievalResponse;
import gov.cms.fiss.pricers.common.api.serialization.BasicIsoDateModule;
import gov.cms.fiss.pricers.common.application.OpenApiApplicationConfiguration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

public abstract class BaseCsvResource<E> {
    public static final String MEDIA_TYPE_CSV = "text/csv";
    protected static final CsvMapper DEFAULT_CSV_MAPPER = ((CsvMapper)new CsvMapper().enable(CsvParser.Feature.IGNORE_TRAILING_UNMAPPABLE).enable(CsvParser.Feature.FAIL_ON_MISSING_COLUMNS).enable(CsvParser.Feature.SKIP_EMPTY_LINES).findAndRegisterModules().registerModule(new BasicIsoDateModule()).enable(JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN)).enable(CsvGenerator.Feature.STRICT_CHECK_FOR_QUOTING);
    private static final String NOT_FOUND_MESSAGE_TEMPLATE = "No data found for year %s";
    private final Map<Integer, List<E>> perYearEntries = new ConcurrentHashMap<Integer, List<E>>();
    private final Map<Integer, String> perYearCsv = new ConcurrentHashMap<Integer, String>();

    protected BaseCsvResource(OpenApiApplicationConfiguration pricerConfiguration, Function<CsvMapper, CsvSchema> csvSchemaGenerator) {
        this(pricerConfiguration, DEFAULT_CSV_MAPPER::copy, csvSchemaGenerator);
    }

    protected BaseCsvResource(OpenApiApplicationConfiguration pricerConfiguration, Supplier<CsvMapper> csvMapperSupplier, Function<CsvMapper, CsvSchema> csvSchemaGenerator) {
        CsvMapper csvMapper = csvMapperSupplier.get();
        CsvSchema csvSchema = csvSchemaGenerator.apply(csvMapper);
        pricerConfiguration.getSupportedYears().forEach(pricerYear -> this.extractAndPopulate(csvMapper, csvSchema, (Integer)pricerYear));
    }

    protected abstract void extractAndPopulate(CsvMapper var1, CsvSchema var2, Integer var3);

    protected void addEntries(Integer year, List<E> entries) {
        this.perYearEntries.put(year, entries);
    }

    protected void addCsv(Integer year, String entryCsv) {
        this.perYearCsv.put(year, entryCsv);
    }

    protected Response getPerYearEntries(int year, String contentType, Function<List<E>, TableEntryRetrievalResponse<E>> contentEncapsulator) {
        switch (contentType) {
            case "application/json": {
                List<E> entries = this.perYearEntries.get(year);
                if (null != entries) {
                    return Response.ok(contentEncapsulator.apply(entries)).header("Content-Type", "application/json").build();
                }
                return Response.status(Response.Status.NOT_FOUND.getStatusCode(), String.format(NOT_FOUND_MESSAGE_TEMPLATE, year)).build();
            }
            case "text/csv": {
                String csvEntries = this.perYearCsv.get(year);
                if (null != csvEntries) {
                    return Response.ok(csvEntries).header("Content-Type", MEDIA_TYPE_CSV).build();
                }
                return Response.status(Response.Status.NOT_FOUND.getStatusCode(), String.format(NOT_FOUND_MESSAGE_TEMPLATE, year)).build();
            }
        }
        return Response.notAcceptable(Variant.mediaTypes(MediaType.APPLICATION_JSON_TYPE, new MediaType(MEDIA_TYPE_CSV, null)).build()).build();
    }

    protected Response findMatchingEntries(Supplier<List<E>> matchingEntryExtractor, Function<List<E>, TableEntryRetrievalResponse<E>> contentEncapsulator) {
        List<E> matchedEntries = matchingEntryExtractor.get();
        if (matchedEntries.isEmpty()) {
            return Response.status(Response.Status.NOT_FOUND.getStatusCode(), "No matching entries found").build();
        }
        return Response.ok(contentEncapsulator.apply(matchedEntries)).header("Content-Type", "application/json").build();
    }
}

