/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateBundledConditionCodePayment
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        if (calculationContext.isEsrdTraining73() || calculationContext.isEsrdRetraining87()) {
            if (BigDecimalUtils.equals(calculationContext.getBundledOnsetFactor(), calculationContext.getCaseMixOnsetLessThanOrEqualTo120Multiplier())) {
                calculationContext.setBundledWageAdjustedTrainingAmount(BigDecimal.ZERO);
            } else {
                calculationContext.setBundledWageAdjustedTrainingAmount(calculationContext.getTrainingAddOnPaymentAmount().multiply(calculationContext.getBundledWageIndex()).setScale(4, RoundingMode.HALF_UP));
                calculationContext.setTrainingClaim(true);
            }
        } else {
            this.calculateInHomePerDiemAmount(calculationContext);
        }
    }

    protected void calculateInHomePerDiemAmount(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.isPerDiemClaim()) {
            calculationContext.setConditionCode74PerDiemAmount(calculationContext.getBundledAdjustedBaseWageAmount().multiply(new BigDecimal(3)).divide(new BigDecimal(7), 4, RoundingMode.DOWN));
        } else {
            calculationContext.setBundledWageAdjustedTrainingAmount(BigDecimal.ZERO);
            calculationContext.setConditionCode74PerDiemAmount(BigDecimal.ZERO);
        }
    }
}

