/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.RoundingMode;
import java.time.temporal.ChronoUnit;

public class CalculateBundledOnsetFactor
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (null != claimData.getDialysisStartDate()) {
            long onsetPeriod = ChronoUnit.DAYS.between(claimData.getDialysisStartDate(), claimData.getServiceDate()) + 1L;
            if (calculationContext.isAdultPatient()) {
                if (onsetPeriod > 120L) {
                    calculationContext.setBundledOnsetFactor(EsrdPricerContext.DEFAULT_FACTOR);
                } else {
                    calculationContext.setBundledOnsetFactor(calculationContext.getCaseMixOnsetLessThanOrEqualTo120Multiplier().setScale(4, RoundingMode.HALF_UP));
                    calculationContext.setOnsetRecent(true);
                }
            } else {
                calculationContext.setBundledOnsetFactor(EsrdPricerContext.DEFAULT_FACTOR);
            }
        } else {
            calculationContext.setBundledOnsetFactor(EsrdPricerContext.DEFAULT_FACTOR);
        }
    }
}

