/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors.low_volume;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CompareLowVolPredictedToImputedOutlierSvcsMapPerTrt
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        calculationContext.setLowVolumeOutlierPredictedMap(calculationContext.getLowVolumeOutlierCaseMixAdjustedPredictedSvcsMapPerTrt().add(calculationContext.getFixedDollarLossOver17()).setScale(4, RoundingMode.HALF_UP));
        calculationContext.setOutlierFixedDollarLoss(calculationContext.getFixedDollarLossOver17());
        if (BigDecimalUtils.isGreaterThan(calculationContext.getOutlierImputedMapAmount(), calculationContext.getLowVolumeOutlierPredictedMap())) {
            calculationContext.setLowVolumeOutlierPayment(calculationContext.getOutlierImputedMapAmount().subtract(calculationContext.getLowVolumeOutlierPredictedMap()).multiply(calculationContext.getLossSharingPercentageOver17()).setScale(4, RoundingMode.HALF_UP));
            calculationContext.setOutlierLossSharingPercentage(calculationContext.getLossSharingPercentageOver17());
        } else {
            calculationContext.setLowVolumeOutlierPayment(BigDecimal.ZERO);
        }
        calculationContext.getPaymentData().setOutlierNonPerDiemPaymentAmount(calculationContext.getLowVolumeOutlierPayment());
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (calculationContext.isPerDiemClaim()) {
            calculationContext.setLowVolumeOutlierPayment(calculationContext.getLowVolumeOutlierPayment().multiply(new BigDecimal(calculationContext.getClaimData().getDialysisSessionCount()).multiply(new BigDecimal(3))).divide(new BigDecimal(7), 4, RoundingMode.DOWN));
        }
    }
}

