/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors.outlier;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateSeparatelyBillableOutlierBsaFactor
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        calculationContext.setOutlierBsa(calculationContext.calculateBodySurfaceArea());
        if (calculationContext.isAdultPatient()) {
            calculationContext.setOutlierBsaFactor(BigDecimalUtils.pow(calculationContext.getSeparatelyBillableBsa(), calculationContext.getOutlierBsa().subtract(calculationContext.getBsaNationalAverage()).divide(new BigDecimal(".1"), RoundingMode.DOWN), 9).setScale(4, RoundingMode.HALF_UP));
        } else {
            calculationContext.setOutlierBsaFactor(new BigDecimal("1.0000"));
        }
    }
}

