/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors.outlier;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.RoundingMode;
import java.time.temporal.ChronoUnit;

public class CalculateSeparatelyBillableOutlierOnsetFactor
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (null != claimData.getDialysisStartDate()) {
            if (calculationContext.isAdultPatient()) {
                long onsetPeriod = ChronoUnit.DAYS.between(claimData.getDialysisStartDate(), claimData.getServiceDate()) + 1L;
                if (onsetPeriod > 120L) {
                    calculationContext.setOutlierOnsetFactor(EsrdPricerContext.DEFAULT_FACTOR);
                } else {
                    calculationContext.setOutlierOnsetFactor(calculationContext.getSeparatelyBillableOnsetLessThanOrEqualTo120Multiplier().setScale(4, RoundingMode.HALF_UP));
                }
            } else {
                calculationContext.setOutlierOnsetFactor(EsrdPricerContext.DEFAULT_FACTOR);
            }
        } else {
            calculationContext.setOutlierOnsetFactor(EsrdPricerContext.DEFAULT_FACTOR);
        }
    }
}

