/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors.outlier;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ComparePredictedToImputedOutlierSvcsMapPerTrt
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        if (!calculationContext.isAdultPatient()) {
            calculationContext.setOutlierPredictedMapAmount(calculationContext.getOutlierCaseMixAdjPredictedMapTrt().add(calculationContext.getFixedDollarLossUnder18()).setScale(4, RoundingMode.HALF_UP));
            calculationContext.setOutlierFixedDollarLoss(calculationContext.getFixedDollarLossUnder18());
            if (BigDecimalUtils.isGreaterThan(calculationContext.getOutlierImputedMapAmount(), calculationContext.getOutlierPredictedMapAmount())) {
                calculationContext.setOutlierPayment(calculationContext.getOutlierImputedMapAmount().subtract(calculationContext.getOutlierPredictedMapAmount()).multiply(calculationContext.getLossSharingPercentageUnder18()).setScale(4, RoundingMode.HALF_UP));
                calculationContext.setOutlierLossSharingPercentage(calculationContext.getLossSharingPercentageUnder18());
                calculationContext.setOutlierClaim(true);
            } else {
                calculationContext.setOutlierPayment(BigDecimal.ZERO);
                calculationContext.setOutlierLossSharingPercentage(BigDecimal.ZERO);
            }
        } else {
            calculationContext.setOutlierPredictedMapAmount(calculationContext.getOutlierCaseMixAdjPredictedMapTrt().add(calculationContext.getFixedDollarLossOver17()).setScale(4, RoundingMode.HALF_UP));
            calculationContext.setOutlierFixedDollarLoss(calculationContext.getFixedDollarLossOver17());
            if (BigDecimalUtils.isGreaterThan(calculationContext.getOutlierImputedMapAmount(), calculationContext.getOutlierPredictedMapAmount())) {
                calculationContext.setOutlierPayment(calculationContext.getOutlierImputedMapAmount().subtract(calculationContext.getOutlierPredictedMapAmount()).multiply(calculationContext.getLossSharingPercentageOver17()).setScale(4, RoundingMode.HALF_UP));
                calculationContext.setOutlierLossSharingPercentage(calculationContext.getLossSharingPercentageOver17());
                calculationContext.setOutlierClaim(true);
            } else {
                calculationContext.setOutlierPayment(BigDecimal.ZERO);
            }
        }
    }
}

