/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.move_results;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.AdditionalPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.BundledPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdPaymentData;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class MoveBaseResults
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        OutpatientProviderData providerData = calculationContext.getProviderData();
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        AdditionalPaymentData additionalPaymentInformation = paymentData.getAdditionalPaymentInformation();
        AdditionalPaymentData additionalPaymentData2011 = paymentData.getAdditionalPaymentInformation2011();
        paymentData.setFinalCbsa(providerData.getCbsaActualGeographicLocation());
        additionalPaymentInformation.setWageAdjustmentRate(BigDecimal.ZERO);
        additionalPaymentData2011.setWageAdjustmentRate(calculationContext.getBundledBaseWageAmount());
        additionalPaymentData2011.setNationalLaborPercent(calculationContext.getBundledNationalLaborPercentage());
        additionalPaymentData2011.setNationalNonLaborPercent(calculationContext.getBundledNationalNonLaborPercent());
        additionalPaymentInformation.setNationalLaborPercent(calculationContext.getNationalLaborPercent());
        additionalPaymentInformation.setNationalNonLaborPercent(calculationContext.getNationalNonLaborPercent());
        additionalPaymentInformation.setAgeAdjustmentFactor(BigDecimal.ZERO);
        additionalPaymentInformation.setBodySurfaceAreaFactor(BigDecimal.ZERO);
        additionalPaymentInformation.setBodyMassIndexFactor(BigDecimal.ZERO);
        additionalPaymentInformation.setBudgetNeutralityRate(EsrdPricerContext.CASE_MIX_BUDGET_NEUTRAL_FACTOR);
        additionalPaymentData2011.setAgeAdjustmentFactor(calculationContext.getBundledAgeAdjustmentFactor());
        additionalPaymentData2011.setBodySurfaceAreaFactor(calculationContext.getBundledBsaFactor());
        additionalPaymentData2011.setBodyMassIndexFactor(calculationContext.getBundledBmiFactor());
        additionalPaymentData2011.setBudgetNeutralityRate(EsrdPricerContext.TRANSITION_BUDGET_NEUTRAL_FACTOR);
        if (calculationContext.isEsrdHome74() && claimData.getDialysisSessionCount() != 0 && StringUtils.equalsAny(claimData.getRevenueCode(), "0841", "0851")) {
            calculationContext.setOutlierPayment(calculationContext.getOutlierPayment().divide(new BigDecimal(claimData.getDialysisSessionCount()), 4, RoundingMode.DOWN));
        }
        BundledPaymentData bundledData = calculationContext.getBundledData();
        bundledData.setBlendedCompositeRate(BigDecimal.ZERO);
        bundledData.setBlendedPaymentRate(BigDecimal.ZERO);
        bundledData.setBlendedOutlierRate(BigDecimal.ZERO);
        bundledData.setFullCompositeRate(BigDecimal.ZERO);
        bundledData.setFullPaymentRate(calculationContext.getFinalPaymentAmount());
        paymentData.setTotalPayment(calculationContext.getFinalPaymentAmount());
        bundledData.setFullOutlierRate(calculationContext.getOutlierPayment().setScale(2, RoundingMode.DOWN));
        paymentData.setTdapaPaymentAdjustmentAmount(calculationContext.getTdapaPayment());
        this.adjustOutlierForQip(calculationContext);
    }

    protected void adjustOutlierForQip(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        OutpatientProviderData providerData = calculationContext.getProviderData();
        BundledPaymentData bundledData = calculationContext.getBundledData();
        if (!calculationContext.isAki84() && null != providerData.getHospitalQualityIndicator()) {
            bundledData.setBlendedCompositeRate(BigDecimalUtils.defaultValue(bundledData.getBlendedCompositeRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            bundledData.setFullCompositeRate(BigDecimalUtils.defaultValue(bundledData.getFullCompositeRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            bundledData.setBlendedPaymentRate(BigDecimalUtils.defaultValue(bundledData.getBlendedPaymentRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            bundledData.setFullPaymentRate(BigDecimalUtils.defaultValue(bundledData.getFullPaymentRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            bundledData.setBlendedOutlierRate(BigDecimalUtils.defaultValue(bundledData.getBlendedOutlierRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            bundledData.setFullOutlierRate(BigDecimalUtils.defaultValue(bundledData.getFullOutlierRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
        }
    }
}

