/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly.connector;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.ProxyServerSelector;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import com.ning.http.util.ProxyUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.innate.ClientProxy;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.grizzly.connector.GrizzlyConnectorProvider;
import org.glassfish.jersey.grizzly.connector.LocalizationMessages;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.util.collection.ByteBufferInputStream;
import org.glassfish.jersey.internal.util.collection.NonBlockingInputStream;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.OutboundMessageContext;

class GrizzlyConnector
implements Connector {
    private final AsyncHttpClient grizzlyClient;

    GrizzlyConnector(Client client, Configuration config, GrizzlyConnectorProvider.AsyncClientCustomizer asyncClientCustomizer) {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        if (config != null) {
            Object threadPoolSize = config.getProperties().get("jersey.config.client.async.threadPoolSize");
            ExecutorService executorService = threadPoolSize != null && threadPoolSize instanceof Integer && (Integer)threadPoolSize > 0 ? Executors.newFixedThreadPool((Integer)threadPoolSize) : Executors.newCachedThreadPool();
            builder.setExecutorService(executorService);
            builder.setConnectTimeout(ClientProperties.getValue(config.getProperties(), "jersey.config.client.connectTimeout", 10000));
            builder.setRequestTimeout(ClientProperties.getValue(config.getProperties(), "jersey.config.client.readTimeout", 10000));
            Optional<ClientProxy> proxy = ClientProxy.proxyFromConfiguration(config);
            proxy.ifPresent(clientProxy -> {
                URI u = clientProxy.uri();
                Properties proxyProperties = new Properties();
                proxyProperties.setProperty("com.ning.http.client.AsyncHttpClientConfig.proxy.protocol", u.getScheme());
                proxyProperties.setProperty("http.proxyHost", u.getHost());
                proxyProperties.setProperty("http.proxyPort", String.valueOf(u.getPort()));
                if (clientProxy.userName() != null) {
                    proxyProperties.setProperty("com.ning.http.client.AsyncHttpClientConfig.proxy.user", clientProxy.userName());
                    if (clientProxy.password() != null) {
                        proxyProperties.setProperty("com.ning.http.client.AsyncHttpClientConfig.proxy.password", clientProxy.password());
                    }
                }
                ProxyServerSelector proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyProperties);
                builder.setProxyServerSelector(proxyServerSelector);
            });
        } else {
            ExecutorService executorService = Executors.newCachedThreadPool();
            builder.setExecutorService(executorService);
        }
        builder.setAllowPoolingConnections(true);
        if (client.getSslContext() != null) {
            builder.setSSLContext(client.getSslContext());
        }
        if (client.getHostnameVerifier() != null) {
            builder.setHostnameVerifier(client.getHostnameVerifier());
        }
        if (asyncClientCustomizer != null) {
            asyncClientCustomizer.customize(client, config, builder);
        }
        AsyncHttpClientConfig asyncClientConfig = builder.build();
        this.grizzlyClient = new AsyncHttpClient(new GrizzlyAsyncHttpProvider(asyncClientConfig), asyncClientConfig);
    }

    public AsyncHttpClient getGrizzlyClient() {
        return this.grizzlyClient;
    }

    @Override
    public ClientResponse apply(final ClientRequest request) {
        Request connectorRequest = this.translate(request);
        final Map<String, String> clientHeadersSnapshot = GrizzlyConnector.writeOutBoundHeaders(request, connectorRequest);
        final CompletableFuture responseFuture = new CompletableFuture();
        final ByteBufferInputStream entityStream = new ByteBufferInputStream();
        final AtomicBoolean futureSet = new AtomicBoolean(false);
        try {
            this.grizzlyClient.executeRequest(connectorRequest, new AsyncHandler<Void>(){
                private volatile HttpResponseStatus status = null;

                @Override
                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
                    if (!futureSet.compareAndSet(false, true)) {
                        return AsyncHandler.STATE.ABORT;
                    }
                    HeaderUtils.checkHeaderChanges(clientHeadersSnapshot, request.getHeaders(), GrizzlyConnector.this.getClass().getName(), request.getConfiguration());
                    responseFuture.complete(GrizzlyConnector.this.translate(request, this.status, headers, entityStream));
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    entityStream.put(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public Void onCompleted() throws Exception {
                    entityStream.closeQueue();
                    return null;
                }

                @Override
                public void onThrowable(Throwable t2) {
                    entityStream.closeQueue(t2);
                    if (futureSet.compareAndSet(false, true)) {
                        t2 = t2 instanceof IOException ? new ProcessingException(t2.getMessage(), t2) : t2;
                        responseFuture.completeExceptionally(t2);
                    }
                }
            });
            return (ClientResponse)responseFuture.get();
        }
        catch (ExecutionException ex) {
            Throwable e = ex.getCause() == null ? ex : ex.getCause();
            throw new ProcessingException(e.getMessage(), e);
        }
        catch (InterruptedException ex) {
            throw new ProcessingException(ex.getMessage(), ex);
        }
    }

    @Override
    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        Request connectorRequest = this.translate(request);
        final Map<String, String> clientHeadersSnapshot = GrizzlyConnector.writeOutBoundHeaders(request, connectorRequest);
        final ByteBufferInputStream entityStream = new ByteBufferInputStream();
        final AtomicBoolean callbackInvoked = new AtomicBoolean(false);
        try {
            return this.grizzlyClient.executeRequest(connectorRequest, new AsyncHandler<Void>(){
                private volatile HttpResponseStatus status = null;

                @Override
                public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
                    this.status = responseStatus;
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public AsyncHandler.STATE onHeadersReceived(final HttpResponseHeaders headers) throws Exception {
                    if (!callbackInvoked.compareAndSet(false, true)) {
                        return AsyncHandler.STATE.ABORT;
                    }
                    HeaderUtils.checkHeaderChanges(clientHeadersSnapshot, request.getHeaders(), GrizzlyConnector.this.getClass().getName(), request.getConfiguration());
                    GrizzlyConnector.this.processResponse(new Runnable(){

                        @Override
                        public void run() {
                            callback.response(GrizzlyConnector.this.translate(request, status, headers, entityStream));
                        }
                    });
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
                    entityStream.put(bodyPart.getBodyByteBuffer());
                    return AsyncHandler.STATE.CONTINUE;
                }

                @Override
                public Void onCompleted() throws Exception {
                    entityStream.closeQueue();
                    return null;
                }

                @Override
                public void onThrowable(Throwable t2) {
                    entityStream.closeQueue(t2);
                    if (callbackInvoked.compareAndSet(false, true)) {
                        t2 = t2 instanceof IOException ? new ProcessingException(t2.getMessage(), t2) : t2;
                        callback.failure(t2);
                    }
                }
            });
        }
        catch (Throwable t2) {
            Throwable failure = t2;
            if (callbackInvoked.compareAndSet(false, true)) {
                callback.failure(failure);
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(failure);
            return future;
        }
    }

    @Override
    public void close() {
        this.grizzlyClient.close();
    }

    private ClientResponse translate(ClientRequest requestContext, final HttpResponseStatus status, HttpResponseHeaders headers, NonBlockingInputStream entityStream) {
        ClientResponse responseContext = new ClientResponse(new Response.StatusType(){

            @Override
            public int getStatusCode() {
                return status.getStatusCode();
            }

            @Override
            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf(status.getStatusCode());
            }

            @Override
            public String getReasonPhrase() {
                return status.getStatusText();
            }
        }, requestContext);
        for (Map.Entry<String, List<String>> entry : headers.getHeaders().entrySet()) {
            for (String value : entry.getValue()) {
                responseContext.getHeaders().add(entry.getKey(), value);
            }
        }
        responseContext.setEntityStream(entityStream);
        return responseContext;
    }

    private Request translate(final ClientRequest requestContext) {
        GrizzlyConnectorProvider.RequestCustomizer requestCustomizer;
        String strMethod = requestContext.getMethod();
        URI uri = requestContext.getUri();
        RequestBuilder builder = new RequestBuilder(strMethod).setUrl(uri.toString());
        builder.setFollowRedirects(requestContext.resolveProperty("jersey.config.client.followRedirects", true));
        if (requestContext.hasEntity()) {
            RequestEntityProcessing entityProcessing = (RequestEntityProcessing)((Object)requestContext.resolveProperty("jersey.config.client.request.entity.processing", RequestEntityProcessing.class));
            if (entityProcessing == RequestEntityProcessing.BUFFERED) {
                byte[] entityBytes = this.bufferEntity(requestContext);
                builder = builder.setBody(entityBytes);
            } else {
                FeedableBodyGenerator bodyGenerator = new FeedableBodyGenerator();
                Integer chunkSize = requestContext.resolveProperty("jersey.config.client.chunkedEncodingSize", 4096);
                bodyGenerator.setMaxPendingBytes(chunkSize);
                final FeedableBodyGenerator.SimpleFeeder feeder = new FeedableBodyGenerator.SimpleFeeder(bodyGenerator){

                    @Override
                    public void flush() throws IOException {
                        requestContext.writeEntity();
                    }
                };
                requestContext.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    @Override
                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return new FeederAdapter(feeder);
                    }
                });
                bodyGenerator.setFeeder(feeder);
                builder.setBody(bodyGenerator);
            }
        }
        if ((requestCustomizer = (GrizzlyConnectorProvider.RequestCustomizer)((Object)requestContext.resolveProperty("jersey.config.grizzly.client.request.customizer", GrizzlyConnectorProvider.RequestCustomizer.class))) != null) {
            builder = requestCustomizer.customize(requestContext, builder);
        }
        return builder.build();
    }

    private void processResponse(Runnable responseTask) {
        this.grizzlyClient.getConfig().executorService().submit(responseTask);
    }

    private byte[] bufferEntity(ClientRequest requestContext) {
        final ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        requestContext.setStreamProvider(new OutboundMessageContext.StreamProvider(){

            @Override
            public OutputStream getOutputStream(int contentLength) throws IOException {
                return baos;
            }
        });
        try {
            requestContext.writeEntity();
        }
        catch (IOException e) {
            throw new ProcessingException(LocalizationMessages.ERROR_BUFFERING_ENTITY(), e);
        }
        return baos.toByteArray();
    }

    private static Map<String, String> writeOutBoundHeaders(ClientRequest clientRequest, Request request) {
        Map<String, String> stringHeaders = HeaderUtils.asStringHeadersSingleValue(clientRequest.getHeaders(), clientRequest.getConfiguration());
        for (Map.Entry<String, String> e : stringHeaders.entrySet()) {
            request.getHeaders().add(e.getKey(), e.getValue());
        }
        return stringHeaders;
    }

    @Override
    public String getName() {
        return String.format("Async HTTP Grizzly Connector %s", Version.getVersion());
    }

    private class FeederAdapter
    extends OutputStream {
        final FeedableBodyGenerator.Feeder delegate;

        FeederAdapter(FeedableBodyGenerator.Feeder bodyFeeder) {
            this.delegate = bodyFeeder;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] buffer = new byte[]{(byte)b};
            this.delegate.feed(Buffers.wrap(MemoryManager.DEFAULT_MEMORY_MANAGER, buffer), false);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.feed(Buffers.wrap(MemoryManager.DEFAULT_MEMORY_MANAGER, b), false);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.feed(Buffers.wrap(MemoryManager.DEFAULT_MEMORY_MANAGER, b, off, len), false);
        }

        @Override
        public void close() throws IOException {
            this.delegate.feed(Buffers.EMPTY_BUFFER, true);
        }
    }
}

