// Generated by delombok at Thu May 22 14:06:59 UTC 2025
package gov.cms.fiss.pricers.esrd.core.codes;

import java.util.Arrays;
import java.util.Optional;

public enum PayerOnlyConditionCode {
  /**
   * Gastroenteritis (GI) bleed (acute comorbidity).
   */
  MA("20"), /**
   * Pneumonia (acute comorbidity); currently unsupported.
   */
  MB("-1"), /**
   * Pericarditis (acute comorbidity).
   */
  MC("40"), /**
   * Myelodysplastic syndrome (chronic comorbidity).
   */
  MD("50"), /**
   * Hereditary hemolytic and sickle cell anemia (chronic comorbidity).
   */
  ME("60"), /**
   * Monoclonal gammopathy (chronic comorbidity); currently unsupported.
   */
  MF("-2");
  private final String returnCode;

  PayerOnlyConditionCode(String returnCode) {
    this.returnCode = returnCode;
  }

  public static PayerOnlyConditionCode fromReturnCode(String returnCode) {
    final Optional<PayerOnlyConditionCode> matchedCode = Arrays.stream(PayerOnlyConditionCode.values()).filter(pocc -> pocc.getReturnCode().equals(returnCode)).findFirst();
    return matchedCode.orElse(null);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReturnCode() {
    return this.returnCode;
  }
}
