// Generated by delombok at Thu May 22 14:06:18 UTC 2025
package gov.cms.fiss.pricers.esrd.api.v2;

import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@Schema(description = "A demo code and its associated indicators, which can be used to modify the claim processing flow.")
public class DemoCodeData {
  @NotNull
  @Pattern(regexp = "\\d{2}", message = "must be a two digit number.")
  @Schema(description = "A demo code related to the claim.", example = "11", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DATA-CODE", value = "PIC X(02)")})})
  private String demoCode;
  @ArraySchema(arraySchema = @Schema(description = "The indicators related to this demo code.", example = "[\"H\"]"), uniqueItems = true)
  @Size(max = 5, min = 1)
  private List<@Pattern(regexp = "^[A-Z0-9]$", message = "must be a single alphanumeric character") String> adjustmentIndicators;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getDemoCode() {
    return this.demoCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public List<@Pattern(regexp = "^[A-Z0-9]$", message = "must be a single alphanumeric character") String> getAdjustmentIndicators() {
    return this.adjustmentIndicators;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDemoCode(final String demoCode) {
    this.demoCode = demoCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdjustmentIndicators(final List<@Pattern(regexp = "^[A-Z0-9]$", message = "must be a single alphanumeric character") String> adjustmentIndicators) {
    this.adjustmentIndicators = adjustmentIndicators;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof DemoCodeData)) return false;
    final DemoCodeData other = (DemoCodeData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$demoCode = this.getDemoCode();
    final java.lang.Object other$demoCode = other.getDemoCode();
    if (this$demoCode == null ? other$demoCode != null : !this$demoCode.equals(other$demoCode)) return false;
    final java.lang.Object this$adjustmentIndicators = this.getAdjustmentIndicators();
    final java.lang.Object other$adjustmentIndicators = other.getAdjustmentIndicators();
    if (this$adjustmentIndicators == null ? other$adjustmentIndicators != null : !this$adjustmentIndicators.equals(other$adjustmentIndicators)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof DemoCodeData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $demoCode = this.getDemoCode();
    result = result * PRIME + ($demoCode == null ? 43 : $demoCode.hashCode());
    final java.lang.Object $adjustmentIndicators = this.getAdjustmentIndicators();
    result = result * PRIME + ($adjustmentIndicators == null ? 43 : $adjustmentIndicators.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "DemoCodeData(demoCode=" + this.getDemoCode() + ", adjustmentIndicators=" + this.getAdjustmentIndicators() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DemoCodeData() {
  }
}
