/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.esrd.api.v2.ValidCommonWorkingFileReturnCode;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;

@Schema(description="The bundled payment information.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BUNDLED-DATA", value="<structure>")})})
public class BundledPaymentData {
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The blended composite rate amount.", example="50250.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-2011-BLEND-COMP-RATE", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    @FixedValue
    private BigDecimal blendedCompositeRate;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The blended outlier rate amount.", example="67.24", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-2011-BLEND-OUTLIER-RATE", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    @FixedValue
    private BigDecimal blendedOutlierRate;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The blended payment rate amount.", example="6500.25", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-2011-BLEND-PPS-RATE", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    @FixedValue
    private BigDecimal blendedPaymentRate;
    @Schema(description="The payment code that corresponds to the common working file return code for the comorbidity.", example="10", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-2011-COMORBID-PAY", value="PIC X(02)")})})
    @ValidCommonWorkingFileReturnCode
    private String comorbidityPaymentCode;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The full composite rate amount.", example="950.80", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-2011-FULL-COMP-RATE", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal fullCompositeRate;
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The full outlier rate amount.", example="8800.35", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-2011-FULL-OUTLIER-RATE", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal fullOutlierRate = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
    @BigDecimalScale(roundingMode=RoundingMode.HALF_UP)
    @Schema(description="The full payment rate amount.", example="80.90", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-2011-FULL-PPS-RATE", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal fullPaymentRate = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);

    @Generated
    public BigDecimal getBlendedCompositeRate() {
        return this.blendedCompositeRate;
    }

    @Generated
    public BigDecimal getBlendedOutlierRate() {
        return this.blendedOutlierRate;
    }

    @Generated
    public BigDecimal getBlendedPaymentRate() {
        return this.blendedPaymentRate;
    }

    @Generated
    public String getComorbidityPaymentCode() {
        return this.comorbidityPaymentCode;
    }

    @Generated
    public BigDecimal getFullCompositeRate() {
        return this.fullCompositeRate;
    }

    @Generated
    public BigDecimal getFullOutlierRate() {
        return this.fullOutlierRate;
    }

    @Generated
    public BigDecimal getFullPaymentRate() {
        return this.fullPaymentRate;
    }

    @Generated
    public void setBlendedCompositeRate(BigDecimal blendedCompositeRate) {
        this.blendedCompositeRate = blendedCompositeRate;
    }

    @Generated
    public void setBlendedOutlierRate(BigDecimal blendedOutlierRate) {
        this.blendedOutlierRate = blendedOutlierRate;
    }

    @Generated
    public void setBlendedPaymentRate(BigDecimal blendedPaymentRate) {
        this.blendedPaymentRate = blendedPaymentRate;
    }

    @Generated
    public void setComorbidityPaymentCode(String comorbidityPaymentCode) {
        this.comorbidityPaymentCode = comorbidityPaymentCode;
    }

    @Generated
    public void setFullCompositeRate(BigDecimal fullCompositeRate) {
        this.fullCompositeRate = fullCompositeRate;
    }

    @Generated
    public void setFullOutlierRate(BigDecimal fullOutlierRate) {
        this.fullOutlierRate = fullOutlierRate;
    }

    @Generated
    public void setFullPaymentRate(BigDecimal fullPaymentRate) {
        this.fullPaymentRate = fullPaymentRate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BundledPaymentData)) {
            return false;
        }
        BundledPaymentData other = (BundledPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$blendedCompositeRate = this.getBlendedCompositeRate();
        BigDecimal other$blendedCompositeRate = other.getBlendedCompositeRate();
        if (this$blendedCompositeRate == null ? other$blendedCompositeRate != null : !((Object)this$blendedCompositeRate).equals(other$blendedCompositeRate)) {
            return false;
        }
        BigDecimal this$blendedOutlierRate = this.getBlendedOutlierRate();
        BigDecimal other$blendedOutlierRate = other.getBlendedOutlierRate();
        if (this$blendedOutlierRate == null ? other$blendedOutlierRate != null : !((Object)this$blendedOutlierRate).equals(other$blendedOutlierRate)) {
            return false;
        }
        BigDecimal this$blendedPaymentRate = this.getBlendedPaymentRate();
        BigDecimal other$blendedPaymentRate = other.getBlendedPaymentRate();
        if (this$blendedPaymentRate == null ? other$blendedPaymentRate != null : !((Object)this$blendedPaymentRate).equals(other$blendedPaymentRate)) {
            return false;
        }
        String this$comorbidityPaymentCode = this.getComorbidityPaymentCode();
        String other$comorbidityPaymentCode = other.getComorbidityPaymentCode();
        if (this$comorbidityPaymentCode == null ? other$comorbidityPaymentCode != null : !this$comorbidityPaymentCode.equals(other$comorbidityPaymentCode)) {
            return false;
        }
        BigDecimal this$fullCompositeRate = this.getFullCompositeRate();
        BigDecimal other$fullCompositeRate = other.getFullCompositeRate();
        if (this$fullCompositeRate == null ? other$fullCompositeRate != null : !((Object)this$fullCompositeRate).equals(other$fullCompositeRate)) {
            return false;
        }
        BigDecimal this$fullOutlierRate = this.getFullOutlierRate();
        BigDecimal other$fullOutlierRate = other.getFullOutlierRate();
        if (this$fullOutlierRate == null ? other$fullOutlierRate != null : !((Object)this$fullOutlierRate).equals(other$fullOutlierRate)) {
            return false;
        }
        BigDecimal this$fullPaymentRate = this.getFullPaymentRate();
        BigDecimal other$fullPaymentRate = other.getFullPaymentRate();
        return !(this$fullPaymentRate == null ? other$fullPaymentRate != null : !((Object)this$fullPaymentRate).equals(other$fullPaymentRate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BundledPaymentData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $blendedCompositeRate = this.getBlendedCompositeRate();
        result = result * 59 + ($blendedCompositeRate == null ? 43 : ((Object)$blendedCompositeRate).hashCode());
        BigDecimal $blendedOutlierRate = this.getBlendedOutlierRate();
        result = result * 59 + ($blendedOutlierRate == null ? 43 : ((Object)$blendedOutlierRate).hashCode());
        BigDecimal $blendedPaymentRate = this.getBlendedPaymentRate();
        result = result * 59 + ($blendedPaymentRate == null ? 43 : ((Object)$blendedPaymentRate).hashCode());
        String $comorbidityPaymentCode = this.getComorbidityPaymentCode();
        result = result * 59 + ($comorbidityPaymentCode == null ? 43 : $comorbidityPaymentCode.hashCode());
        BigDecimal $fullCompositeRate = this.getFullCompositeRate();
        result = result * 59 + ($fullCompositeRate == null ? 43 : ((Object)$fullCompositeRate).hashCode());
        BigDecimal $fullOutlierRate = this.getFullOutlierRate();
        result = result * 59 + ($fullOutlierRate == null ? 43 : ((Object)$fullOutlierRate).hashCode());
        BigDecimal $fullPaymentRate = this.getFullPaymentRate();
        result = result * 59 + ($fullPaymentRate == null ? 43 : ((Object)$fullPaymentRate).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BundledPaymentData(blendedCompositeRate=" + this.getBlendedCompositeRate() + ", blendedOutlierRate=" + this.getBlendedOutlierRate() + ", blendedPaymentRate=" + this.getBlendedPaymentRate() + ", comorbidityPaymentCode=" + this.getComorbidityPaymentCode() + ", fullCompositeRate=" + this.getFullCompositeRate() + ", fullOutlierRate=" + this.getFullOutlierRate() + ", fullPaymentRate=" + this.getFullPaymentRate() + ")";
    }

    @Generated
    public BundledPaymentData() {
    }
}

