/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import gov.cms.fiss.pricers.esrd.api.v2.ComorbidityData;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import lombok.Generated;

@Schema(description="The ESRD claim data to process for pricing.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BUNDLED-BILL-PORTION", value="<structure>")})})
public class EsrdClaimData
extends ClaimData {
    @Valid
    private ComorbidityData comorbidities;
    @ArraySchema(arraySchema=@Schema(description="The condition codes related to the claim.", example="[\"84\" + \"73\" + \"n\"]"), uniqueItems=true)
    @Size(max=2, min=1)
    private @Size(max=2, min=1) List<@Pattern(regexp="\\d{2}", message="must be two digits") String> conditionCodes;
    @ArraySchema(arraySchema=@Schema(description="The demo codes related to the claim.", example="[\"83\"]"), uniqueItems=true, extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DATA-CODE", value="PIC X(02)")})})
    @Size(max=4, min=1)
    private @Size(max=4, min=1) List<@Pattern(regexp="\\d{2}", message="must be two digits") String> demoCodes;
    @Max(value=99L)
    @Min(value=0L)
    @NotNull
    @Schema(description="The number of dialysis sessions reported.", example="23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-CLAIM-NUM-DIALYSIS-SESSIONS", value="PIC 9(02)")})})
    private @Max(value=99L) @Min(value=0L) @NotNull Integer dialysisSessionCount;
    @Schema(example="2020-05-13", format="yyyy-MM-dd", description="The date dialysis was started.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DIALYSIS-START-DATE", value="B-DIALYSIS-START-DT-CCYY        PIC 9(04)\"\n+ \"B-DIALYSIS-START-DT-MM          PIC 9(02)\"\n+ \"B-DIALYSIS-START-DT-DD          PIC 9(02)", parseValue=true)})})
    @StrictLocalDate
    private LocalDate dialysisStartDate;
    @NotNull
    @Schema(example="2020-05-13", format="yyyy-MM-dd", description="The patient's date of birth.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DOB-DATE", value="B-THRU-CCYY        PIC 9(04)\"\n+ \"B-THRU-MM          PIC 9(02)\"\n+ \"B-THRU-DD          PIC 9(02)", parseValue=true)})})
    @StrictLocalDate
    private LocalDate patientDateOfBirth;
    @BigDecimalScale
    @DecimalMax(value="9999999.99")
    @DecimalMin(value="0")
    @Digits(integer=7, fraction=2)
    @Schema(description="The patient height in centimeters.", example="74.23", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-PATIENT-HGT", value="PIC 9(07)V9(02)"), @ExtensionProperty(name="B-PATIENT-HEIGHT", value="REDEFINES  B-PATIENT-WGT PIC 9(09)")})})
    private @DecimalMax(value="9999999.99") @DecimalMin(value="0") @Digits(integer=7, fraction=2) BigDecimal patientHeight;
    @BigDecimalScale
    @DecimalMax(value="9999999.99")
    @DecimalMin(value="0")
    @Digits(integer=7, fraction=2)
    @Schema(description="The patient weight in kilograms.", example="157.09", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-PATIENT-WGT", value="PIC 9(07)V9(02)"), @ExtensionProperty(name="B-PATIENT-WEIGHT", value="REDEFINES  B-PATIENT-WGT: PIC 9(09)")})})
    private @DecimalMax(value="9999999.99") @DecimalMin(value="0") @Digits(integer=7, fraction=2) BigDecimal patientWeight;
    @DecimalMax(value="1.0800")
    @DecimalMin(value="0.0000")
    @Digits(integer=1, fraction=4)
    @Schema(example="1.0700", description="The Performance Payment Adjustment (PPA) percent applied to the ESRD Treatment Choice (ETC) calculation.")
    private @DecimalMax(value="1.0800") @DecimalMin(value="0.0000") @Digits(integer=1, fraction=4) BigDecimal ppaAdjustmentPercent;
    @NotNull
    @Pattern(regexp="\\d{4}", message="must be four digits")
    @Schema(description="The associated revenue code.", example="0841", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-REV-CODE", value="B-REV-CODE3 PIC X(03)\nFILLER PIC X(01)")})})
    private @NotNull @Pattern(regexp="\\d{4}", message="must be four digits") String revenueCode;
    @NotNull
    @Schema(example="2020-05-13", format="yyyy-MM-dd", description="The date of service for the claim line item.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-LINE-ITEM-DATE-SERVICE", value="B-LINE-ITEM-DATE-SERVICE        PIC 9(04)\"\n+ \"B-LINE-ITEM-DT-SVC-MM          PIC 9(02)\"\n+ \"B-LINE-ITEM-DT-SVC-DD          PIC 9(02)", parseValue=true)})})
    @StrictLocalDate
    private LocalDate serviceDate;
    @NotNull
    @Schema(example="2020-05-13", format="yyyy-MM-dd", description="The end date of service.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-THRU-DATE", value="B-THRU-CCYY        PIC 9(04)\"\n+ \"B-THRU-MM          PIC 9(02)\"\n+ \"B-THRU-DD          PIC 9(02)", parseValue=true)})})
    @StrictLocalDate
    private LocalDate serviceThroughDate;
    @BigDecimalScale
    @DecimalMax(value="999999999.99")
    @DecimalMin(value="0")
    @Digits(integer=9, fraction=2)
    @Schema(description="The total price separately-billable outlier.", example="2354.98", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-TOT-PRICE-SB-OUTLIER", value="PIC 9(07)V9(02)")})})
    private @DecimalMax(value="999999999.99") @DecimalMin(value="0") @Digits(integer=9, fraction=2) BigDecimal totalPriceSeparatelyBillableOutlier;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="9999999.9999")
    @DecimalMin(value="0")
    @Digits(integer=7, fraction=4)
    @Schema(description="The total Transitional Drug Add-on Payment Adjustment (TDAPA) amount; corresponds to payer-only value code 'Q8'.", example="2354.9812", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-PAYER-ONLY-VC-Q8", value="PIC 9(07)V9(04)")})})
    private @DecimalMax(value="9999999.9999") @DecimalMin(value="0") @Digits(integer=7, fraction=4) BigDecimal totalTdapaAmountQ8;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="9999999.9999")
    @DecimalMin(value="0")
    @Digits(integer=7, fraction=4)
    @Schema(description="The total Transitional Add-on Payment Adjustment for New and Innovative Equipment and Supplies (TPNIES) amount; corresponds to payer-only value code 'QG\u2019.", example="4853.3195", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-PAYER-ONLY-VC-QG-AMT", value="PIC 9(07)V9(04)")})})
    private @DecimalMax(value="9999999.9999") @DecimalMin(value="0") @Digits(integer=7, fraction=4) BigDecimal totalTpniesAmountQg;
    @BigDecimalScale(scale=4)
    @DecimalMax(value="9999999.9999")
    @DecimalMin(value="0")
    @Digits(integer=7, fraction=4)
    @Schema(description="The total Transitional Add-on Payment Adjustment for New and Innovative Equipment and Supplies (TPNIES) amount for capital-related assets (CRA); corresponds to payer-only value code 'QH\u2019.", example="2354.9812", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-PAYER-ONLY-VC-QH-AMT", value="PIC 9(07)V9(04)")})})
    private @DecimalMax(value="9999999.9999") @DecimalMin(value="0") @Digits(integer=7, fraction=4) BigDecimal totalTpniesCraAmountQh;
    @Pattern(regexp="^[HPB\\s]$", message="must be one of 'H', 'P', 'B', or ' '")
    @Schema(example="H", description="Flag that indicates the ESRD Treatment Choice (ETC) that applies.")
    private @Pattern(regexp="^[HPB\\s]$", message="must be one of 'H', 'P', 'B', or ' '") String treatmentChoicesIndicator;

    @Generated
    public ComorbidityData getComorbidities() {
        return this.comorbidities;
    }

    @Generated
    public List<@Pattern(regexp="\\d{2}", message="must be two digits") String> getConditionCodes() {
        return this.conditionCodes;
    }

    @Generated
    public List<@Pattern(regexp="\\d{2}", message="must be two digits") String> getDemoCodes() {
        return this.demoCodes;
    }

    @Generated
    public Integer getDialysisSessionCount() {
        return this.dialysisSessionCount;
    }

    @Generated
    public LocalDate getDialysisStartDate() {
        return this.dialysisStartDate;
    }

    @Generated
    public LocalDate getPatientDateOfBirth() {
        return this.patientDateOfBirth;
    }

    @Generated
    public BigDecimal getPatientHeight() {
        return this.patientHeight;
    }

    @Generated
    public BigDecimal getPatientWeight() {
        return this.patientWeight;
    }

    @Generated
    public BigDecimal getPpaAdjustmentPercent() {
        return this.ppaAdjustmentPercent;
    }

    @Generated
    public String getRevenueCode() {
        return this.revenueCode;
    }

    @Generated
    public LocalDate getServiceDate() {
        return this.serviceDate;
    }

    @Generated
    public LocalDate getServiceThroughDate() {
        return this.serviceThroughDate;
    }

    @Generated
    public BigDecimal getTotalPriceSeparatelyBillableOutlier() {
        return this.totalPriceSeparatelyBillableOutlier;
    }

    @Generated
    public BigDecimal getTotalTdapaAmountQ8() {
        return this.totalTdapaAmountQ8;
    }

    @Generated
    public BigDecimal getTotalTpniesAmountQg() {
        return this.totalTpniesAmountQg;
    }

    @Generated
    public BigDecimal getTotalTpniesCraAmountQh() {
        return this.totalTpniesCraAmountQh;
    }

    @Generated
    public String getTreatmentChoicesIndicator() {
        return this.treatmentChoicesIndicator;
    }

    @Generated
    public void setComorbidities(ComorbidityData comorbidities) {
        this.comorbidities = comorbidities;
    }

    @Generated
    public void setConditionCodes(List<@Pattern(regexp="\\d{2}", message="must be two digits") String> conditionCodes) {
        this.conditionCodes = conditionCodes;
    }

    @Generated
    public void setDemoCodes(List<@Pattern(regexp="\\d{2}", message="must be two digits") String> demoCodes) {
        this.demoCodes = demoCodes;
    }

    @Generated
    public void setDialysisSessionCount(Integer dialysisSessionCount) {
        this.dialysisSessionCount = dialysisSessionCount;
    }

    @Generated
    public void setDialysisStartDate(LocalDate dialysisStartDate) {
        this.dialysisStartDate = dialysisStartDate;
    }

    @Generated
    public void setPatientDateOfBirth(LocalDate patientDateOfBirth) {
        this.patientDateOfBirth = patientDateOfBirth;
    }

    @Generated
    public void setPatientHeight(BigDecimal patientHeight) {
        this.patientHeight = patientHeight;
    }

    @Generated
    public void setPatientWeight(BigDecimal patientWeight) {
        this.patientWeight = patientWeight;
    }

    @Generated
    public void setPpaAdjustmentPercent(BigDecimal ppaAdjustmentPercent) {
        this.ppaAdjustmentPercent = ppaAdjustmentPercent;
    }

    @Generated
    public void setRevenueCode(String revenueCode) {
        this.revenueCode = revenueCode;
    }

    @Generated
    public void setServiceDate(LocalDate serviceDate) {
        this.serviceDate = serviceDate;
    }

    @Generated
    public void setServiceThroughDate(LocalDate serviceThroughDate) {
        this.serviceThroughDate = serviceThroughDate;
    }

    @Generated
    public void setTotalPriceSeparatelyBillableOutlier(BigDecimal totalPriceSeparatelyBillableOutlier) {
        this.totalPriceSeparatelyBillableOutlier = totalPriceSeparatelyBillableOutlier;
    }

    @Generated
    public void setTotalTdapaAmountQ8(BigDecimal totalTdapaAmountQ8) {
        this.totalTdapaAmountQ8 = totalTdapaAmountQ8;
    }

    @Generated
    public void setTotalTpniesAmountQg(BigDecimal totalTpniesAmountQg) {
        this.totalTpniesAmountQg = totalTpniesAmountQg;
    }

    @Generated
    public void setTotalTpniesCraAmountQh(BigDecimal totalTpniesCraAmountQh) {
        this.totalTpniesCraAmountQh = totalTpniesCraAmountQh;
    }

    @Generated
    public void setTreatmentChoicesIndicator(String treatmentChoicesIndicator) {
        this.treatmentChoicesIndicator = treatmentChoicesIndicator;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EsrdClaimData)) {
            return false;
        }
        EsrdClaimData other = (EsrdClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$dialysisSessionCount = this.getDialysisSessionCount();
        Integer other$dialysisSessionCount = other.getDialysisSessionCount();
        if (this$dialysisSessionCount == null ? other$dialysisSessionCount != null : !((Object)this$dialysisSessionCount).equals(other$dialysisSessionCount)) {
            return false;
        }
        ComorbidityData this$comorbidities = this.getComorbidities();
        ComorbidityData other$comorbidities = other.getComorbidities();
        if (this$comorbidities == null ? other$comorbidities != null : !((Object)this$comorbidities).equals(other$comorbidities)) {
            return false;
        }
        List<String> this$conditionCodes = this.getConditionCodes();
        List<String> other$conditionCodes = other.getConditionCodes();
        if (this$conditionCodes == null ? other$conditionCodes != null : !((Object)this$conditionCodes).equals(other$conditionCodes)) {
            return false;
        }
        List<String> this$demoCodes = this.getDemoCodes();
        List<String> other$demoCodes = other.getDemoCodes();
        if (this$demoCodes == null ? other$demoCodes != null : !((Object)this$demoCodes).equals(other$demoCodes)) {
            return false;
        }
        LocalDate this$dialysisStartDate = this.getDialysisStartDate();
        LocalDate other$dialysisStartDate = other.getDialysisStartDate();
        if (this$dialysisStartDate == null ? other$dialysisStartDate != null : !((Object)this$dialysisStartDate).equals(other$dialysisStartDate)) {
            return false;
        }
        LocalDate this$patientDateOfBirth = this.getPatientDateOfBirth();
        LocalDate other$patientDateOfBirth = other.getPatientDateOfBirth();
        if (this$patientDateOfBirth == null ? other$patientDateOfBirth != null : !((Object)this$patientDateOfBirth).equals(other$patientDateOfBirth)) {
            return false;
        }
        BigDecimal this$patientHeight = this.getPatientHeight();
        BigDecimal other$patientHeight = other.getPatientHeight();
        if (this$patientHeight == null ? other$patientHeight != null : !((Object)this$patientHeight).equals(other$patientHeight)) {
            return false;
        }
        BigDecimal this$patientWeight = this.getPatientWeight();
        BigDecimal other$patientWeight = other.getPatientWeight();
        if (this$patientWeight == null ? other$patientWeight != null : !((Object)this$patientWeight).equals(other$patientWeight)) {
            return false;
        }
        BigDecimal this$ppaAdjustmentPercent = this.getPpaAdjustmentPercent();
        BigDecimal other$ppaAdjustmentPercent = other.getPpaAdjustmentPercent();
        if (this$ppaAdjustmentPercent == null ? other$ppaAdjustmentPercent != null : !((Object)this$ppaAdjustmentPercent).equals(other$ppaAdjustmentPercent)) {
            return false;
        }
        String this$revenueCode = this.getRevenueCode();
        String other$revenueCode = other.getRevenueCode();
        if (this$revenueCode == null ? other$revenueCode != null : !this$revenueCode.equals(other$revenueCode)) {
            return false;
        }
        LocalDate this$serviceDate = this.getServiceDate();
        LocalDate other$serviceDate = other.getServiceDate();
        if (this$serviceDate == null ? other$serviceDate != null : !((Object)this$serviceDate).equals(other$serviceDate)) {
            return false;
        }
        LocalDate this$serviceThroughDate = this.getServiceThroughDate();
        LocalDate other$serviceThroughDate = other.getServiceThroughDate();
        if (this$serviceThroughDate == null ? other$serviceThroughDate != null : !((Object)this$serviceThroughDate).equals(other$serviceThroughDate)) {
            return false;
        }
        BigDecimal this$totalPriceSeparatelyBillableOutlier = this.getTotalPriceSeparatelyBillableOutlier();
        BigDecimal other$totalPriceSeparatelyBillableOutlier = other.getTotalPriceSeparatelyBillableOutlier();
        if (this$totalPriceSeparatelyBillableOutlier == null ? other$totalPriceSeparatelyBillableOutlier != null : !((Object)this$totalPriceSeparatelyBillableOutlier).equals(other$totalPriceSeparatelyBillableOutlier)) {
            return false;
        }
        BigDecimal this$totalTdapaAmountQ8 = this.getTotalTdapaAmountQ8();
        BigDecimal other$totalTdapaAmountQ8 = other.getTotalTdapaAmountQ8();
        if (this$totalTdapaAmountQ8 == null ? other$totalTdapaAmountQ8 != null : !((Object)this$totalTdapaAmountQ8).equals(other$totalTdapaAmountQ8)) {
            return false;
        }
        BigDecimal this$totalTpniesAmountQg = this.getTotalTpniesAmountQg();
        BigDecimal other$totalTpniesAmountQg = other.getTotalTpniesAmountQg();
        if (this$totalTpniesAmountQg == null ? other$totalTpniesAmountQg != null : !((Object)this$totalTpniesAmountQg).equals(other$totalTpniesAmountQg)) {
            return false;
        }
        BigDecimal this$totalTpniesCraAmountQh = this.getTotalTpniesCraAmountQh();
        BigDecimal other$totalTpniesCraAmountQh = other.getTotalTpniesCraAmountQh();
        if (this$totalTpniesCraAmountQh == null ? other$totalTpniesCraAmountQh != null : !((Object)this$totalTpniesCraAmountQh).equals(other$totalTpniesCraAmountQh)) {
            return false;
        }
        String this$treatmentChoicesIndicator = this.getTreatmentChoicesIndicator();
        String other$treatmentChoicesIndicator = other.getTreatmentChoicesIndicator();
        return !(this$treatmentChoicesIndicator == null ? other$treatmentChoicesIndicator != null : !this$treatmentChoicesIndicator.equals(other$treatmentChoicesIndicator));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EsrdClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $dialysisSessionCount = this.getDialysisSessionCount();
        result = result * 59 + ($dialysisSessionCount == null ? 43 : ((Object)$dialysisSessionCount).hashCode());
        ComorbidityData $comorbidities = this.getComorbidities();
        result = result * 59 + ($comorbidities == null ? 43 : ((Object)$comorbidities).hashCode());
        List<String> $conditionCodes = this.getConditionCodes();
        result = result * 59 + ($conditionCodes == null ? 43 : ((Object)$conditionCodes).hashCode());
        List<String> $demoCodes = this.getDemoCodes();
        result = result * 59 + ($demoCodes == null ? 43 : ((Object)$demoCodes).hashCode());
        LocalDate $dialysisStartDate = this.getDialysisStartDate();
        result = result * 59 + ($dialysisStartDate == null ? 43 : ((Object)$dialysisStartDate).hashCode());
        LocalDate $patientDateOfBirth = this.getPatientDateOfBirth();
        result = result * 59 + ($patientDateOfBirth == null ? 43 : ((Object)$patientDateOfBirth).hashCode());
        BigDecimal $patientHeight = this.getPatientHeight();
        result = result * 59 + ($patientHeight == null ? 43 : ((Object)$patientHeight).hashCode());
        BigDecimal $patientWeight = this.getPatientWeight();
        result = result * 59 + ($patientWeight == null ? 43 : ((Object)$patientWeight).hashCode());
        BigDecimal $ppaAdjustmentPercent = this.getPpaAdjustmentPercent();
        result = result * 59 + ($ppaAdjustmentPercent == null ? 43 : ((Object)$ppaAdjustmentPercent).hashCode());
        String $revenueCode = this.getRevenueCode();
        result = result * 59 + ($revenueCode == null ? 43 : $revenueCode.hashCode());
        LocalDate $serviceDate = this.getServiceDate();
        result = result * 59 + ($serviceDate == null ? 43 : ((Object)$serviceDate).hashCode());
        LocalDate $serviceThroughDate = this.getServiceThroughDate();
        result = result * 59 + ($serviceThroughDate == null ? 43 : ((Object)$serviceThroughDate).hashCode());
        BigDecimal $totalPriceSeparatelyBillableOutlier = this.getTotalPriceSeparatelyBillableOutlier();
        result = result * 59 + ($totalPriceSeparatelyBillableOutlier == null ? 43 : ((Object)$totalPriceSeparatelyBillableOutlier).hashCode());
        BigDecimal $totalTdapaAmountQ8 = this.getTotalTdapaAmountQ8();
        result = result * 59 + ($totalTdapaAmountQ8 == null ? 43 : ((Object)$totalTdapaAmountQ8).hashCode());
        BigDecimal $totalTpniesAmountQg = this.getTotalTpniesAmountQg();
        result = result * 59 + ($totalTpniesAmountQg == null ? 43 : ((Object)$totalTpniesAmountQg).hashCode());
        BigDecimal $totalTpniesCraAmountQh = this.getTotalTpniesCraAmountQh();
        result = result * 59 + ($totalTpniesCraAmountQh == null ? 43 : ((Object)$totalTpniesCraAmountQh).hashCode());
        String $treatmentChoicesIndicator = this.getTreatmentChoicesIndicator();
        result = result * 59 + ($treatmentChoicesIndicator == null ? 43 : $treatmentChoicesIndicator.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "EsrdClaimData(comorbidities=" + this.getComorbidities() + ", conditionCodes=" + this.getConditionCodes() + ", demoCodes=" + this.getDemoCodes() + ", dialysisSessionCount=" + this.getDialysisSessionCount() + ", dialysisStartDate=" + this.getDialysisStartDate() + ", patientDateOfBirth=" + this.getPatientDateOfBirth() + ", patientHeight=" + this.getPatientHeight() + ", patientWeight=" + this.getPatientWeight() + ", ppaAdjustmentPercent=" + this.getPpaAdjustmentPercent() + ", revenueCode=" + this.getRevenueCode() + ", serviceDate=" + this.getServiceDate() + ", serviceThroughDate=" + this.getServiceThroughDate() + ", totalPriceSeparatelyBillableOutlier=" + this.getTotalPriceSeparatelyBillableOutlier() + ", totalTdapaAmountQ8=" + this.getTotalTdapaAmountQ8() + ", totalTpniesAmountQg=" + this.getTotalTpniesAmountQg() + ", totalTpniesCraAmountQh=" + this.getTotalTpniesCraAmountQh() + ", treatmentChoicesIndicator=" + this.getTreatmentChoicesIndicator() + ")";
    }

    @Generated
    public EsrdClaimData() {
    }
}

