/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;
import java.math.RoundingMode;

public class CalculateBundledWageAdjustedRate
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public boolean shouldExecute(EsrdPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ReturnCode.CALCULATION_STARTED_00);
    }

    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        calculationContext.setBundledNationalLaborAmount(calculationContext.getBundledBasePaymentRate().multiply(calculationContext.getBundledNationalLaborPercentage()).multiply(calculationContext.getBundledWageIndex()).setScale(2, RoundingMode.HALF_DOWN));
        calculationContext.setBundledNationalNonLaborAmount(calculationContext.getBundledBasePaymentRate().multiply(calculationContext.getBundledNationalNonLaborPercent()).setScale(2, RoundingMode.HALF_DOWN));
        calculationContext.setBundledBaseWageAmount(calculationContext.getBundledNationalLaborAmount().add(calculationContext.getBundledNationalNonLaborAmount()).setScale(4, RoundingMode.HALF_DOWN));
    }
}

