/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;

public class ComputePatientAge
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        calculationContext.setPatientAge(claimData.getServiceThroughDate().getYear() - claimData.getPatientDateOfBirth().getYear());
        if (claimData.getPatientDateOfBirth().getMonthValue() > claimData.getServiceThroughDate().getMonthValue()) {
            calculationContext.setPatientAge(calculationContext.getPatientAge() - 1);
        }
        if (calculationContext.getPatientAge() < 18) {
            calculationContext.setPediatricClaim(true);
        }
    }
}

