/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.bundled_factors.outlier;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.BundledPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.PayerOnlyConditionCode;
import org.apache.commons.lang3.StringUtils;

public class SetSeparatelyBillableOutlierComorbiditiesMultiplier
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        BundledPaymentData bundledData = calculationContext.getBundledData();
        if (StringUtils.isEmpty(calculationContext.getCwfReturnCode())) {
            if (!calculationContext.isAdultPatient()) {
                calculationContext.setOutlierComorbidityMultiplier(EsrdPricerContext.DEFAULT_MULTIPLIER);
                bundledData.setComorbidityPaymentCode("10");
            } else if (BigDecimalUtils.equals(calculationContext.getBundledOnsetFactor(), calculationContext.getCaseMixOnsetLessThanOrEqualTo120Multiplier())) {
                calculationContext.setOutlierComorbidityMultiplier(EsrdPricerContext.DEFAULT_MULTIPLIER);
                bundledData.setComorbidityPaymentCode("10");
            } else {
                this.calculateOutlierComorbidityAdjustment(calculationContext);
            }
        } else {
            switch (calculationContext.getCwfReturnCode()) {
                case "10": {
                    calculationContext.setOutlierComorbidityMultiplier(EsrdPricerContext.DEFAULT_MULTIPLIER);
                    break;
                }
                case "20": {
                    calculationContext.setOutlierComorbidityMultiplier(calculationContext.getSeparatelyBillableGastrointestinalBleedMultiplier());
                    break;
                }
                case "40": {
                    calculationContext.setOutlierComorbidityMultiplier(calculationContext.getSeparatelyBillablePericarditisMultiplier());
                    break;
                }
            }
        }
    }

    protected void calculateOutlierComorbidityAdjustment(EsrdPricerContext calculationContext) {
        BundledPaymentData bundledData = calculationContext.getBundledData();
        calculationContext.setOutlierComorbidityMultiplier(EsrdPricerContext.DEFAULT_MULTIPLIER);
        for (String comorbidityCode : calculationContext.getComorbidityCodes()) {
            if (null == comorbidityCode) continue;
            this.processComorbidityCode(calculationContext, bundledData, comorbidityCode);
        }
    }

    protected void processComorbidityCode(EsrdPricerContext calculationContext, BundledPaymentData bundledData, String comorbidityCode) {
        PayerOnlyConditionCode payerOnlyConditionCode = PayerOnlyConditionCode.valueOf(comorbidityCode);
        switch (payerOnlyConditionCode) {
            case MA: {
                calculationContext.setOutlierComorbidityMultiplier(calculationContext.getSeparatelyBillableGastrointestinalBleedMultiplier());
                calculationContext.setAcuteComorbidityFound(true);
                break;
            }
            case MC: {
                if (!BigDecimalUtils.isGreaterThan(calculationContext.getSeparatelyBillablePericarditisMultiplier(), calculationContext.getOutlierComorbidityMultiplier())) break;
                calculationContext.setOutlierComorbidityMultiplier(calculationContext.getSeparatelyBillablePericarditisMultiplier());
                calculationContext.setAcuteComorbidityFound(true);
                break;
            }
            case MD: {
                if (!BigDecimalUtils.isGreaterThan(calculationContext.getSeparatelyBillableMyelodysplasticSyndromeMultiplier(), calculationContext.getOutlierComorbidityMultiplier())) break;
                calculationContext.setOutlierComorbidityMultiplier(calculationContext.getSeparatelyBillableMyelodysplasticSyndromeMultiplier());
                calculationContext.setChronicComorbidityFound(true);
                break;
            }
            case ME: {
                if (!BigDecimalUtils.isGreaterThan(calculationContext.getSeparatelyBillableSickleCellMultiplier(), calculationContext.getOutlierComorbidityMultiplier())) break;
                calculationContext.setOutlierComorbidityMultiplier(calculationContext.getSeparatelyBillableSickleCellMultiplier());
                calculationContext.setChronicComorbidityFound(true);
                break;
            }
        }
    }
}

