/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2025;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.AdditionalPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.BundledPaymentData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdPaymentData;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class MoveBaseResults2025
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData billingRecord = calculationContext.getClaimData();
        OutpatientProviderData providerData = calculationContext.getProviderData();
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        AdditionalPaymentData additionalPaymentData = paymentData.getAdditionalPaymentInformation();
        AdditionalPaymentData additionalPaymentInformation2011 = paymentData.getAdditionalPaymentInformation2011();
        paymentData.setFinalCbsa(providerData.getCbsaActualGeographicLocation());
        additionalPaymentData.setWageAdjustmentRate(BigDecimal.ZERO);
        additionalPaymentInformation2011.setWageAdjustmentRate(calculationContext.getBundledBaseWageAmount());
        additionalPaymentInformation2011.setNationalLaborPercent(calculationContext.getBundledNationalLaborPercentage());
        additionalPaymentInformation2011.setNationalNonLaborPercent(calculationContext.getBundledNationalNonLaborPercent());
        additionalPaymentData.setNationalLaborPercent(calculationContext.getNationalLaborPercent());
        additionalPaymentData.setNationalNonLaborPercent(calculationContext.getNationalNonLaborPercent());
        additionalPaymentData.setAgeAdjustmentFactor(BigDecimal.ZERO);
        additionalPaymentData.setBodySurfaceAreaFactor(BigDecimal.ZERO);
        additionalPaymentData.setBodyMassIndexFactor(BigDecimal.ZERO);
        additionalPaymentData.setBudgetNeutralityRate(EsrdPricerContext.CASE_MIX_BUDGET_NEUTRAL_FACTOR);
        additionalPaymentInformation2011.setAgeAdjustmentFactor(calculationContext.getBundledAgeAdjustmentFactor());
        additionalPaymentInformation2011.setBodySurfaceAreaFactor(calculationContext.getBundledBsaFactor());
        additionalPaymentInformation2011.setBodyMassIndexFactor(calculationContext.getBundledBmiFactor());
        additionalPaymentInformation2011.setBudgetNeutralityRate(EsrdPricerContext.TRANSITION_BUDGET_NEUTRAL_FACTOR);
        if (calculationContext.isEsrdHome74() && billingRecord.getDialysisSessionCount() != 0 && StringUtils.equalsAny(billingRecord.getRevenueCode(), "0841", "0851")) {
            calculationContext.setOutlierPayment(calculationContext.getOutlierPayment().divide(new BigDecimal(billingRecord.getDialysisSessionCount()), 4, RoundingMode.DOWN));
        }
        BundledPaymentData bundledPaymentData = calculationContext.getBundledData();
        bundledPaymentData.setBlendedCompositeRate(BigDecimal.ZERO);
        bundledPaymentData.setBlendedPaymentRate(BigDecimal.ZERO);
        bundledPaymentData.setBlendedOutlierRate(BigDecimal.ZERO);
        bundledPaymentData.setFullCompositeRate(BigDecimal.ZERO);
        bundledPaymentData.setFullPaymentRate(calculationContext.getFinalPaymentAmount().subtract(calculationContext.getNetworkReductionAmount()));
        paymentData.setTotalPayment(calculationContext.getFinalPaymentAmount());
        bundledPaymentData.setFullOutlierRate(calculationContext.getOutlierPayment().setScale(2, RoundingMode.DOWN));
        paymentData.setTdapaPaymentAdjustmentAmount(calculationContext.getTdapaPayment());
        paymentData.setTpniesPaymentAdjustmentAmount(calculationContext.getTpniesPayment());
        paymentData.setTpniesCraPaymentAdjustmentAmount(calculationContext.getCraTpniesPayment());
        paymentData.setNetworkReductionAmount(calculationContext.getNetworkReductionAmount());
        this.determineEtcAdjustmentAmount(calculationContext);
        this.determineLineItemAmounts(calculationContext);
        this.determineFinalAmounts(calculationContext);
    }

    protected void determineEtcAdjustmentAmount(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setPpaAdjustmentAmount(BigDecimal.ZERO);
        if (!calculationContext.isAki84()) {
            if (calculationContext.hasDemoCode("94")) {
                if (StringUtils.equalsAny(claimData.getTreatmentChoicesIndicator(), "H", " ")) {
                    paymentData.setPpaAdjustmentAmount(BigDecimal.ZERO);
                    paymentData.setAdjustedBaseWageBeforeEtcHdpaAmount(calculationContext.getFinalAmountWithoutEtc().multiply(calculationContext.getQipReduction()).setScale(2, RoundingMode.HALF_UP));
                } else if (StringUtils.equals(claimData.getTreatmentChoicesIndicator(), "P")) {
                    paymentData.setPpaAdjustmentAmount(claimData.getPpaAdjustmentPercent().subtract(BigDecimal.ONE).multiply(calculationContext.getBundledAdjustedBaseWageAmount()));
                    paymentData.setAdjustedBaseWageBeforeEtcHdpaAmount(BigDecimal.ZERO);
                } else if (StringUtils.equals(claimData.getTreatmentChoicesIndicator(), "B")) {
                    paymentData.setPpaAdjustmentAmount(claimData.getPpaAdjustmentPercent().subtract(BigDecimal.ONE).multiply(calculationContext.getBundledAdjustedBaseWageAmount()));
                    paymentData.setAdjustedBaseWageBeforeEtcHdpaAmount(calculationContext.getFinalAmountWithoutEtc().multiply(calculationContext.getQipReduction()).setScale(2, RoundingMode.HALF_UP));
                } else {
                    paymentData.setPpaAdjustmentAmount(BigDecimal.ZERO);
                    paymentData.setAdjustedBaseWageBeforeEtcHdpaAmount(BigDecimal.ZERO);
                }
            } else {
                paymentData.setPpaAdjustmentAmount(BigDecimal.ZERO);
                paymentData.setAdjustedBaseWageBeforeEtcHdpaAmount(BigDecimal.ZERO);
            }
        }
    }

    protected void determineLineItemAmounts(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        if (!calculationContext.isAki84() && calculationContext.hasDemoCode("94")) {
            paymentData.setPrePpaAdjustmentAmount(calculationContext.getFinalAmountWithoutEtc().multiply(calculationContext.getQipReduction()).add(calculationContext.getOutlierPayment().multiply(calculationContext.getQipReduction())).setScale(4, RoundingMode.HALF_UP));
            BigDecimal ppaAdjustmentAmountWithPerDiem = MoveBaseResults2025.getPpaAdjustmentWithPerDiem(calculationContext, claimData, paymentData);
            paymentData.setPostPpaAdjustmentAmount(paymentData.getPrePpaAdjustmentAmount().add(ppaAdjustmentAmountWithPerDiem.multiply(calculationContext.getQipReduction())));
        }
    }

    private static BigDecimal getPpaAdjustmentWithPerDiem(EsrdPricerContext calculationContext, EsrdClaimData claimData, EsrdPaymentData paymentData) {
        BigDecimal ppaAdjustmentAmountWithPerDiem = paymentData.getPpaAdjustmentAmount();
        if (StringUtils.equalsAny(claimData.getTreatmentChoicesIndicator(), "H", " ", "B")) {
            ppaAdjustmentAmountWithPerDiem = ppaAdjustmentAmountWithPerDiem.add(calculationContext.getEtcHdpaPercent().subtract(BigDecimal.ONE).multiply(calculationContext.getBundledAdjustedBaseWageAmount()));
        }
        if (calculationContext.isPerDiemClaim()) {
            ppaAdjustmentAmountWithPerDiem = ppaAdjustmentAmountWithPerDiem.multiply(new BigDecimal(3)).divide(new BigDecimal(7), 4, RoundingMode.HALF_UP);
        }
        return ppaAdjustmentAmountWithPerDiem;
    }

    protected void determineFinalAmounts(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        OutpatientProviderData providerData = calculationContext.getProviderData();
        BundledPaymentData bundledPaymentData = calculationContext.getBundledData();
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        if (!calculationContext.isAki84()) {
            BigDecimal ppaAdjustmentAmountWithPerDiem = MoveBaseResults2025.getPpaAdjustmentWithPerDiem(calculationContext, claimData, paymentData);
            bundledPaymentData.setFullPaymentRate(BigDecimalUtils.defaultValue(calculationContext.getFinalAmountWithoutEtc()).setScale(2, RoundingMode.DOWN).add(ppaAdjustmentAmountWithPerDiem).multiply(calculationContext.getQipReduction()).subtract(calculationContext.getNetworkReductionAmount()));
            if (null != providerData.getHospitalQualityIndicator()) {
                bundledPaymentData.setBlendedCompositeRate(BigDecimalUtils.defaultValue(bundledPaymentData.getBlendedCompositeRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
                bundledPaymentData.setFullCompositeRate(BigDecimalUtils.defaultValue(bundledPaymentData.getFullCompositeRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
                bundledPaymentData.setBlendedPaymentRate(BigDecimalUtils.defaultValue(bundledPaymentData.getBlendedPaymentRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
                bundledPaymentData.setBlendedOutlierRate(BigDecimalUtils.defaultValue(bundledPaymentData.getBlendedOutlierRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
                bundledPaymentData.setFullOutlierRate(BigDecimalUtils.defaultValue(bundledPaymentData.getFullOutlierRate()).setScale(2, RoundingMode.DOWN).multiply(calculationContext.getQipReduction()));
            }
            if (calculationContext.isPerDiemClaim()) {
                paymentData.setPpaAdjustmentAmount(paymentData.getPpaAdjustmentAmount().multiply(new BigDecimal(3)).divide(new BigDecimal(7), 4, RoundingMode.HALF_UP));
            }
        }
    }
}

