/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.validation;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;
import java.math.BigDecimal;

public class ValidateMaximumHeight
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    private static final BigDecimal MAXIMUM_HEIGHT = new BigDecimal("300.00");

    @Override
    public boolean shouldExecute(EsrdPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ReturnCode.CALCULATION_STARTED_00);
    }

    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (!calculationContext.isAki84() && BigDecimalUtils.isGreaterThan(claimData.getPatientHeight(), MAXIMUM_HEIGHT)) {
            calculationContext.applyReturnCode(ReturnCode.HEIGHT_OUT_OF_RANGE_71);
        }
    }
}

