/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.wage_index;

import gov.cms.fiss.pricers.common.api.OutpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class ApplySpecialWageIndex
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public boolean shouldExecute(EsrdPricerContext calculationContext) {
        return StringUtils.equals("1", calculationContext.getProviderData().getSpecialPaymentIndicator());
    }

    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        OutpatientProviderData providerData = calculationContext.getProviderData();
        BigDecimal specialWageIndex = providerData.getSpecialWageIndex();
        if (null == specialWageIndex) {
            calculationContext.applyReturnCode(ReturnCode.CBSA_NOT_FOUND_60);
            calculationContext.setCalculationCompleted();
        } else {
            calculationContext.setBundledWageIndex(specialWageIndex);
        }
    }
}

