/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.response;

import java.util.Objects;
import javax.annotation.Nonnull;

public final class HealthResponse {
    private final boolean healthy;
    @Nonnull
    private final String message;
    @Nonnull
    private final String contentType;
    private final int status;

    public HealthResponse(boolean healthy, @Nonnull String message, @Nonnull String contentType, int status) {
        this.healthy = healthy;
        this.message = Objects.requireNonNull(message);
        this.contentType = Objects.requireNonNull(contentType);
        this.status = status;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HealthResponse)) {
            return false;
        }
        HealthResponse that = (HealthResponse)o;
        return this.healthy == that.healthy && this.status == that.status && this.message.equals(that.message) && this.contentType.equals(that.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.healthy, this.message, this.contentType, this.status);
    }

    public String toString() {
        return "HealthResponse{healthy=" + this.healthy + ", message='" + this.message + '\'' + ", contentType='" + this.contentType + '\'' + ", status=" + this.status + '}';
    }
}

