/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import io.dropwizard.jetty.LocalIpFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
public class NetUtil {
    public static final int DEFAULT_TCP_BACKLOG_WINDOWS = 200;
    public static final int DEFAULT_TCP_BACKLOG_LINUX = 128;
    public static final String TCP_BACKLOG_SETTING_LOCATION = "/proc/sys/net/core/somaxconn";
    private static final AtomicReference<LocalIpFilter> LOCAL_IP_FILTER = new AtomicReference<LocalIpFilter>((nif, adr) -> adr != null && !adr.isLoopbackAddress() && (nif.isPointToPoint() || !adr.isLinkLocalAddress()));

    public static int getTcpBacklog() {
        return NetUtil.getTcpBacklog(NetUtil.getDefaultTcpBacklog());
    }

    public static int getTcpBacklog(int tcpBacklog) {
        return AccessController.doPrivileged(() -> {
            File file = new File(TCP_BACKLOG_SETTING_LOCATION);
            try (BufferedReader in = new BufferedReader(new FileReader(file));){
                Integer n = Integer.parseInt(in.readLine().trim());
                return n;
            }
            catch (IOException | NullPointerException | NumberFormatException | SecurityException e) {
                return tcpBacklog;
            }
        });
    }

    public static boolean isWindows() {
        return System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
    }

    public static int getDefaultTcpBacklog() {
        return NetUtil.isWindows() ? 200 : 128;
    }

    public static void setLocalIpFilter(LocalIpFilter newLocalIpFilter) {
        Objects.requireNonNull(newLocalIpFilter);
        LOCAL_IP_FILTER.set(newLocalIpFilter);
    }

    public static LocalIpFilter getLocalIpFilter() {
        return Objects.requireNonNull(LOCAL_IP_FILTER.get());
    }

    public static Collection<InetAddress> getAllLocalIPs() throws SocketException {
        ArrayList<InetAddress> listAdr = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        if (nifs == null) {
            return listAdr;
        }
        while (nifs.hasMoreElements()) {
            NetworkInterface nif = nifs.nextElement();
            Enumeration<InetAddress> adrs = nif.getInetAddresses();
            while (adrs.hasMoreElements()) {
                InetAddress adr = adrs.nextElement();
                if (!NetUtil.getLocalIpFilter().use(nif, adr)) continue;
                listAdr.add(adr);
            }
        }
        return listAdr;
    }
}

