/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;

public class SLF4JLocationAwareLog
implements Log,
Serializable {
    private static final long serialVersionUID = -2379157579039314822L;
    protected String name;
    private transient LocationAwareLogger logger;
    private static final String FQCN = SLF4JLocationAwareLog.class.getName();

    SLF4JLocationAwareLog(LocationAwareLogger logger2) {
        this.logger = logger2;
        this.name = logger2.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.logger.log(null, FQCN, 0, String.valueOf(message), null, null);
        }
    }

    public void trace(Object message, Throwable t2) {
        if (this.isTraceEnabled()) {
            this.logger.log(null, FQCN, 0, String.valueOf(message), null, t2);
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.logger.log(null, FQCN, 10, String.valueOf(message), null, null);
        }
    }

    public void debug(Object message, Throwable t2) {
        if (this.isDebugEnabled()) {
            this.logger.log(null, FQCN, 10, String.valueOf(message), null, t2);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.logger.log(null, FQCN, 20, String.valueOf(message), null, null);
        }
    }

    public void info(Object message, Throwable t2) {
        if (this.isInfoEnabled()) {
            this.logger.log(null, FQCN, 20, String.valueOf(message), null, t2);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.logger.log(null, FQCN, 30, String.valueOf(message), null, null);
        }
    }

    public void warn(Object message, Throwable t2) {
        if (this.isWarnEnabled()) {
            this.logger.log(null, FQCN, 30, String.valueOf(message), null, t2);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.logger.log(null, FQCN, 40, String.valueOf(message), null, null);
        }
    }

    public void error(Object message, Throwable t2) {
        if (this.isErrorEnabled()) {
            this.logger.log(null, FQCN, 40, String.valueOf(message), null, t2);
        }
    }

    public void fatal(Object message) {
        if (this.isErrorEnabled()) {
            this.logger.log(null, FQCN, 40, String.valueOf(message), null, null);
        }
    }

    public void fatal(Object message, Throwable t2) {
        if (this.isErrorEnabled()) {
            this.logger.log(null, FQCN, 40, String.valueOf(message), null, t2);
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        Logger logger2 = LoggerFactory.getLogger(this.name);
        return new SLF4JLocationAwareLog((LocationAwareLogger)logger2);
    }
}

