// Generated by delombok at Thu May 22 14:06:18 UTC 2025
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;

@Schema(description = "The additional pricing data related to the processed claim.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DATA-ALL", value = "<structure>")})})
public class AdditionalPricingData {
  @BigDecimalScale(scale = 4)
  @Schema(description = "The adjusted base wage amount for the bundle.", example = "5431.3928", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BUN-ADJUSTED-BASE-WAGE-AMT", value = "PIC 9(07)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal bundledAdjustedBaseWageAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999.99")
  @Digits(integer = 4, fraction = 2)
  @Schema(description = "The bundle base payment rate.", example = "1238.45", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-BUN-BASE-PMT-RATE", value = "PIC 9(04)V9(02)")})})
  @FixedValue
  private BigDecimal bundledBasePaymentRate = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "The wage-adjustment training amount for the bundle.", example = "138768.8498", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-BUN-WAGE-ADJ-TRAIN-AMT", value = "PIC 9(07)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal bundledWageAdjustmentTrainingAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The case-mix adjustment for body-mass index (BMI) when the value is less " + "than than 18.5.", example = "1.017", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CM-BMI-LT-18-5", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal caseMixBmiUnderEighteenPointFiveMultiplier = BigDecimal.ZERO.setScale(3, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The case-mix body-surface area (BSA) multiplier.", example = "1.032", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CM-BSA", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal caseMixBsaMultiplier = BigDecimal.ZERO.setScale(3, RoundingMode.HALF_UP);
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9999.99")
  @Digits(integer = 4, fraction = 2)
  @Schema(example = "1238.45", description = "The compensation payment rate.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "COM-PAYMENT-RATE", value = "PIC 9(04)V9(02)")})})
  @FixedValue
  private BigDecimal compositePaymentRate = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The composite-rate multiplier for body-mass index (BMI).", example = "1.112", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "CR-BMI-MULTIPLIER", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal compositeRateBmiMultiplier = BigDecimal.ZERO.setScale(3, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The composite-rate multiplier for body-surface area (BSA).", example = "0.856", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "CR-BSA-MULTIPLIER", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal compositeRateBsaMultiplier = BigDecimal.ZERO.setScale(3, RoundingMode.HALF_UP);
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9.99")
  @Digits(integer = 1, fraction = 2)
  @Schema(description = "The adjustment amount for ESRD drugs and biologicals currently paid under Part-D.", example = "0.49", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "A-49-CENT-DRUG-ADJ", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal drugAndBiologicalAdjustmentAmount = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "The outlier case-mix predicted Medicare-allowable payment (MAP) amount.", example = "4839.1253", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-CASE-MIX-PREDICTED-MAP", value = "PIC 9(04)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal outlierCaseMixPredictedMapAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "The outlier amount for hemo-equivalent dialysis sessions.", example = "12.3845", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-HEMO-EQUIV-DIAL-SESSIONS", value = "PIC 9(02)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal outlierHemoEquivalentDialysisSessionsAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 3)
  @DecimalMin("0")
  @DecimalMax("9.999")
  @Digits(integer = 1, fraction = 3)
  @Schema(description = "The outlier amount for separately-billable body-surface area (BSA).", example = "1.123", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-SB-BSA", value = "PIC 9(01)V9(03)")})})
  @FixedValue
  private BigDecimal outlierSeparatelyBillableBsaAmount = BigDecimal.ZERO.setScale(3, RoundingMode.HALF_UP);
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("99.99")
  @Digits(integer = 2, fraction = 2)
  @Schema(description = "The training add-on payment amount.", example = "18.45", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-TRAINING-ADD-ON-PMT-AMT", value = "PIC 9(02)V9(02)")})})
  @FixedValue
  private BigDecimal trainingAddOnPaymentAmount = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledAdjustedBaseWageAmount() {
    return this.bundledAdjustedBaseWageAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledBasePaymentRate() {
    return this.bundledBasePaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBundledWageAdjustmentTrainingAmount() {
    return this.bundledWageAdjustmentTrainingAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCaseMixBmiUnderEighteenPointFiveMultiplier() {
    return this.caseMixBmiUnderEighteenPointFiveMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCaseMixBsaMultiplier() {
    return this.caseMixBsaMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCompositePaymentRate() {
    return this.compositePaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCompositeRateBmiMultiplier() {
    return this.compositeRateBmiMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCompositeRateBsaMultiplier() {
    return this.compositeRateBsaMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDrugAndBiologicalAdjustmentAmount() {
    return this.drugAndBiologicalAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierCaseMixPredictedMapAmount() {
    return this.outlierCaseMixPredictedMapAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierHemoEquivalentDialysisSessionsAmount() {
    return this.outlierHemoEquivalentDialysisSessionsAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierSeparatelyBillableBsaAmount() {
    return this.outlierSeparatelyBillableBsaAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTrainingAddOnPaymentAmount() {
    return this.trainingAddOnPaymentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledAdjustedBaseWageAmount(final BigDecimal bundledAdjustedBaseWageAmount) {
    this.bundledAdjustedBaseWageAmount = bundledAdjustedBaseWageAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledBasePaymentRate(final BigDecimal bundledBasePaymentRate) {
    this.bundledBasePaymentRate = bundledBasePaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledWageAdjustmentTrainingAmount(final BigDecimal bundledWageAdjustmentTrainingAmount) {
    this.bundledWageAdjustmentTrainingAmount = bundledWageAdjustmentTrainingAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaseMixBmiUnderEighteenPointFiveMultiplier(final BigDecimal caseMixBmiUnderEighteenPointFiveMultiplier) {
    this.caseMixBmiUnderEighteenPointFiveMultiplier = caseMixBmiUnderEighteenPointFiveMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaseMixBsaMultiplier(final BigDecimal caseMixBsaMultiplier) {
    this.caseMixBsaMultiplier = caseMixBsaMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCompositePaymentRate(final BigDecimal compositePaymentRate) {
    this.compositePaymentRate = compositePaymentRate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCompositeRateBmiMultiplier(final BigDecimal compositeRateBmiMultiplier) {
    this.compositeRateBmiMultiplier = compositeRateBmiMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCompositeRateBsaMultiplier(final BigDecimal compositeRateBsaMultiplier) {
    this.compositeRateBsaMultiplier = compositeRateBsaMultiplier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDrugAndBiologicalAdjustmentAmount(final BigDecimal drugAndBiologicalAdjustmentAmount) {
    this.drugAndBiologicalAdjustmentAmount = drugAndBiologicalAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierCaseMixPredictedMapAmount(final BigDecimal outlierCaseMixPredictedMapAmount) {
    this.outlierCaseMixPredictedMapAmount = outlierCaseMixPredictedMapAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierHemoEquivalentDialysisSessionsAmount(final BigDecimal outlierHemoEquivalentDialysisSessionsAmount) {
    this.outlierHemoEquivalentDialysisSessionsAmount = outlierHemoEquivalentDialysisSessionsAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierSeparatelyBillableBsaAmount(final BigDecimal outlierSeparatelyBillableBsaAmount) {
    this.outlierSeparatelyBillableBsaAmount = outlierSeparatelyBillableBsaAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTrainingAddOnPaymentAmount(final BigDecimal trainingAddOnPaymentAmount) {
    this.trainingAddOnPaymentAmount = trainingAddOnPaymentAmount;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AdditionalPricingData)) return false;
    final AdditionalPricingData other = (AdditionalPricingData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$bundledAdjustedBaseWageAmount = this.getBundledAdjustedBaseWageAmount();
    final java.lang.Object other$bundledAdjustedBaseWageAmount = other.getBundledAdjustedBaseWageAmount();
    if (this$bundledAdjustedBaseWageAmount == null ? other$bundledAdjustedBaseWageAmount != null : !this$bundledAdjustedBaseWageAmount.equals(other$bundledAdjustedBaseWageAmount)) return false;
    final java.lang.Object this$bundledBasePaymentRate = this.getBundledBasePaymentRate();
    final java.lang.Object other$bundledBasePaymentRate = other.getBundledBasePaymentRate();
    if (this$bundledBasePaymentRate == null ? other$bundledBasePaymentRate != null : !this$bundledBasePaymentRate.equals(other$bundledBasePaymentRate)) return false;
    final java.lang.Object this$bundledWageAdjustmentTrainingAmount = this.getBundledWageAdjustmentTrainingAmount();
    final java.lang.Object other$bundledWageAdjustmentTrainingAmount = other.getBundledWageAdjustmentTrainingAmount();
    if (this$bundledWageAdjustmentTrainingAmount == null ? other$bundledWageAdjustmentTrainingAmount != null : !this$bundledWageAdjustmentTrainingAmount.equals(other$bundledWageAdjustmentTrainingAmount)) return false;
    final java.lang.Object this$caseMixBmiUnderEighteenPointFiveMultiplier = this.getCaseMixBmiUnderEighteenPointFiveMultiplier();
    final java.lang.Object other$caseMixBmiUnderEighteenPointFiveMultiplier = other.getCaseMixBmiUnderEighteenPointFiveMultiplier();
    if (this$caseMixBmiUnderEighteenPointFiveMultiplier == null ? other$caseMixBmiUnderEighteenPointFiveMultiplier != null : !this$caseMixBmiUnderEighteenPointFiveMultiplier.equals(other$caseMixBmiUnderEighteenPointFiveMultiplier)) return false;
    final java.lang.Object this$caseMixBsaMultiplier = this.getCaseMixBsaMultiplier();
    final java.lang.Object other$caseMixBsaMultiplier = other.getCaseMixBsaMultiplier();
    if (this$caseMixBsaMultiplier == null ? other$caseMixBsaMultiplier != null : !this$caseMixBsaMultiplier.equals(other$caseMixBsaMultiplier)) return false;
    final java.lang.Object this$compositePaymentRate = this.getCompositePaymentRate();
    final java.lang.Object other$compositePaymentRate = other.getCompositePaymentRate();
    if (this$compositePaymentRate == null ? other$compositePaymentRate != null : !this$compositePaymentRate.equals(other$compositePaymentRate)) return false;
    final java.lang.Object this$compositeRateBmiMultiplier = this.getCompositeRateBmiMultiplier();
    final java.lang.Object other$compositeRateBmiMultiplier = other.getCompositeRateBmiMultiplier();
    if (this$compositeRateBmiMultiplier == null ? other$compositeRateBmiMultiplier != null : !this$compositeRateBmiMultiplier.equals(other$compositeRateBmiMultiplier)) return false;
    final java.lang.Object this$compositeRateBsaMultiplier = this.getCompositeRateBsaMultiplier();
    final java.lang.Object other$compositeRateBsaMultiplier = other.getCompositeRateBsaMultiplier();
    if (this$compositeRateBsaMultiplier == null ? other$compositeRateBsaMultiplier != null : !this$compositeRateBsaMultiplier.equals(other$compositeRateBsaMultiplier)) return false;
    final java.lang.Object this$drugAndBiologicalAdjustmentAmount = this.getDrugAndBiologicalAdjustmentAmount();
    final java.lang.Object other$drugAndBiologicalAdjustmentAmount = other.getDrugAndBiologicalAdjustmentAmount();
    if (this$drugAndBiologicalAdjustmentAmount == null ? other$drugAndBiologicalAdjustmentAmount != null : !this$drugAndBiologicalAdjustmentAmount.equals(other$drugAndBiologicalAdjustmentAmount)) return false;
    final java.lang.Object this$outlierCaseMixPredictedMapAmount = this.getOutlierCaseMixPredictedMapAmount();
    final java.lang.Object other$outlierCaseMixPredictedMapAmount = other.getOutlierCaseMixPredictedMapAmount();
    if (this$outlierCaseMixPredictedMapAmount == null ? other$outlierCaseMixPredictedMapAmount != null : !this$outlierCaseMixPredictedMapAmount.equals(other$outlierCaseMixPredictedMapAmount)) return false;
    final java.lang.Object this$outlierHemoEquivalentDialysisSessionsAmount = this.getOutlierHemoEquivalentDialysisSessionsAmount();
    final java.lang.Object other$outlierHemoEquivalentDialysisSessionsAmount = other.getOutlierHemoEquivalentDialysisSessionsAmount();
    if (this$outlierHemoEquivalentDialysisSessionsAmount == null ? other$outlierHemoEquivalentDialysisSessionsAmount != null : !this$outlierHemoEquivalentDialysisSessionsAmount.equals(other$outlierHemoEquivalentDialysisSessionsAmount)) return false;
    final java.lang.Object this$outlierSeparatelyBillableBsaAmount = this.getOutlierSeparatelyBillableBsaAmount();
    final java.lang.Object other$outlierSeparatelyBillableBsaAmount = other.getOutlierSeparatelyBillableBsaAmount();
    if (this$outlierSeparatelyBillableBsaAmount == null ? other$outlierSeparatelyBillableBsaAmount != null : !this$outlierSeparatelyBillableBsaAmount.equals(other$outlierSeparatelyBillableBsaAmount)) return false;
    final java.lang.Object this$trainingAddOnPaymentAmount = this.getTrainingAddOnPaymentAmount();
    final java.lang.Object other$trainingAddOnPaymentAmount = other.getTrainingAddOnPaymentAmount();
    if (this$trainingAddOnPaymentAmount == null ? other$trainingAddOnPaymentAmount != null : !this$trainingAddOnPaymentAmount.equals(other$trainingAddOnPaymentAmount)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AdditionalPricingData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $bundledAdjustedBaseWageAmount = this.getBundledAdjustedBaseWageAmount();
    result = result * PRIME + ($bundledAdjustedBaseWageAmount == null ? 43 : $bundledAdjustedBaseWageAmount.hashCode());
    final java.lang.Object $bundledBasePaymentRate = this.getBundledBasePaymentRate();
    result = result * PRIME + ($bundledBasePaymentRate == null ? 43 : $bundledBasePaymentRate.hashCode());
    final java.lang.Object $bundledWageAdjustmentTrainingAmount = this.getBundledWageAdjustmentTrainingAmount();
    result = result * PRIME + ($bundledWageAdjustmentTrainingAmount == null ? 43 : $bundledWageAdjustmentTrainingAmount.hashCode());
    final java.lang.Object $caseMixBmiUnderEighteenPointFiveMultiplier = this.getCaseMixBmiUnderEighteenPointFiveMultiplier();
    result = result * PRIME + ($caseMixBmiUnderEighteenPointFiveMultiplier == null ? 43 : $caseMixBmiUnderEighteenPointFiveMultiplier.hashCode());
    final java.lang.Object $caseMixBsaMultiplier = this.getCaseMixBsaMultiplier();
    result = result * PRIME + ($caseMixBsaMultiplier == null ? 43 : $caseMixBsaMultiplier.hashCode());
    final java.lang.Object $compositePaymentRate = this.getCompositePaymentRate();
    result = result * PRIME + ($compositePaymentRate == null ? 43 : $compositePaymentRate.hashCode());
    final java.lang.Object $compositeRateBmiMultiplier = this.getCompositeRateBmiMultiplier();
    result = result * PRIME + ($compositeRateBmiMultiplier == null ? 43 : $compositeRateBmiMultiplier.hashCode());
    final java.lang.Object $compositeRateBsaMultiplier = this.getCompositeRateBsaMultiplier();
    result = result * PRIME + ($compositeRateBsaMultiplier == null ? 43 : $compositeRateBsaMultiplier.hashCode());
    final java.lang.Object $drugAndBiologicalAdjustmentAmount = this.getDrugAndBiologicalAdjustmentAmount();
    result = result * PRIME + ($drugAndBiologicalAdjustmentAmount == null ? 43 : $drugAndBiologicalAdjustmentAmount.hashCode());
    final java.lang.Object $outlierCaseMixPredictedMapAmount = this.getOutlierCaseMixPredictedMapAmount();
    result = result * PRIME + ($outlierCaseMixPredictedMapAmount == null ? 43 : $outlierCaseMixPredictedMapAmount.hashCode());
    final java.lang.Object $outlierHemoEquivalentDialysisSessionsAmount = this.getOutlierHemoEquivalentDialysisSessionsAmount();
    result = result * PRIME + ($outlierHemoEquivalentDialysisSessionsAmount == null ? 43 : $outlierHemoEquivalentDialysisSessionsAmount.hashCode());
    final java.lang.Object $outlierSeparatelyBillableBsaAmount = this.getOutlierSeparatelyBillableBsaAmount();
    result = result * PRIME + ($outlierSeparatelyBillableBsaAmount == null ? 43 : $outlierSeparatelyBillableBsaAmount.hashCode());
    final java.lang.Object $trainingAddOnPaymentAmount = this.getTrainingAddOnPaymentAmount();
    result = result * PRIME + ($trainingAddOnPaymentAmount == null ? 43 : $trainingAddOnPaymentAmount.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "AdditionalPricingData(bundledAdjustedBaseWageAmount=" + this.getBundledAdjustedBaseWageAmount() + ", bundledBasePaymentRate=" + this.getBundledBasePaymentRate() + ", bundledWageAdjustmentTrainingAmount=" + this.getBundledWageAdjustmentTrainingAmount() + ", caseMixBmiUnderEighteenPointFiveMultiplier=" + this.getCaseMixBmiUnderEighteenPointFiveMultiplier() + ", caseMixBsaMultiplier=" + this.getCaseMixBsaMultiplier() + ", compositePaymentRate=" + this.getCompositePaymentRate() + ", compositeRateBmiMultiplier=" + this.getCompositeRateBmiMultiplier() + ", compositeRateBsaMultiplier=" + this.getCompositeRateBsaMultiplier() + ", drugAndBiologicalAdjustmentAmount=" + this.getDrugAndBiologicalAdjustmentAmount() + ", outlierCaseMixPredictedMapAmount=" + this.getOutlierCaseMixPredictedMapAmount() + ", outlierHemoEquivalentDialysisSessionsAmount=" + this.getOutlierHemoEquivalentDialysisSessionsAmount() + ", outlierSeparatelyBillableBsaAmount=" + this.getOutlierSeparatelyBillableBsaAmount() + ", trainingAddOnPaymentAmount=" + this.getTrainingAddOnPaymentAmount() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalPricingData() {
  }
}
