// Generated by delombok at Thu May 22 14:06:18 UTC 2025
package gov.cms.fiss.pricers.esrd.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.esrd.api.validation.ValidSignedDecimalOutputWithFourFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.validation.Valid;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;

@Schema(description = "The ESRD prospective payment data.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DATA", value = "<structure>")})})
public class EsrdPaymentData extends PaymentData {
  @NotNull
  @Schema(description = "The additional claim information.")
  @Valid
  private AdditionalPaymentData additionalPaymentInformation = new AdditionalPaymentData();
  @NotNull
  @Schema(description = "The additional claim information related to 2011 calculations.")
  @Valid
  private AdditionalPaymentData additionalPaymentInformation2011 = new AdditionalPaymentData();
  @BigDecimalScale(scale = 4)
  @NotNull
  @Schema(description = "The adjusted base wage amount before the ESRD Treatment Choices (ETC) Home Dialysis " + "Payment Adjustment (HDPA).", example = "5137.3689", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "ADJ-BASE-WAGE-BEFORE-ETC-HDPA", value = "PIC 9(07)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal adjustedBaseWageBeforeEtcHdpaAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @Valid
  private BundledPaymentData bundledPaymentInformation = new BundledPaymentData();
  @BigDecimalScale
  @NotNull
  @Schema(description = "The low-volume payment amount.", example = "5434.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LOW-VOL-AMT", value = "PIC 9(04)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal lowVolumeAmount = BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP);
  @BigDecimalScale
  @DecimalMin("0")
  @DecimalMax("9.9999")
  @Digits(integer = 1, fraction = 4)
  @Schema(description = "The network reduction amount.", example = "1.45", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "NETWORK-REDUCTION-RETURN", value = "PIC 9(01)V9(02)")})})
  @FixedValue
  private BigDecimal networkReductionAmount = BigDecimalUtils.ZERO.setScale(2, RoundingMode.UNNECESSARY);
  @BigDecimalScale(scale = 4)
  @NotNull
  @Schema(description = "The outlier non-per diem payment amount.", example = "1238.2345", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "OUT-NON-PER-DIEM-PAYMENT", value = "PIC 9(07)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal outlierNonPerDiemPaymentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(example = "5137.3689", description = "The ESRD Treatment Choices (ETC) Model Performance Payment Adjustment (PPA) amount applied.")
  @ValidSignedDecimalOutputWithFourFractionDigits
  private BigDecimal ppaAdjustmentAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "Line item payment amount before model ETC PPA adjustment.", example = "5137.3689")
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal prePpaAdjustmentAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "Line item payment amount after model ETC PPA adjustment. Final ESRD PPS per Treatment Payment Amount with PPA.", example = "5137.3689")
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal postPpaAdjustmentAmount = BigDecimal.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "The Transitional Drug Add-on Payment Adjustment (TDAPA) adjustment amount.", example = "31584.7863", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "TDAPA-RETURN", value = "PIC 9(07)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal tdapaPaymentAdjustmentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "The Transitional Add-on Payment Adjustment for New and Innovative Equipment and " + "Supplies (TPNIES) amount for capital-related assets (CRA).", example = "468752.8461")
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal tpniesCraPaymentAdjustmentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "The Transitional Add-on Payment Adjustment for New and Innovative Equipment and " + "Supplies (TPNIES) amount.", example = "468752.8461", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "TPNIES-RETURN", value = "PIC 9(07)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal tpniesPaymentAdjustmentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "The ESRD Treatment Choices (ETC) Home Dialysis Payment Adjustment (HDPA) " + "amount applied.", example = "5137.3689")
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal hdpaAdjustmentAmount = BigDecimalUtils.ZERO.setScale(4, RoundingMode.HALF_UP);
  @BigDecimalScale(scale = 4)
  @Schema(description = "Final Wage Index", example = "01.0123")
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal finalWageIndex = BigDecimalUtils.ZERO.setScale(4, RoundingMode.UNNECESSARY);

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalPaymentData getAdditionalPaymentInformation() {
    return this.additionalPaymentInformation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalPaymentData getAdditionalPaymentInformation2011() {
    return this.additionalPaymentInformation2011;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getAdjustedBaseWageBeforeEtcHdpaAmount() {
    return this.adjustedBaseWageBeforeEtcHdpaAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BundledPaymentData getBundledPaymentInformation() {
    return this.bundledPaymentInformation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowVolumeAmount() {
    return this.lowVolumeAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNetworkReductionAmount() {
    return this.networkReductionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierNonPerDiemPaymentAmount() {
    return this.outlierNonPerDiemPaymentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPpaAdjustmentAmount() {
    return this.ppaAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPrePpaAdjustmentAmount() {
    return this.prePpaAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getPostPpaAdjustmentAmount() {
    return this.postPpaAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTdapaPaymentAdjustmentAmount() {
    return this.tdapaPaymentAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTpniesCraPaymentAdjustmentAmount() {
    return this.tpniesCraPaymentAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTpniesPaymentAdjustmentAmount() {
    return this.tpniesPaymentAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHdpaAdjustmentAmount() {
    return this.hdpaAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFinalWageIndex() {
    return this.finalWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdditionalPaymentInformation(final AdditionalPaymentData additionalPaymentInformation) {
    this.additionalPaymentInformation = additionalPaymentInformation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdditionalPaymentInformation2011(final AdditionalPaymentData additionalPaymentInformation2011) {
    this.additionalPaymentInformation2011 = additionalPaymentInformation2011;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAdjustedBaseWageBeforeEtcHdpaAmount(final BigDecimal adjustedBaseWageBeforeEtcHdpaAmount) {
    this.adjustedBaseWageBeforeEtcHdpaAmount = adjustedBaseWageBeforeEtcHdpaAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBundledPaymentInformation(final BundledPaymentData bundledPaymentInformation) {
    this.bundledPaymentInformation = bundledPaymentInformation;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowVolumeAmount(final BigDecimal lowVolumeAmount) {
    this.lowVolumeAmount = lowVolumeAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNetworkReductionAmount(final BigDecimal networkReductionAmount) {
    this.networkReductionAmount = networkReductionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierNonPerDiemPaymentAmount(final BigDecimal outlierNonPerDiemPaymentAmount) {
    this.outlierNonPerDiemPaymentAmount = outlierNonPerDiemPaymentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPpaAdjustmentAmount(final BigDecimal ppaAdjustmentAmount) {
    this.ppaAdjustmentAmount = ppaAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPrePpaAdjustmentAmount(final BigDecimal prePpaAdjustmentAmount) {
    this.prePpaAdjustmentAmount = prePpaAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPostPpaAdjustmentAmount(final BigDecimal postPpaAdjustmentAmount) {
    this.postPpaAdjustmentAmount = postPpaAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTdapaPaymentAdjustmentAmount(final BigDecimal tdapaPaymentAdjustmentAmount) {
    this.tdapaPaymentAdjustmentAmount = tdapaPaymentAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTpniesCraPaymentAdjustmentAmount(final BigDecimal tpniesCraPaymentAdjustmentAmount) {
    this.tpniesCraPaymentAdjustmentAmount = tpniesCraPaymentAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTpniesPaymentAdjustmentAmount(final BigDecimal tpniesPaymentAdjustmentAmount) {
    this.tpniesPaymentAdjustmentAmount = tpniesPaymentAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHdpaAdjustmentAmount(final BigDecimal hdpaAdjustmentAmount) {
    this.hdpaAdjustmentAmount = hdpaAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFinalWageIndex(final BigDecimal finalWageIndex) {
    this.finalWageIndex = finalWageIndex;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof EsrdPaymentData)) return false;
    final EsrdPaymentData other = (EsrdPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    final java.lang.Object this$additionalPaymentInformation = this.getAdditionalPaymentInformation();
    final java.lang.Object other$additionalPaymentInformation = other.getAdditionalPaymentInformation();
    if (this$additionalPaymentInformation == null ? other$additionalPaymentInformation != null : !this$additionalPaymentInformation.equals(other$additionalPaymentInformation)) return false;
    final java.lang.Object this$additionalPaymentInformation2011 = this.getAdditionalPaymentInformation2011();
    final java.lang.Object other$additionalPaymentInformation2011 = other.getAdditionalPaymentInformation2011();
    if (this$additionalPaymentInformation2011 == null ? other$additionalPaymentInformation2011 != null : !this$additionalPaymentInformation2011.equals(other$additionalPaymentInformation2011)) return false;
    final java.lang.Object this$adjustedBaseWageBeforeEtcHdpaAmount = this.getAdjustedBaseWageBeforeEtcHdpaAmount();
    final java.lang.Object other$adjustedBaseWageBeforeEtcHdpaAmount = other.getAdjustedBaseWageBeforeEtcHdpaAmount();
    if (this$adjustedBaseWageBeforeEtcHdpaAmount == null ? other$adjustedBaseWageBeforeEtcHdpaAmount != null : !this$adjustedBaseWageBeforeEtcHdpaAmount.equals(other$adjustedBaseWageBeforeEtcHdpaAmount)) return false;
    final java.lang.Object this$bundledPaymentInformation = this.getBundledPaymentInformation();
    final java.lang.Object other$bundledPaymentInformation = other.getBundledPaymentInformation();
    if (this$bundledPaymentInformation == null ? other$bundledPaymentInformation != null : !this$bundledPaymentInformation.equals(other$bundledPaymentInformation)) return false;
    final java.lang.Object this$lowVolumeAmount = this.getLowVolumeAmount();
    final java.lang.Object other$lowVolumeAmount = other.getLowVolumeAmount();
    if (this$lowVolumeAmount == null ? other$lowVolumeAmount != null : !this$lowVolumeAmount.equals(other$lowVolumeAmount)) return false;
    final java.lang.Object this$networkReductionAmount = this.getNetworkReductionAmount();
    final java.lang.Object other$networkReductionAmount = other.getNetworkReductionAmount();
    if (this$networkReductionAmount == null ? other$networkReductionAmount != null : !this$networkReductionAmount.equals(other$networkReductionAmount)) return false;
    final java.lang.Object this$outlierNonPerDiemPaymentAmount = this.getOutlierNonPerDiemPaymentAmount();
    final java.lang.Object other$outlierNonPerDiemPaymentAmount = other.getOutlierNonPerDiemPaymentAmount();
    if (this$outlierNonPerDiemPaymentAmount == null ? other$outlierNonPerDiemPaymentAmount != null : !this$outlierNonPerDiemPaymentAmount.equals(other$outlierNonPerDiemPaymentAmount)) return false;
    final java.lang.Object this$ppaAdjustmentAmount = this.getPpaAdjustmentAmount();
    final java.lang.Object other$ppaAdjustmentAmount = other.getPpaAdjustmentAmount();
    if (this$ppaAdjustmentAmount == null ? other$ppaAdjustmentAmount != null : !this$ppaAdjustmentAmount.equals(other$ppaAdjustmentAmount)) return false;
    final java.lang.Object this$prePpaAdjustmentAmount = this.getPrePpaAdjustmentAmount();
    final java.lang.Object other$prePpaAdjustmentAmount = other.getPrePpaAdjustmentAmount();
    if (this$prePpaAdjustmentAmount == null ? other$prePpaAdjustmentAmount != null : !this$prePpaAdjustmentAmount.equals(other$prePpaAdjustmentAmount)) return false;
    final java.lang.Object this$postPpaAdjustmentAmount = this.getPostPpaAdjustmentAmount();
    final java.lang.Object other$postPpaAdjustmentAmount = other.getPostPpaAdjustmentAmount();
    if (this$postPpaAdjustmentAmount == null ? other$postPpaAdjustmentAmount != null : !this$postPpaAdjustmentAmount.equals(other$postPpaAdjustmentAmount)) return false;
    final java.lang.Object this$tdapaPaymentAdjustmentAmount = this.getTdapaPaymentAdjustmentAmount();
    final java.lang.Object other$tdapaPaymentAdjustmentAmount = other.getTdapaPaymentAdjustmentAmount();
    if (this$tdapaPaymentAdjustmentAmount == null ? other$tdapaPaymentAdjustmentAmount != null : !this$tdapaPaymentAdjustmentAmount.equals(other$tdapaPaymentAdjustmentAmount)) return false;
    final java.lang.Object this$tpniesCraPaymentAdjustmentAmount = this.getTpniesCraPaymentAdjustmentAmount();
    final java.lang.Object other$tpniesCraPaymentAdjustmentAmount = other.getTpniesCraPaymentAdjustmentAmount();
    if (this$tpniesCraPaymentAdjustmentAmount == null ? other$tpniesCraPaymentAdjustmentAmount != null : !this$tpniesCraPaymentAdjustmentAmount.equals(other$tpniesCraPaymentAdjustmentAmount)) return false;
    final java.lang.Object this$tpniesPaymentAdjustmentAmount = this.getTpniesPaymentAdjustmentAmount();
    final java.lang.Object other$tpniesPaymentAdjustmentAmount = other.getTpniesPaymentAdjustmentAmount();
    if (this$tpniesPaymentAdjustmentAmount == null ? other$tpniesPaymentAdjustmentAmount != null : !this$tpniesPaymentAdjustmentAmount.equals(other$tpniesPaymentAdjustmentAmount)) return false;
    final java.lang.Object this$hdpaAdjustmentAmount = this.getHdpaAdjustmentAmount();
    final java.lang.Object other$hdpaAdjustmentAmount = other.getHdpaAdjustmentAmount();
    if (this$hdpaAdjustmentAmount == null ? other$hdpaAdjustmentAmount != null : !this$hdpaAdjustmentAmount.equals(other$hdpaAdjustmentAmount)) return false;
    final java.lang.Object this$finalWageIndex = this.getFinalWageIndex();
    final java.lang.Object other$finalWageIndex = other.getFinalWageIndex();
    if (this$finalWageIndex == null ? other$finalWageIndex != null : !this$finalWageIndex.equals(other$finalWageIndex)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof EsrdPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    final java.lang.Object $additionalPaymentInformation = this.getAdditionalPaymentInformation();
    result = result * PRIME + ($additionalPaymentInformation == null ? 43 : $additionalPaymentInformation.hashCode());
    final java.lang.Object $additionalPaymentInformation2011 = this.getAdditionalPaymentInformation2011();
    result = result * PRIME + ($additionalPaymentInformation2011 == null ? 43 : $additionalPaymentInformation2011.hashCode());
    final java.lang.Object $adjustedBaseWageBeforeEtcHdpaAmount = this.getAdjustedBaseWageBeforeEtcHdpaAmount();
    result = result * PRIME + ($adjustedBaseWageBeforeEtcHdpaAmount == null ? 43 : $adjustedBaseWageBeforeEtcHdpaAmount.hashCode());
    final java.lang.Object $bundledPaymentInformation = this.getBundledPaymentInformation();
    result = result * PRIME + ($bundledPaymentInformation == null ? 43 : $bundledPaymentInformation.hashCode());
    final java.lang.Object $lowVolumeAmount = this.getLowVolumeAmount();
    result = result * PRIME + ($lowVolumeAmount == null ? 43 : $lowVolumeAmount.hashCode());
    final java.lang.Object $networkReductionAmount = this.getNetworkReductionAmount();
    result = result * PRIME + ($networkReductionAmount == null ? 43 : $networkReductionAmount.hashCode());
    final java.lang.Object $outlierNonPerDiemPaymentAmount = this.getOutlierNonPerDiemPaymentAmount();
    result = result * PRIME + ($outlierNonPerDiemPaymentAmount == null ? 43 : $outlierNonPerDiemPaymentAmount.hashCode());
    final java.lang.Object $ppaAdjustmentAmount = this.getPpaAdjustmentAmount();
    result = result * PRIME + ($ppaAdjustmentAmount == null ? 43 : $ppaAdjustmentAmount.hashCode());
    final java.lang.Object $prePpaAdjustmentAmount = this.getPrePpaAdjustmentAmount();
    result = result * PRIME + ($prePpaAdjustmentAmount == null ? 43 : $prePpaAdjustmentAmount.hashCode());
    final java.lang.Object $postPpaAdjustmentAmount = this.getPostPpaAdjustmentAmount();
    result = result * PRIME + ($postPpaAdjustmentAmount == null ? 43 : $postPpaAdjustmentAmount.hashCode());
    final java.lang.Object $tdapaPaymentAdjustmentAmount = this.getTdapaPaymentAdjustmentAmount();
    result = result * PRIME + ($tdapaPaymentAdjustmentAmount == null ? 43 : $tdapaPaymentAdjustmentAmount.hashCode());
    final java.lang.Object $tpniesCraPaymentAdjustmentAmount = this.getTpniesCraPaymentAdjustmentAmount();
    result = result * PRIME + ($tpniesCraPaymentAdjustmentAmount == null ? 43 : $tpniesCraPaymentAdjustmentAmount.hashCode());
    final java.lang.Object $tpniesPaymentAdjustmentAmount = this.getTpniesPaymentAdjustmentAmount();
    result = result * PRIME + ($tpniesPaymentAdjustmentAmount == null ? 43 : $tpniesPaymentAdjustmentAmount.hashCode());
    final java.lang.Object $hdpaAdjustmentAmount = this.getHdpaAdjustmentAmount();
    result = result * PRIME + ($hdpaAdjustmentAmount == null ? 43 : $hdpaAdjustmentAmount.hashCode());
    final java.lang.Object $finalWageIndex = this.getFinalWageIndex();
    result = result * PRIME + ($finalWageIndex == null ? 43 : $finalWageIndex.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "EsrdPaymentData(additionalPaymentInformation=" + this.getAdditionalPaymentInformation() + ", additionalPaymentInformation2011=" + this.getAdditionalPaymentInformation2011() + ", adjustedBaseWageBeforeEtcHdpaAmount=" + this.getAdjustedBaseWageBeforeEtcHdpaAmount() + ", bundledPaymentInformation=" + this.getBundledPaymentInformation() + ", lowVolumeAmount=" + this.getLowVolumeAmount() + ", networkReductionAmount=" + this.getNetworkReductionAmount() + ", outlierNonPerDiemPaymentAmount=" + this.getOutlierNonPerDiemPaymentAmount() + ", ppaAdjustmentAmount=" + this.getPpaAdjustmentAmount() + ", prePpaAdjustmentAmount=" + this.getPrePpaAdjustmentAmount() + ", postPpaAdjustmentAmount=" + this.getPostPpaAdjustmentAmount() + ", tdapaPaymentAdjustmentAmount=" + this.getTdapaPaymentAdjustmentAmount() + ", tpniesCraPaymentAdjustmentAmount=" + this.getTpniesCraPaymentAdjustmentAmount() + ", tpniesPaymentAdjustmentAmount=" + this.getTpniesPaymentAdjustmentAmount() + ", hdpaAdjustmentAmount=" + this.getHdpaAdjustmentAmount() + ", finalWageIndex=" + this.getFinalWageIndex() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public EsrdPaymentData() {
  }
}
