/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.ws;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.UpgradeHandler;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketCloseCodeReasonListener;
import com.ning.http.client.ws.WebSocketListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class WebSocketUpgradeHandler
implements UpgradeHandler<WebSocket>,
AsyncHandler<WebSocket> {
    private WebSocket webSocket;
    private final List<WebSocketListener> listeners;
    private final AtomicBoolean ok = new AtomicBoolean(false);
    private boolean onSuccessCalled;
    private int status;

    protected WebSocketUpgradeHandler() {
        this.listeners = new LinkedList<WebSocketListener>();
    }

    protected WebSocketUpgradeHandler(List<WebSocketListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void onThrowable(Throwable t2) {
        this.onFailure(t2);
    }

    public boolean touchSuccess() {
        boolean prev = this.onSuccessCalled;
        this.onSuccessCalled = true;
        return prev;
    }

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.status = responseStatus.getStatusCode();
        return this.status == 101 ? AsyncHandler.STATE.UPGRADE : AsyncHandler.STATE.ABORT;
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public WebSocket onCompleted() throws Exception {
        if (this.status != 101) {
            IllegalStateException e = new IllegalStateException("Invalid Status Code " + this.status);
            for (WebSocketListener listener : this.listeners) {
                listener.onError(e);
            }
            throw e;
        }
        if (this.webSocket == null) {
            throw new NullPointerException("webSocket");
        }
        return this.webSocket;
    }

    @Override
    public void onSuccess(WebSocket webSocket) {
        this.webSocket = webSocket;
        for (WebSocketListener listener : this.listeners) {
            webSocket.addWebSocketListener(listener);
            listener.onOpen(webSocket);
        }
        this.ok.set(true);
    }

    @Override
    public void onFailure(Throwable t2) {
        for (WebSocketListener w : this.listeners) {
            if (!this.ok.get() && this.webSocket != null) {
                this.webSocket.addWebSocketListener(w);
            }
            w.onError(t2);
        }
    }

    public void onClose(WebSocket webSocket, int status, String reasonPhrase) {
        if (this.webSocket == null) {
            this.webSocket = webSocket;
        }
        for (WebSocketListener listener : this.listeners) {
            if (webSocket != null) {
                webSocket.addWebSocketListener(listener);
            }
            listener.onClose(webSocket);
            if (!(listener instanceof WebSocketCloseCodeReasonListener)) continue;
            ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(listener)).onClose(webSocket, status, reasonPhrase);
        }
    }

    public static final class Builder {
        private List<WebSocketListener> listeners = new ArrayList<WebSocketListener>(1);

        public Builder addWebSocketListener(WebSocketListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder removeWebSocketListener(WebSocketListener listener) {
            this.listeners.remove(listener);
            return this;
        }

        public WebSocketUpgradeHandler build() {
            return new WebSocketUpgradeHandler(this.listeners);
        }
    }
}

