/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.util;

import com.ning.http.util.StringCharSequence;

public final class UTF8UrlDecoder {
    private UTF8UrlDecoder() {
    }

    private static StringBuilder initSb(StringBuilder sb, String s2, int i2, int offset, int length) {
        if (sb != null) {
            return sb;
        }
        int initialSbLength = length > 500 ? length / 2 : length;
        return new StringBuilder(initialSbLength).append(s2, offset, i2);
    }

    private static int hexaDigit(char c) {
        return Character.digit(c, 16);
    }

    public static CharSequence decode(String s2) {
        return UTF8UrlDecoder.decode(s2, 0, s2.length());
    }

    public static CharSequence decode(String s2, int offset, int length) {
        StringBuilder sb = null;
        int i2 = offset;
        int end = length + offset;
        while (i2 < end) {
            char c = s2.charAt(i2);
            if (c == '+') {
                sb = UTF8UrlDecoder.initSb(sb, s2, i2, offset, length);
                sb.append(' ');
                ++i2;
                continue;
            }
            if (c == '%') {
                int y;
                if (end - i2 < 3) {
                    throw new IllegalArgumentException("UTF8UrlDecoder: Incomplete trailing escape (%) pattern");
                }
                int x = UTF8UrlDecoder.hexaDigit(s2.charAt(i2 + 1));
                if (x == -1 || (y = UTF8UrlDecoder.hexaDigit(s2.charAt(i2 + 2))) == -1) {
                    throw new IllegalArgumentException("UTF8UrlDecoder: Malformed");
                }
                sb = UTF8UrlDecoder.initSb(sb, s2, i2, offset, length);
                sb.append((char)(x * 16 + y));
                i2 += 3;
                continue;
            }
            if (sb != null) {
                sb.append(c);
            }
            ++i2;
        }
        return sb != null ? sb.toString() : new StringCharSequence(s2, offset, length);
    }
}

