/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.errors;

import gov.cms.fiss.pricers.common.api.DateValidationException;
import gov.cms.fiss.pricers.common.application.Reporting;
import gov.cms.fiss.pricers.common.application.errors.DateValidationError;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DateValidationExceptionMapper
implements ExceptionMapper<DateValidationException> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DateValidationExceptionMapper.class);

    @Override
    public Response toResponse(DateValidationException exception) {
        String builder = "The following date(s) could not be parsed:\n" + String.join((CharSequence)"\n", exception.getInvalid());
        DateValidationError error = new DateValidationError(builder);
        Reporting.reportEventToNR("DateValidation", "dischargeDate", exception.getMessage());
        LOGGER.debug("Date validation error: {}", (Object)error);
        return Response.status(error.getCode()).type("application/json").entity(error).build();
    }
}

