/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SetConditionCode
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public boolean shouldExecute(EsrdPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ReturnCode.CALCULATION_STARTED_00);
    }

    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData billingRecord = calculationContext.getClaimData();
        EsrdClaimData claimData = calculationContext.getClaimData();
        if (billingRecord.getConditionCodes() == null) {
            calculationContext.setEsrdFacility(true);
            return;
        }
        if (LocalDateUtils.isBeforeOrEqual(claimData.getServiceThroughDate(), LocalDate.of(2024, 12, 31))) {
            if (billingRecord.getConditionCodes().size() == 1) {
                this.assignConditionCodeBooleansForOne(calculationContext);
            } else {
                calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
            }
        }
        if (LocalDateUtils.isAfterOrEqual(claimData.getServiceThroughDate(), LocalDate.of(2025, 1, 1))) {
            if (billingRecord.getConditionCodes().size() == 1) {
                this.assignConditionCodeBooleansForOne(calculationContext);
            } else if (billingRecord.getConditionCodes().size() == 2) {
                this.validateConditionCodeBooleansForTwo(calculationContext);
            }
        }
    }

    private void assignConditionCodeBooleansForOne(EsrdPricerContext calculationContext) {
        EsrdClaimData billingRecord = calculationContext.getClaimData();
        if (billingRecord.getConditionCodes().contains(null)) {
            calculationContext.setEsrdFacility(true);
            return;
        }
        if (calculationContext.hasConditionCode("73")) {
            calculationContext.setEsrdTraining73(true);
        } else if (calculationContext.hasConditionCode("74")) {
            calculationContext.setEsrdHome74(true);
        } else if (calculationContext.hasConditionCode("76")) {
            calculationContext.setEsrdBackup76(true);
        } else if (calculationContext.hasConditionCode("84")) {
            calculationContext.setAkiFacility84(true);
            calculationContext.setAki84(true);
        } else if (calculationContext.hasConditionCode("87")) {
            calculationContext.setEsrdRetraining87(true);
        } else {
            calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
        }
    }

    private void validateConditionCodeBooleansForTwo(EsrdPricerContext calculationContext) {
        EsrdClaimData billingRecord = calculationContext.getClaimData();
        if (billingRecord.getConditionCodes().get(0) == null && billingRecord.getConditionCodes().get(1) == null) {
            return;
        }
        if (billingRecord.getConditionCodes().contains(null)) {
            String validCode;
            List<String> codes = billingRecord.getConditionCodes();
            if (codes.size() == 2 && codes.contains(null) && (validCode = (String)codes.stream().filter(Objects::nonNull).findFirst().orElse(null)) != null) {
                billingRecord.setConditionCodes(Collections.singletonList(validCode));
                this.assignConditionCodeBooleansForOne(calculationContext);
            }
        } else {
            this.assignConditionCodeBooleansForTwo(calculationContext);
        }
    }

    private void assignConditionCodeBooleansForTwo(EsrdPricerContext calculationContext) {
        if (calculationContext.hasConditionCode("84")) {
            if (calculationContext.hasConditionCode("73")) {
                calculationContext.setAkiTraining8473(true);
                calculationContext.setAki84(true);
            } else if (calculationContext.hasConditionCode("74")) {
                calculationContext.setAkiHome8474(true);
                calculationContext.setAki84(true);
            } else if (calculationContext.hasConditionCode("87")) {
                calculationContext.setAkiRetraining8487(true);
                calculationContext.setAki84(true);
            } else {
                calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
            }
        } else {
            calculationContext.applyReturnCode(ReturnCode.INVALID_CONDITION_CODE_58);
        }
    }
}

