/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import gov.cms.fiss.pricers.esrd.core.codes.ReturnCode;

public class SetReturnCode
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        if (calculationContext.isPediatricClaim()) {
            this.applyPediatricReturnCode(calculationContext);
            return;
        }
        if (calculationContext.isOutlierClaim()) {
            this.applyOutlierReturnCode(calculationContext);
            return;
        }
        if (calculationContext.isLowVolumeClaim()) {
            this.applyLowVolumeReturnCode(calculationContext);
            return;
        }
        if (calculationContext.isTrainingClaim()) {
            this.applyTrainingReturnCode(calculationContext);
            return;
        }
        this.applyOtherReturnCode(calculationContext);
    }

    private void applyPediatricReturnCode(EsrdPricerContext calculationContext) {
        if (calculationContext.isOutlierClaim()) {
            if (calculationContext.isTrainingClaim()) {
                calculationContext.applyReturnCode(ReturnCode.OUTLIER_PEDIATRIC_TRAINING_PAYMENT_17);
            } else {
                calculationContext.applyReturnCode(ReturnCode.OUTLIER_PEDIATRIC_PAYMENT_16);
            }
        } else if (calculationContext.isTrainingClaim()) {
            calculationContext.applyReturnCode(ReturnCode.PEDIATRIC_PAYMENT_TRAINING_15);
        } else {
            calculationContext.applyReturnCode(ReturnCode.PEDIATRIC_PAYMENT_14);
        }
    }

    private void applyOutlierReturnCode(EsrdPricerContext calculationContext) {
        if (calculationContext.isLowVolumeClaim()) {
            this.applyLowVolumeOutlierReturnCode(calculationContext);
        } else if (calculationContext.isTrainingClaim()) {
            if (calculationContext.isChronicComorbidityFound()) {
                calculationContext.applyReturnCode(ReturnCode.OUTLIER_TRAINING_PAYMENT_WITH_CHRONIC_COMORBIDITY_34);
            } else if (calculationContext.isAcuteComorbidityFound()) {
                calculationContext.applyReturnCode(ReturnCode.OUTLIER_TRAINING_PAYMENT_WITH_ACUTE_COMORBIDITY_35);
            } else {
                calculationContext.applyReturnCode(ReturnCode.OUTLIER_TRAINING_PAYMENT_33);
            }
        } else if (calculationContext.isChronicComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.OUTLIER_PAYMENT_WITH_CHRONIC_COMORBIDITY_07);
        } else if (calculationContext.isAcuteComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.OUTLIER_PAYMENT_WITH_ACUTE_COMORBIDITY_06);
        } else if (calculationContext.isOnsetRecent()) {
            calculationContext.applyReturnCode(ReturnCode.OUTLIER_PAYMENT_WITH_ONSET_09);
        } else {
            calculationContext.applyReturnCode(ReturnCode.OUTLIER_PAYMENT_03);
        }
    }

    private void applyLowVolumeOutlierReturnCode(EsrdPricerContext calculationContext) {
        if (calculationContext.isTrainingClaim()) {
            if (calculationContext.isChronicComorbidityFound()) {
                calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_OUTLIER_TRAINING_PAYMENT_WITH_CHRONIC_COMORBIDITY_24);
            } else if (calculationContext.isAcuteComorbidityFound()) {
                calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_OUTLIER_TRAINING_PAYMENT_WITH_ACUTE_COMORBIDITY_19);
            } else {
                calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_OUTLIER_TRAINING_PAYMENT_29);
            }
        } else if (calculationContext.isChronicComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_OUTLIER_PAYMENT_WITH_CHRONIC_COMORBIDITY_23);
        } else if (calculationContext.isAcuteComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_OUTLIER_PAYMENT_WITH_ACUTE_COMORBIDITY_18);
        } else if (calculationContext.isOnsetRecent()) {
            calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_OUTLIER_PAYMENT_WITH_ONSET_30);
        } else {
            calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_OUTLIER_PAYMENT_28);
        }
    }

    private void applyLowVolumeReturnCode(EsrdPricerContext calculationContext) {
        if (calculationContext.isTrainingClaim()) {
            if (calculationContext.isChronicComorbidityFound()) {
                calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_TRAINING_PAYMENT_WITH_CHRONIC_COMORBIDITY_26);
            } else if (calculationContext.isAcuteComorbidityFound()) {
                calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_TRAINING_PAYMENT_WITH_ACUTE_COMORBIDITY_21);
            } else {
                calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_TRAINING_PAYMENT_12);
            }
        } else if (calculationContext.isChronicComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_PAYMENT_WITH_CHRONIC_COMORBIDITY_25);
        } else if (calculationContext.isAcuteComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_PAYMENT_WITH_ACUTE_COMORBIDITY_20);
        } else if (calculationContext.isOnsetRecent()) {
            calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_PAYMENT_WITH_ONSET_32);
        } else {
            calculationContext.applyReturnCode(ReturnCode.LOW_VOLUME_PAYMENT_10);
        }
    }

    private void applyTrainingReturnCode(EsrdPricerContext calculationContext) {
        if (calculationContext.isChronicComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.TRAINING_PAYMENT_WITH_CHRONIC_COMORBIDITY_27);
        } else if (calculationContext.isAcuteComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.TRAINING_PAYMENT_WITH_ACUTE_COMORBIDITY_22);
        } else {
            calculationContext.applyReturnCode(ReturnCode.TRAINING_PAYMENT_11);
        }
    }

    private void applyOtherReturnCode(EsrdPricerContext calculationContext) {
        if (calculationContext.isOnsetRecent()) {
            calculationContext.applyReturnCode(ReturnCode.PAYMENT_WITH_ONSET_08);
        } else if (calculationContext.isAcuteComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.PAYMENT_WITH_ACUTE_COMORBIDITY_04);
        } else if (calculationContext.isChronicComorbidityFound()) {
            calculationContext.applyReturnCode(ReturnCode.PAYMENT_WITH_CHRONIC_COMORBIDITY_05);
        } else if (calculationContext.isLowBmiClaim()) {
            calculationContext.applyReturnCode(ReturnCode.PAYMENT_WITH_LOW_BMI_31);
        } else {
            calculationContext.applyReturnCode(ReturnCode.PAYMENT_NO_ADJUSTMENTS_02);
        }
    }
}

