/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.esrd.core.rules.rules_2025;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimData;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingRequest;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdClaimPricingResponse;
import gov.cms.fiss.pricers.esrd.api.v2.EsrdPaymentData;
import gov.cms.fiss.pricers.esrd.core.EsrdPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class CalculateHdpaAdjustmentAmount2025
implements CalculationRule<EsrdClaimPricingRequest, EsrdClaimPricingResponse, EsrdPricerContext> {
    @Override
    public void calculate(EsrdPricerContext calculationContext) {
        EsrdClaimData claimData = calculationContext.getClaimData();
        EsrdPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setHdpaAdjustmentAmount(BigDecimal.ZERO);
        if (!calculationContext.isAki84() && calculationContext.hasDemoCode("94") && StringUtils.equalsAny(claimData.getTreatmentChoicesIndicator(), "H", " ", "B")) {
            paymentData.setHdpaAdjustmentAmount(calculationContext.getEtcHdpaPercent().subtract(BigDecimal.ONE).multiply(calculationContext.getBundledAdjustedBaseWageAmount()));
            if (calculationContext.isPerDiemClaim()) {
                paymentData.setHdpaAdjustmentAmount(paymentData.getHdpaAdjustmentAmount().multiply(new BigDecimal(3)).divide(new BigDecimal(7), 2, RoundingMode.HALF_UP));
            }
        }
    }
}

