/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import io.dropwizard.jersey.optional.EmptyOptionalException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.OptionalDouble;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"*/*"})
public class OptionalDoubleMessageBodyWriter
implements MessageBodyWriter<OptionalDouble> {
    @Override
    public long getSize(OptionalDouble entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OptionalDouble.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(OptionalDouble entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        String body = Double.toString(entity.orElseThrow(() -> EmptyOptionalException.INSTANCE));
        entityStream.write(body.getBytes(StandardCharsets.US_ASCII));
    }
}

