/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.connectionpool;

import java.io.IOException;
import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.ConnectorHandler;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.connectionpool.Chain;
import org.glassfish.grizzly.connectionpool.ConnectionInfo;
import org.glassfish.grizzly.connectionpool.Endpoint;
import org.glassfish.grizzly.connectionpool.Link;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.impl.SafeFutureImpl;
import org.glassfish.grizzly.threadpool.GrizzlyExecutorService;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.Futures;

public class SingleEndpointPool<E> {
    private static final Logger LOGGER = Grizzly.logger(SingleEndpointPool.class);
    private final ConnectCompletionHandler defaultConnectionCompletionHandler = new ConnectCompletionHandler();
    private final PoolConnectionCloseListener closeListener = new PoolConnectionCloseListener();
    private final Chain<ConnectionInfo<E>> readyConnections = new Chain();
    private final Map<Connection, ConnectionInfo<E>> connectionsMap = new HashMap<Connection, ConnectionInfo<E>>();
    final Object poolSync = new Object();
    private boolean isClosed;
    private final ExecutorService ownDelayedExecutorThreadPool;
    private final DelayedExecutor ownDelayedExecutor;
    private final DelayedExecutor.DelayQueue<ConnectTimeoutTask> connectTimeoutQueue;
    private final DelayedExecutor.DelayQueue<ReconnectTask> reconnectQueue;
    private final int maxReconnectAttempts;
    private final DelayedExecutor.DelayQueue<KeepAliveCleanerTask> keepAliveCleanerQueue;
    private final DelayedExecutor.DelayQueue<Link<AsyncPoll>> asyncPollTimeoutQueue;
    private final DelayedExecutor.DelayQueue<ConnectionInfo> connectionTTLQueue;
    private final Endpoint<E> endpoint;
    private final int corePoolSize;
    protected final int maxPoolSize;
    private final long connectTimeoutMillis;
    private final long reconnectDelayMillis;
    private final long keepAliveTimeoutMillis;
    private final long keepAliveCheckIntervalMillis;
    private final long asyncPollTimeoutMillis;
    private final long connectionTTLMillis;
    private final boolean failFastWhenMaxSizeReached;
    private int poolSize;
    protected int pendingConnections;
    private int failedConnectAttempts;
    private final Chain<AsyncPoll> asyncWaitingList = new Chain();

    public static <T> Builder<T> builder(Class<T> endpointType) {
        return new Builder();
    }

    protected SingleEndpointPool(Endpoint<E> endpoint, int corePoolSize, int maxPoolSize, DelayedExecutor delayedExecutor, long connectTimeoutMillis, long keepAliveTimeoutMillis, long keepAliveCheckIntervalMillis, long reconnectDelayMillis, int maxReconnectAttempts, long asyncPollTimeoutMillis, long connectionTTLMillis, boolean failFastWhenMaxSizeReached) {
        this.endpoint = endpoint;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.reconnectDelayMillis = reconnectDelayMillis;
        this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
        this.keepAliveCheckIntervalMillis = keepAliveCheckIntervalMillis;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.asyncPollTimeoutMillis = asyncPollTimeoutMillis;
        this.connectionTTLMillis = connectionTTLMillis;
        this.failFastWhenMaxSizeReached = failFastWhenMaxSizeReached;
        if (delayedExecutor == null) {
            ThreadPoolConfig tpc = ThreadPoolConfig.defaultConfig().setPoolName("connection-pool-delays-thread-pool").setCorePoolSize(1).setMaxPoolSize(1);
            this.ownDelayedExecutorThreadPool = GrizzlyExecutorService.createInstance(tpc);
            this.ownDelayedExecutor = new DelayedExecutor(this.ownDelayedExecutorThreadPool);
            this.ownDelayedExecutor.start();
            delayedExecutor = this.ownDelayedExecutor;
        } else {
            this.ownDelayedExecutorThreadPool = null;
            this.ownDelayedExecutor = null;
        }
        this.connectTimeoutQueue = connectTimeoutMillis >= 0L ? delayedExecutor.createDelayQueue(new ConnectTimeoutWorker(), new ConnectTimeoutTaskResolver()) : null;
        this.reconnectQueue = reconnectDelayMillis >= 0L ? delayedExecutor.createDelayQueue(new Reconnector(), new ReconnectTaskResolver()) : null;
        if (keepAliveTimeoutMillis > 0L) {
            this.keepAliveCleanerQueue = delayedExecutor.createDelayQueue(new KeepAliveCleaner(), new KeepAliveCleanerTaskResolver());
            this.keepAliveCleanerQueue.add(new KeepAliveCleanerTask(this), keepAliveCheckIntervalMillis, TimeUnit.MILLISECONDS);
        } else {
            this.keepAliveCleanerQueue = null;
        }
        this.asyncPollTimeoutQueue = asyncPollTimeoutMillis >= 0L ? delayedExecutor.createDelayQueue(new AsyncPollTimeoutWorker(), new AsyncPollTimeoutTaskResolver()) : null;
        this.connectionTTLQueue = connectionTTLMillis >= 0L ? delayedExecutor.createDelayQueue(new ConnectionTTLWorker(), new ConnectionTTLTaskResolver()) : null;
    }

    protected SingleEndpointPool(Endpoint<E> endpoint, int corePoolSize, int maxPoolSize, DelayedExecutor.DelayQueue<ConnectTimeoutTask> connectTimeoutQueue, DelayedExecutor.DelayQueue<ReconnectTask> reconnectQueue, DelayedExecutor.DelayQueue<KeepAliveCleanerTask> keepAliveCleanerQueue, DelayedExecutor.DelayQueue<Link<AsyncPoll>> asyncPollTimeoutQueue, DelayedExecutor.DelayQueue<ConnectionInfo> connectionTTLQueue, long connectTimeoutMillis, long keepAliveTimeoutMillis, long keepAliveCheckIntervalMillis, long reconnectDelayMillis, int maxReconnectAttempts, long asyncPollTimeoutMillis, long connectionTTLMillis, boolean failFastWhenMaxSizeReached) {
        this.endpoint = endpoint;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maxPoolSize;
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.reconnectDelayMillis = reconnectDelayMillis;
        this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
        this.keepAliveCheckIntervalMillis = keepAliveCheckIntervalMillis;
        this.maxReconnectAttempts = maxReconnectAttempts;
        this.asyncPollTimeoutMillis = asyncPollTimeoutMillis;
        this.connectionTTLMillis = connectionTTLMillis;
        this.failFastWhenMaxSizeReached = failFastWhenMaxSizeReached;
        this.ownDelayedExecutor = null;
        this.ownDelayedExecutorThreadPool = null;
        this.connectTimeoutQueue = connectTimeoutQueue;
        this.reconnectQueue = reconnectQueue;
        this.keepAliveCleanerQueue = keepAliveCleanerQueue;
        if (keepAliveTimeoutMillis > 0L) {
            keepAliveCleanerQueue.add(new KeepAliveCleanerTask(this), keepAliveCheckIntervalMillis, TimeUnit.MILLISECONDS);
        }
        this.asyncPollTimeoutQueue = asyncPollTimeoutQueue;
        this.connectionTTLQueue = connectionTTLQueue;
    }

    public Endpoint<E> getEndpoint() {
        return this.endpoint;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getConnectTimeout(TimeUnit timeUnit) {
        return this.connectTimeoutMillis <= 0L ? this.connectTimeoutMillis : timeUnit.convert(this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public long getReconnectDelay(TimeUnit timeUnit) {
        return this.reconnectDelayMillis <= 0L ? this.reconnectDelayMillis : timeUnit.convert(this.reconnectDelayMillis, TimeUnit.MILLISECONDS);
    }

    public int getMaxReconnectAttempts() {
        return this.maxReconnectAttempts;
    }

    public long getKeepAliveTimeout(TimeUnit timeUnit) {
        return this.keepAliveTimeoutMillis <= 0L ? this.keepAliveTimeoutMillis : timeUnit.convert(this.keepAliveTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public long getKeepAliveCheckInterval(TimeUnit timeUnit) {
        return this.keepAliveCheckIntervalMillis <= 0L ? this.keepAliveCheckIntervalMillis : timeUnit.convert(this.keepAliveCheckIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public long getAsyncPollTimeout(TimeUnit timeUnit) {
        return this.asyncPollTimeoutMillis <= 0L ? this.asyncPollTimeoutMillis : timeUnit.convert(this.asyncPollTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public long getConnectionTTL(TimeUnit timeUnit) {
        return this.connectionTTLMillis <= 0L ? this.connectionTTLMillis : timeUnit.convert(this.connectionTTLMillis, TimeUnit.MILLISECONDS);
    }

    public boolean isFailFastWhenMaxSizeReached() {
        return this.failFastWhenMaxSizeReached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.poolSize + this.pendingConnections;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOpenConnectionsCount() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.poolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReadyConnectionsCount() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.readyConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaxCapacityReached() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.maxPoolSize != -1 && this.poolSize + this.pendingConnections >= this.maxPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            return this.connectionsMap.containsKey(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            return this.isBusy0(this.connectionsMap.get(connection));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isBusy0(ConnectionInfo<E> connectionRecord) {
        Object object = this.poolSync;
        synchronized (object) {
            return connectionRecord != null && !connectionRecord.isReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionInfo<E> getConnectionInfo(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            return this.connectionsMap.get(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrizzlyFuture<Connection> take() {
        int errorCode = 0;
        SafeFutureImpl<Connection> future = null;
        boolean isCreateNewConnection = false;
        try {
            Object object = this.poolSync;
            synchronized (object) {
                if (!this.isClosed) {
                    if (this.readyConnections.isEmpty()) {
                        if (!this.failFastWhenMaxSizeReached || !this.isMaxCapacityReached() || this.pendingConnections >= this.getWaitingListSize() + 1) {
                            AsyncPoll asyncPoll = new AsyncPoll(this);
                            final Link<AsyncPoll> pollLink = new Link<AsyncPoll>(asyncPoll);
                            SafeFutureImpl<Connection> cancellableFuture = new SafeFutureImpl<Connection>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                protected void onComplete() {
                                    try {
                                        if (!this.isCancelled()) {
                                            this.get();
                                            return;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    Object object = SingleEndpointPool.this.poolSync;
                                    synchronized (object) {
                                        SingleEndpointPool.this.removeFromAsyncWaitingList(pollLink);
                                    }
                                }
                            };
                            asyncPoll.future = cancellableFuture;
                            this.addToAsyncWaitingList(pollLink);
                            isCreateNewConnection = this.checkBeforeOpeningConnection();
                            future = cancellableFuture;
                        } else {
                            errorCode = 2;
                        }
                    } else {
                        future = Futures.createReadyFuture(this.readyConnections.pollLast().getValue().connection);
                    }
                } else {
                    errorCode = 1;
                }
            }
            switch (errorCode) {
                case 0: {
                    assert (future != null);
                    if (isCreateNewConnection) {
                        this.connect();
                    }
                    return future;
                }
                case 1: {
                    return Futures.createReadyFuture(new IOException("The pool is closed"));
                }
                case 2: {
                    return Futures.createReadyFuture(new IOException("Max connections exceeded"));
                }
            }
            return Futures.createReadyFuture(new IllegalStateException("Unexpected state"));
        }
        catch (Exception e) {
            return Futures.createReadyFuture(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void take(CompletionHandler<Connection> completionHandler) {
        if (completionHandler == null) {
            throw new IllegalArgumentException("The completionHandler argument can not be null");
        }
        int errorCode = 0;
        Connection connection = null;
        boolean isCreateNewConnection = false;
        try {
            Object object = this.poolSync;
            synchronized (object) {
                if (!this.isClosed) {
                    if (this.readyConnections.isEmpty()) {
                        if (!this.failFastWhenMaxSizeReached || !this.isMaxCapacityReached() || this.pendingConnections >= this.getWaitingListSize() + 1) {
                            AsyncPoll asyncPoll = new AsyncPoll(this);
                            asyncPoll.completionHandler = completionHandler;
                            Link<AsyncPoll> pollLink = new Link<AsyncPoll>(asyncPoll);
                            this.addToAsyncWaitingList(pollLink);
                            isCreateNewConnection = this.checkBeforeOpeningConnection();
                        } else {
                            errorCode = 2;
                        }
                    } else {
                        connection = this.readyConnections.pollLast().getValue().connection;
                    }
                } else {
                    errorCode = 1;
                }
            }
            switch (errorCode) {
                case 0: {
                    if (connection != null) {
                        completionHandler.completed(connection);
                        break;
                    }
                    if (!isCreateNewConnection) break;
                    this.connect();
                    break;
                }
                case 1: {
                    completionHandler.failed(new IOException("The pool is closed"));
                    break;
                }
                case 2: {
                    completionHandler.failed(new IOException("Max connections exceeded"));
                }
            }
        }
        catch (Exception e) {
            completionHandler.failed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection poll() throws IOException {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("The pool is closed");
            }
            return !this.readyConnections.isEmpty() ? this.readyConnections.pollLast().getValue().connection : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            ConnectionInfo<E> info = this.connectionsMap.get(connection);
            if (info == null) {
                connection.closeSilently();
                return false;
            }
            return this.release0(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean release0(ConnectionInfo<E> info) {
        boolean isKeepAlive;
        AsyncPoll asyncPoller = null;
        Object object = this.poolSync;
        synchronized (object) {
            if (info.isReady()) {
                return false;
            }
            if (this.keepAliveTimeoutMillis == 0L && this.poolSize > this.corePoolSize) {
                this.detach(info.connection);
                isKeepAlive = false;
            } else {
                isKeepAlive = true;
                asyncPoller = this.getAsyncPoller();
                if (asyncPoller == null) {
                    this.readyConnections.offerLast(info.readyStateLink);
                }
            }
        }
        if (!isKeepAlive) {
            info.connection.closeSilently();
            return false;
        }
        if (asyncPoller != null) {
            Futures.notifyResult(asyncPoller.future, asyncPoller.completionHandler, info.connection);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attach(Connection connection) throws IOException {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isClosed) {
                throw new IOException("The pool is closed");
            }
            if (this.connectionsMap.containsKey(connection)) {
                return true;
            }
            if (!this.isMaxCapacityReached()) {
                this.attach0(connection);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detach(Connection connection) {
        Object object = this.poolSync;
        synchronized (object) {
            ConnectionInfo<E> info = this.connectionsMap.remove(connection);
            if (info != null) {
                connection.removeCloseListener(this.closeListener);
                this.deregisterConnection(info);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            try {
                this.isClosed = true;
                if (this.ownDelayedExecutor != null) {
                    this.ownDelayedExecutor.destroy();
                }
                if (this.ownDelayedExecutorThreadPool != null) {
                    this.ownDelayedExecutorThreadPool.shutdownNow();
                }
                int size = this.readyConnections.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    Connection c = this.readyConnections.pollLast().getValue().connection;
                    c.closeSilently();
                }
                int asyncWaitingListSize = this.asyncWaitingList.size();
                IOException exception = null;
                for (int i3 = 0; i3 < asyncWaitingListSize; ++i3) {
                    AsyncPoll asyncPoll = this.obtainFromAsyncWaitingList();
                    if (exception == null) {
                        exception = new IOException("The pool is closed");
                    }
                    try {
                        Futures.notifyFailure(asyncPoll.future, asyncPoll.completionHandler, exception);
                        continue;
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                for (Map.Entry<Connection, ConnectionInfo<E>> entry : this.connectionsMap.entrySet()) {
                    this.deregisterConnection(entry.getValue());
                }
                this.connectionsMap.clear();
            }
            finally {
                this.poolSync.notifyAll();
            }
        }
    }

    protected boolean checkBeforeOpeningConnection() {
        if (this.pendingConnections < this.asyncWaitingList.size() && !this.isMaxCapacityReached()) {
            ++this.pendingConnections;
            return true;
        }
        return false;
    }

    protected int getWaitingListSize() {
        return this.asyncWaitingList.size();
    }

    boolean isOverflown() {
        return this.maxPoolSize != -1 && this.poolSize >= this.maxPoolSize;
    }

    void onConnected(Connection connection) {
        --this.pendingConnections;
    }

    ConnectionInfo<E> attach0(Connection connection) {
        ++this.poolSize;
        ConnectionInfo info = new ConnectionInfo(connection, this);
        this.connectionsMap.put(connection, info);
        if (this.connectionTTLMillis >= 0L) {
            this.connectionTTLQueue.add(info, this.connectionTTLMillis, TimeUnit.MILLISECONDS);
        }
        connection.addCloseListener(this.closeListener);
        return info;
    }

    void onFailedConnection() {
    }

    void onCloseConnection(ConnectionInfo<E> info) {
        if (this.getWaitingListSize() > this.pendingConnections) {
            this.createConnectionIfPossibleNoSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cleanupIdleConnections(KeepAliveCleanerTask cleanerTask) {
        Object object = this.poolSync;
        synchronized (object) {
            if (this.isClosed) {
                return true;
            }
            if (!this.readyConnections.isEmpty() && this.poolSize > this.corePoolSize) {
                long now = System.currentTimeMillis();
                try {
                    Link<ConnectionInfo<E>> link;
                    while (now - (link = this.readyConnections.getFirstLink()).getAttachmentTimeStamp() >= this.keepAliveTimeoutMillis) {
                        Connection c = link.getValue().connection;
                        this.detach(c);
                        c.closeSilently();
                        if (!this.readyConnections.isEmpty() && this.poolSize > this.corePoolSize) continue;
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        cleanerTask.timeoutMillis = System.currentTimeMillis() + this.keepAliveCheckIntervalMillis;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean createConnectionIfPossible() {
        Object object = this.poolSync;
        synchronized (object) {
            return this.createConnectionIfPossibleNoSync();
        }
    }

    private boolean createConnectionIfPossibleNoSync() {
        if (this.checkBeforeOpeningConnection()) {
            this.connect();
            return true;
        }
        return false;
    }

    private void connect() {
        GrizzlyFuture<Connection> future = this.endpoint.connect();
        future.addCompletionHandler(this.defaultConnectionCompletionHandler);
        if (this.connectTimeoutMillis >= 0L) {
            ConnectTimeoutTask connectTimeoutTask = new ConnectTimeoutTask(future);
            this.connectTimeoutQueue.add(connectTimeoutTask, this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    private AsyncPoll getAsyncPoller() {
        if (!this.asyncWaitingList.isEmpty()) {
            return this.obtainFromAsyncWaitingList();
        }
        return null;
    }

    private void notifyAsyncPollersOfFailure(Throwable t2) {
        this.failedConnectAttempts = 0;
        int waitersToFail = this.getWaitingListSize() - this.pendingConnections;
        for (int i2 = 0; i2 < waitersToFail; ++i2) {
            AsyncPoll asyncPoll = this.obtainFromAsyncWaitingList();
            Futures.notifyFailure(asyncPoll.future, asyncPoll.completionHandler, t2);
        }
    }

    private void deregisterConnection(ConnectionInfo<E> info) {
        if (this.connectionTTLMillis >= 0L) {
            this.connectionTTLQueue.remove(info);
        }
        this.readyConnections.remove(info.readyStateLink);
        --this.poolSize;
        this.onCloseConnection(info);
    }

    private void addToAsyncWaitingList(Link<AsyncPoll> pollLink) {
        this.asyncWaitingList.offerLast(pollLink);
        if (this.asyncPollTimeoutMillis >= 0L) {
            this.asyncPollTimeoutQueue.add(pollLink, this.asyncPollTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    private AsyncPoll obtainFromAsyncWaitingList() {
        Link<AsyncPoll> link = this.asyncWaitingList.pollFirst();
        if (this.asyncPollTimeoutMillis >= 0L) {
            this.asyncPollTimeoutQueue.remove(link);
        }
        return link.getValue();
    }

    private boolean removeFromAsyncWaitingList(Link<AsyncPoll> pollLink) {
        boolean result = this.asyncWaitingList.remove(pollLink);
        if (result && this.asyncPollTimeoutMillis >= 0L) {
            this.asyncPollTimeoutQueue.remove(pollLink);
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "{endpoint=" + this.endpoint + ", corePoolSize=" + this.corePoolSize + ", maxPoolSize=" + this.maxPoolSize + ", poolSize=" + this.poolSize + ", isClosed=" + this.isClosed + "}";
    }

    public static class Builder<E> {
        protected Endpoint<E> endpoint;
        protected ConnectorHandler<E> connectorHandler;
        protected E endpointAddress;
        protected E localEndpointAddress;
        protected int corePoolSize;
        protected int maxPoolSize;
        protected DelayedExecutor delayedExecutor;
        protected long connectTimeoutMillis;
        protected long reconnectDelayMillis;
        protected int maxReconnectAttempts;
        protected long asyncPollTimeoutMillis;
        protected long connectionTTLMillis;
        protected boolean failFastWhenMaxSizeReached;
        protected long keepAliveTimeoutMillis;
        protected long keepAliveCheckIntervalMillis;

        protected Builder() {
            this.maxPoolSize = 4;
            this.connectTimeoutMillis = -1L;
            this.reconnectDelayMillis = -1L;
            this.maxReconnectAttempts = 5;
            this.asyncPollTimeoutMillis = -1L;
            this.connectionTTLMillis = -1L;
            this.keepAliveTimeoutMillis = 30000L;
            this.keepAliveCheckIntervalMillis = 5000L;
        }

        protected Builder(Endpoint<E> endpoint, ConnectorHandler<E> connectorHandler, E endpointAddress, E localEndpointAddress, int corePoolSize, int maxPoolSize, DelayedExecutor delayedExecutor, long connectTimeoutMillis, long reconnectDelayMillis, int maxReconnectAttempts, long asyncPollTimeoutMillis, long connectionTTLMillis, boolean failFastWhenMaxSizeReached, long keepAliveTimeoutMillis, long keepAliveCheckIntervalMillis) {
            this.endpoint = endpoint;
            this.connectorHandler = connectorHandler;
            this.endpointAddress = endpointAddress;
            this.localEndpointAddress = localEndpointAddress;
            this.corePoolSize = corePoolSize;
            this.maxPoolSize = maxPoolSize;
            this.delayedExecutor = delayedExecutor;
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.reconnectDelayMillis = reconnectDelayMillis;
            this.maxReconnectAttempts = maxReconnectAttempts;
            this.asyncPollTimeoutMillis = asyncPollTimeoutMillis;
            this.connectionTTLMillis = connectionTTLMillis;
            this.failFastWhenMaxSizeReached = failFastWhenMaxSizeReached;
            this.keepAliveTimeoutMillis = keepAliveTimeoutMillis;
            this.keepAliveCheckIntervalMillis = keepAliveCheckIntervalMillis;
        }

        public Builder<E> connectorHandler(ConnectorHandler<E> connectorHandler) {
            this.connectorHandler = connectorHandler;
            return this;
        }

        public Builder<E> endpointAddress(E endpointAddress) {
            this.endpointAddress = endpointAddress;
            return this;
        }

        public Builder<E> localEndpointAddress(E localEndpointAddress) {
            this.localEndpointAddress = localEndpointAddress;
            return this;
        }

        public Builder<E> endpoint(Endpoint<E> endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder<E> corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder<E> maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder<E> delayExecutor(DelayedExecutor delayedExecutor) {
            this.delayedExecutor = delayedExecutor;
            return this;
        }

        public Builder<E> connectTimeout(long connectTimeout, TimeUnit timeunit) {
            this.connectTimeoutMillis = connectTimeout > 0L ? TimeUnit.MILLISECONDS.convert(connectTimeout, timeunit) : connectTimeout;
            return this;
        }

        public Builder<E> reconnectDelay(long reconnectDelay, TimeUnit timeunit) {
            this.reconnectDelayMillis = reconnectDelay > 0L ? TimeUnit.MILLISECONDS.convert(reconnectDelay, timeunit) : reconnectDelay;
            return this;
        }

        public Builder<E> maxReconnectAttempts(int maxReconnectAttempts) {
            this.maxReconnectAttempts = maxReconnectAttempts;
            return this;
        }

        public Builder<E> asyncPollTimeout(long asyncPollTimeout, TimeUnit timeunit) {
            this.asyncPollTimeoutMillis = asyncPollTimeout > 0L ? TimeUnit.MILLISECONDS.convert(asyncPollTimeout, timeunit) : asyncPollTimeout;
            return this;
        }

        public Builder<E> connectionTTL(long connectionTTL, TimeUnit timeunit) {
            this.connectionTTLMillis = connectionTTL > 0L ? TimeUnit.MILLISECONDS.convert(connectionTTL, timeunit) : connectionTTL;
            return this;
        }

        public Builder<E> failFastWhenMaxSizeReached(boolean failFastWhenMaxSizeReached) {
            this.failFastWhenMaxSizeReached = failFastWhenMaxSizeReached;
            return this;
        }

        public Builder<E> keepAliveTimeout(long keepAliveTimeout, TimeUnit timeunit) {
            this.keepAliveTimeoutMillis = keepAliveTimeout > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveTimeout, timeunit) : keepAliveTimeout;
            return this;
        }

        public Builder<E> keepAliveCheckInterval(long keepAliveCheckInterval, TimeUnit timeunit) {
            this.keepAliveCheckIntervalMillis = keepAliveCheckInterval > 0L ? TimeUnit.MILLISECONDS.convert(keepAliveCheckInterval, timeunit) : keepAliveCheckInterval;
            return this;
        }

        public SingleEndpointPool<E> build() {
            Endpoint<E> e;
            if (this.endpoint == null) {
                if (this.connectorHandler == null) {
                    throw new IllegalStateException("Neither Endpoint nor ConnectorHandler is set");
                }
                if (this.endpointAddress == null) {
                    throw new IllegalStateException("Neither Endpoint nor endpoint address is set");
                }
                e = Endpoint.Factory.create(this.endpointAddress.toString() + (this.localEndpointAddress != null ? this.localEndpointAddress.toString() : ""), this.endpointAddress, this.localEndpointAddress, this.connectorHandler);
            } else {
                e = this.endpoint;
            }
            if (this.keepAliveTimeoutMillis >= 0L && this.keepAliveCheckIntervalMillis < 0L) {
                throw new IllegalStateException("Keep-alive timeout is set, but keepAliveCheckInterval is invalid");
            }
            if (this.maxReconnectAttempts < 0) {
                throw new IllegalStateException("Max reconnect attempts must not be a negative value");
            }
            return this.build0(e);
        }

        protected SingleEndpointPool<E> build0(Endpoint<E> e) {
            return new SingleEndpointPool<E>(e, this.corePoolSize, this.maxPoolSize, this.delayedExecutor, this.connectTimeoutMillis, this.keepAliveTimeoutMillis, this.keepAliveCheckIntervalMillis, this.reconnectDelayMillis, this.maxReconnectAttempts, this.asyncPollTimeoutMillis, this.connectionTTLMillis, this.failFastWhenMaxSizeReached);
        }
    }

    protected static final class ConnectionTTLTaskResolver
    implements DelayedExecutor.Resolver<ConnectionInfo> {
        protected ConnectionTTLTaskResolver() {
        }

        @Override
        public boolean removeTimeout(ConnectionInfo ci) {
            ci.ttlTimeout = -1L;
            return true;
        }

        @Override
        public long getTimeoutMillis(ConnectionInfo ci) {
            return ci.ttlTimeout;
        }

        @Override
        public void setTimeoutMillis(ConnectionInfo ci, long timeoutMillis) {
            ci.ttlTimeout = timeoutMillis;
        }
    }

    protected static final class ConnectionTTLWorker
    implements DelayedExecutor.Worker<ConnectionInfo> {
        protected ConnectionTTLWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doWork(ConnectionInfo ci) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Connection {0} TTL expired", ci.connection);
            }
            Object object = ci.endpointPool.poolSync;
            synchronized (object) {
                if (ci.isReady()) {
                    ci.connection.close();
                } else {
                    ci.endpointPool.detach(ci.connection);
                }
            }
            return true;
        }
    }

    protected static final class AsyncPoll {
        private final SingleEndpointPool pool;
        private FutureImpl<Connection> future;
        private CompletionHandler<Connection> completionHandler;
        private long timeout;

        protected AsyncPoll(SingleEndpointPool pool) {
            this.pool = pool;
        }
    }

    static final class AsyncPollTimeoutTaskResolver
    implements DelayedExecutor.Resolver<Link<AsyncPoll>> {
        AsyncPollTimeoutTaskResolver() {
        }

        @Override
        public boolean removeTimeout(Link<AsyncPoll> asyncPollLink) {
            asyncPollLink.getValue().timeout = -1L;
            return true;
        }

        @Override
        public long getTimeoutMillis(Link<AsyncPoll> asyncPollLink) {
            return asyncPollLink.getValue().timeout;
        }

        @Override
        public void setTimeoutMillis(Link<AsyncPoll> asyncPollLink, long timeoutMillis) {
            asyncPollLink.getValue().timeout = timeoutMillis;
        }
    }

    static final class AsyncPollTimeoutWorker
    implements DelayedExecutor.Worker<Link<AsyncPoll>> {
        AsyncPollTimeoutWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean doWork(Link<AsyncPoll> asyncPollLink) {
            if (asyncPollLink.isAttached()) {
                boolean removed;
                SingleEndpointPool pool = asyncPollLink.getValue().pool;
                Object object = pool.poolSync;
                synchronized (object) {
                    removed = pool.asyncWaitingList.remove(asyncPollLink);
                }
                if (removed) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "Async poll timed out for {0}", asyncPollLink.getValue());
                    }
                    AsyncPoll asyncPoll = asyncPollLink.getValue();
                    Futures.notifyFailure(asyncPoll.future, asyncPoll.completionHandler, new TimeoutException("Poll timeout expired"));
                }
            }
            return true;
        }
    }

    protected static final class ReconnectTask<E> {
        public long timeout;
        public final SingleEndpointPool<E> pool;

        public ReconnectTask(SingleEndpointPool<E> singleEndpointPool) {
            this.pool = singleEndpointPool;
        }
    }

    protected static final class ReconnectTaskResolver
    implements DelayedExecutor.Resolver<ReconnectTask> {
        protected ReconnectTaskResolver() {
        }

        @Override
        public boolean removeTimeout(ReconnectTask reconnectTask) {
            reconnectTask.timeout = -1L;
            return true;
        }

        @Override
        public long getTimeoutMillis(ReconnectTask reconnectTask) {
            return reconnectTask.timeout;
        }

        @Override
        public void setTimeoutMillis(ReconnectTask reconnectTask, long timeoutMillis) {
            reconnectTask.timeout = timeoutMillis;
        }
    }

    protected static final class Reconnector
    implements DelayedExecutor.Worker<ReconnectTask> {
        protected Reconnector() {
        }

        @Override
        public boolean doWork(ReconnectTask reconnectTask) {
            reconnectTask.pool.createConnectionIfPossibleNoSync();
            return true;
        }
    }

    protected static final class KeepAliveCleanerTask<E> {
        public long timeoutMillis;
        public final SingleEndpointPool<E> pool;

        public KeepAliveCleanerTask(SingleEndpointPool<E> singleEndpointPool) {
            this.pool = singleEndpointPool;
        }
    }

    protected static final class KeepAliveCleanerTaskResolver
    implements DelayedExecutor.Resolver<KeepAliveCleanerTask> {
        protected KeepAliveCleanerTaskResolver() {
        }

        @Override
        public boolean removeTimeout(KeepAliveCleanerTask cleanerTask) {
            cleanerTask.timeoutMillis = -1L;
            return true;
        }

        @Override
        public long getTimeoutMillis(KeepAliveCleanerTask cleanerTask) {
            return cleanerTask.timeoutMillis;
        }

        @Override
        public void setTimeoutMillis(KeepAliveCleanerTask cleanerTask, long timeoutMillis) {
            cleanerTask.timeoutMillis = timeoutMillis;
        }
    }

    protected static final class KeepAliveCleaner
    implements DelayedExecutor.Worker<KeepAliveCleanerTask> {
        protected KeepAliveCleaner() {
        }

        @Override
        public boolean doWork(KeepAliveCleanerTask cleanerTask) {
            return cleanerTask.pool.cleanupIdleConnections(cleanerTask);
        }
    }

    protected static final class ConnectTimeoutTask {
        public long timeout;
        public final GrizzlyFuture<Connection> connectFuture;

        public ConnectTimeoutTask(GrizzlyFuture<Connection> future) {
            this.connectFuture = future;
        }
    }

    protected static final class ConnectTimeoutTaskResolver
    implements DelayedExecutor.Resolver<ConnectTimeoutTask> {
        protected ConnectTimeoutTaskResolver() {
        }

        @Override
        public boolean removeTimeout(ConnectTimeoutTask connectTimeoutTask) {
            connectTimeoutTask.timeout = -1L;
            return true;
        }

        @Override
        public long getTimeoutMillis(ConnectTimeoutTask connectTimeoutTask) {
            return connectTimeoutTask.timeout;
        }

        @Override
        public void setTimeoutMillis(ConnectTimeoutTask connectTimeoutTask, long timeoutMillis) {
            connectTimeoutTask.timeout = timeoutMillis;
        }
    }

    protected static final class ConnectTimeoutWorker
    implements DelayedExecutor.Worker<ConnectTimeoutTask> {
        protected ConnectTimeoutWorker() {
        }

        @Override
        public boolean doWork(ConnectTimeoutTask connectTimeoutTask) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Pool connect timed out");
            }
            connectTimeoutTask.connectFuture.cancel(false);
            return true;
        }
    }

    private final class PoolConnectionCloseListener
    implements CloseListener<Connection, CloseType> {
        private PoolConnectionCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClosed(Connection connection, CloseType type) throws IOException {
            Object object = SingleEndpointPool.this.poolSync;
            synchronized (object) {
                ConnectionInfo info = (ConnectionInfo)SingleEndpointPool.this.connectionsMap.remove(connection);
                if (info != null) {
                    SingleEndpointPool.this.deregisterConnection(info);
                }
            }
        }
    }

    private final class ConnectCompletionHandler
    extends EmptyCompletionHandler<Connection> {
        private ConnectCompletionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Connection connection) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Pool connection is established {0}", connection);
            }
            boolean isOk = false;
            AsyncPoll asyncPoller = null;
            Object object = SingleEndpointPool.this.poolSync;
            synchronized (object) {
                if (!SingleEndpointPool.this.isClosed) {
                    SingleEndpointPool.this.failedConnectAttempts = 0;
                    SingleEndpointPool.this.onConnected(connection);
                    if (!SingleEndpointPool.this.isOverflown()) {
                        isOk = true;
                        ConnectionInfo info = SingleEndpointPool.this.attach0(connection);
                        asyncPoller = SingleEndpointPool.this.getAsyncPoller();
                        if (asyncPoller == null) {
                            SingleEndpointPool.this.readyConnections.offerLast(info.readyStateLink);
                        }
                    }
                }
            }
            if (!isOk) {
                connection.closeSilently();
            } else if (asyncPoller != null) {
                SingleEndpointPool.this.endpoint.onConnect(connection, SingleEndpointPool.this);
                Futures.notifyResult(asyncPoller.future, asyncPoller.completionHandler, connection);
            }
        }

        @Override
        public void cancelled() {
            this.onFailedToConnect(new ConnectException("Connect timeout"));
        }

        @Override
        public void failed(Throwable throwable) {
            this.onFailedToConnect(throwable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFailedToConnect(Throwable t2) {
            boolean notifyAsyncPollers = false;
            try {
                Object object = SingleEndpointPool.this.poolSync;
                synchronized (object) {
                    --SingleEndpointPool.this.pendingConnections;
                    SingleEndpointPool.this.onFailedConnection();
                    if (SingleEndpointPool.this.reconnectQueue != null && !SingleEndpointPool.this.asyncWaitingList.isEmpty()) {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Pool connect operation failed, schedule reconnect");
                        }
                        if (++SingleEndpointPool.this.failedConnectAttempts > SingleEndpointPool.this.maxReconnectAttempts) {
                            notifyAsyncPollers = true;
                        } else {
                            SingleEndpointPool.this.reconnectQueue.add(new ReconnectTask(SingleEndpointPool.this), SingleEndpointPool.this.reconnectDelayMillis, TimeUnit.MILLISECONDS);
                        }
                    } else {
                        notifyAsyncPollers = true;
                    }
                }
            }
            finally {
                if (notifyAsyncPollers) {
                    SingleEndpointPool.this.notifyAsyncPollersOfFailure(t2);
                }
            }
        }
    }
}

