/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpClientConfigDefaults;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.ProxyServerSelector;
import com.ning.http.client.Realm;
import com.ning.http.client.filter.IOExceptionFilter;
import com.ning.http.client.filter.RequestFilter;
import com.ning.http.client.filter.ResponseFilter;
import com.ning.http.util.ProxyUtils;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class AsyncHttpClientConfigBean
extends AsyncHttpClientConfig {
    public AsyncHttpClientConfigBean() {
        this.configureExecutors();
        this.configureDefaults();
        this.configureFilters();
    }

    void configureFilters() {
        this.requestFilters = new LinkedList();
        this.responseFilters = new LinkedList();
        this.ioExceptionFilters = new LinkedList();
    }

    void configureDefaults() {
        this.maxConnections = AsyncHttpClientConfigDefaults.defaultMaxConnections();
        this.maxConnectionsPerHost = AsyncHttpClientConfigDefaults.defaultMaxConnectionsPerHost();
        this.connectTimeout = AsyncHttpClientConfigDefaults.defaultConnectTimeout();
        this.webSocketTimeout = AsyncHttpClientConfigDefaults.defaultWebSocketTimeout();
        this.pooledConnectionIdleTimeout = AsyncHttpClientConfigDefaults.defaultPooledConnectionIdleTimeout();
        this.readTimeout = AsyncHttpClientConfigDefaults.defaultReadTimeout();
        this.requestTimeout = AsyncHttpClientConfigDefaults.defaultRequestTimeout();
        this.connectionTTL = AsyncHttpClientConfigDefaults.defaultConnectionTTL();
        this.followRedirect = AsyncHttpClientConfigDefaults.defaultFollowRedirect();
        this.maxRedirects = AsyncHttpClientConfigDefaults.defaultMaxRedirects();
        this.compressionEnforced = AsyncHttpClientConfigDefaults.defaultCompressionEnforced();
        this.userAgent = AsyncHttpClientConfigDefaults.defaultUserAgent();
        this.allowPoolingConnections = AsyncHttpClientConfigDefaults.defaultAllowPoolingConnections();
        this.useRelativeURIsWithConnectProxies = AsyncHttpClientConfigDefaults.defaultUseRelativeURIsWithConnectProxies();
        this.maxRequestRetry = AsyncHttpClientConfigDefaults.defaultMaxRequestRetry();
        this.ioThreadMultiplier = AsyncHttpClientConfigDefaults.defaultIoThreadMultiplier();
        this.allowPoolingSslConnections = AsyncHttpClientConfigDefaults.defaultAllowPoolingSslConnections();
        this.disableUrlEncodingForBoundRequests = AsyncHttpClientConfigDefaults.defaultDisableUrlEncodingForBoundRequests();
        this.strict302Handling = AsyncHttpClientConfigDefaults.defaultStrict302Handling();
        this.acceptAnyCertificate = AsyncHttpClientConfigDefaults.defaultAcceptAnyCertificate();
        this.sslSessionCacheSize = AsyncHttpClientConfigDefaults.defaultSslSessionCacheSize();
        this.sslSessionTimeout = AsyncHttpClientConfigDefaults.defaultSslSessionTimeout();
        if (AsyncHttpClientConfigDefaults.defaultUseProxySelector()) {
            this.proxyServerSelector = ProxyUtils.getJdkDefaultProxyServerSelector();
        } else if (AsyncHttpClientConfigDefaults.defaultUseProxyProperties()) {
            this.proxyServerSelector = ProxyUtils.createProxyServerSelector(System.getProperties());
        }
    }

    void configureExecutors() {
        this.applicationThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t2 = new Thread(r, "AsyncHttpClient-Callback");
                t2.setDaemon(true);
                return t2;
            }
        });
    }

    public AsyncHttpClientConfigBean setMaxTotalConnections(int maxTotalConnections) {
        this.maxConnections = maxTotalConnections;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxConnectionPerHost(int maxConnectionPerHost) {
        this.maxConnectionsPerHost = maxConnectionPerHost;
        return this;
    }

    public AsyncHttpClientConfigBean setConnectionTimeOut(int connectionTimeOut) {
        this.connectTimeout = connectionTimeOut;
        return this;
    }

    public AsyncHttpClientConfigBean setIdleConnectionInPoolTimeout(int idleConnectionInPoolTimeout) {
        this.pooledConnectionIdleTimeout = idleConnectionInPoolTimeout;
        return this;
    }

    public AsyncHttpClientConfigBean setStrict302Handling(boolean strict302Handling) {
        this.strict302Handling = strict302Handling;
        return this;
    }

    public AsyncHttpClientConfigBean setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public AsyncHttpClientConfigBean setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxConnectionLifeTime(int maxConnectionLifeTime) {
        this.connectionTTL = maxConnectionLifeTime;
        return this;
    }

    public AsyncHttpClientConfigBean setFollowRedirect(boolean followRedirect) {
        this.followRedirect = followRedirect;
        return this;
    }

    public AsyncHttpClientConfigBean setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    public AsyncHttpClientConfigBean setCompressionEnforced(boolean compressionEnforced) {
        this.compressionEnforced = compressionEnforced;
        return this;
    }

    public AsyncHttpClientConfigBean setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public AsyncHttpClientConfigBean setAllowPoolingConnection(boolean allowPoolingConnection) {
        this.allowPoolingConnections = allowPoolingConnection;
        return this;
    }

    public AsyncHttpClientConfigBean setApplicationThreadPool(ExecutorService applicationThreadPool) {
        if (this.applicationThreadPool != null) {
            this.applicationThreadPool.shutdownNow();
        }
        this.applicationThreadPool = applicationThreadPool;
        return this;
    }

    public AsyncHttpClientConfigBean setProxyServer(ProxyServer proxyServer) {
        this.proxyServerSelector = ProxyUtils.createProxyServerSelector(proxyServer);
        return this;
    }

    public AsyncHttpClientConfigBean setProxyServerSelector(ProxyServerSelector proxyServerSelector) {
        this.proxyServerSelector = proxyServerSelector;
        return this;
    }

    public AsyncHttpClientConfigBean setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public AsyncHttpClientConfigBean setProviderConfig(AsyncHttpProviderConfig<?, ?> providerConfig) {
        this.providerConfig = providerConfig;
        return this;
    }

    public AsyncHttpClientConfigBean setRealm(Realm realm) {
        this.realm = realm;
        return this;
    }

    public AsyncHttpClientConfigBean addRequestFilter(RequestFilter requestFilter) {
        this.requestFilters.add(requestFilter);
        return this;
    }

    public AsyncHttpClientConfigBean addResponseFilters(ResponseFilter responseFilter) {
        this.responseFilters.add(responseFilter);
        return this;
    }

    public AsyncHttpClientConfigBean addIoExceptionFilters(IOExceptionFilter ioExceptionFilter) {
        this.ioExceptionFilters.add(ioExceptionFilter);
        return this;
    }

    public AsyncHttpClientConfigBean setMaxRequestRetry(int maxRequestRetry) {
        this.maxRequestRetry = maxRequestRetry;
        return this;
    }

    public AsyncHttpClientConfigBean setAllowSslConnectionPool(boolean allowSslConnectionPool) {
        this.allowPoolingSslConnections = allowSslConnectionPool;
        return this;
    }

    public AsyncHttpClientConfigBean setDisableUrlEncodingForBoundRequests(boolean disableUrlEncodingForBoundRequests) {
        this.disableUrlEncodingForBoundRequests = disableUrlEncodingForBoundRequests;
        return this;
    }

    public AsyncHttpClientConfigBean setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
        return this;
    }

    public AsyncHttpClientConfigBean setIoThreadMultiplier(int ioThreadMultiplier) {
        this.ioThreadMultiplier = ioThreadMultiplier;
        return this;
    }

    public AsyncHttpClientConfigBean setAcceptAnyCertificate(boolean acceptAnyCertificate) {
        this.acceptAnyCertificate = acceptAnyCertificate;
        return this;
    }

    public AsyncHttpClientConfigBean setSslSessionCacheSize(Integer sslSessionCacheSize) {
        this.sslSessionCacheSize = sslSessionCacheSize;
        return this;
    }

    public AsyncHttpClientConfigBean setSslSessionTimeout(Integer sslSessionTimeout) {
        this.sslSessionTimeout = sslSessionTimeout;
        return this;
    }
}

