/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.multipart;

import com.ning.http.client.multipart.AbstractFilePart;
import com.ning.http.client.multipart.FilePartStallHandler;
import com.ning.http.client.multipart.MultipartUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;

public class ByteArrayPart
extends AbstractFilePart {
    private final byte[] bytes;

    public ByteArrayPart(String name, byte[] bytes) {
        this(name, bytes, null);
    }

    public ByteArrayPart(String name, byte[] bytes, String contentType) {
        this(name, bytes, contentType, null);
    }

    public ByteArrayPart(String name, byte[] bytes, String contentType, Charset charset) {
        this(name, bytes, contentType, charset, null);
    }

    public ByteArrayPart(String name, byte[] bytes, String contentType, Charset charset, String fileName) {
        this(name, bytes, contentType, charset, fileName, null);
    }

    public ByteArrayPart(String name, byte[] bytes, String contentType, Charset charset, String fileName, String contentId) {
        this(name, bytes, contentType, charset, fileName, contentId, null);
    }

    public ByteArrayPart(String name, byte[] bytes, String contentType, Charset charset, String fileName, String contentId, String transferEncoding) {
        super(name, contentType, charset, contentId, transferEncoding);
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        this.bytes = bytes;
        this.setFileName(fileName);
    }

    @Override
    protected void sendData(OutputStream out) throws IOException {
        out.write(this.bytes);
    }

    @Override
    protected long getDataLength() {
        return this.bytes.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(WritableByteChannel target, byte[] boundary) throws IOException {
        FilePartStallHandler handler = new FilePartStallHandler(this.getStalledTime(), this);
        try {
            handler.start();
            long length = MultipartUtils.writeBytesToChannel(target, this.generateFileStart(boundary));
            length += MultipartUtils.writeBytesToChannel(target, this.bytes);
            long l = length += MultipartUtils.writeBytesToChannel(target, this.generateFileEnd());
            return l;
        }
        finally {
            handler.completed();
        }
    }
}

